/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.registry;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.entity.EntityMageLight;
import com.windanesz.ancientspellcraft.entity.EntityVolcano;
import com.windanesz.ancientspellcraft.entity.EntityWisp;
import com.windanesz.ancientspellcraft.entity.construct.EntityAntiMagicField;
import com.windanesz.ancientspellcraft.entity.construct.EntitySilencingSigil;
import com.windanesz.ancientspellcraft.entity.construct.EntitySpiritWard;
import com.windanesz.ancientspellcraft.entity.construct.EntityTransportationPortal;
import com.windanesz.ancientspellcraft.entity.construct.EntityVenusFlyTrap;
import com.windanesz.ancientspellcraft.entity.living.EntityFireAnt;
import com.windanesz.ancientspellcraft.entity.living.EntitySkeletonHorseMinion;
import com.windanesz.ancientspellcraft.entity.living.EntitySkeletonMageMinion;
import com.windanesz.ancientspellcraft.entity.living.EntitySpiritBear;
import com.windanesz.ancientspellcraft.entity.living.EntityVoidCreeper;
import com.windanesz.ancientspellcraft.entity.living.EntityWolfMinion;
import com.windanesz.ancientspellcraft.entity.projectile.EntityDevoritiumArrow;
import com.windanesz.ancientspellcraft.entity.projectile.EntityDevoritiumBomb;
import com.windanesz.ancientspellcraft.entity.projectile.EntityDispelMagic;
import com.windanesz.ancientspellcraft.entity.projectile.EntityFlint;
import com.windanesz.ancientspellcraft.entity.projectile.EntityHeart;
import com.windanesz.ancientspellcraft.entity.projectile.EntityManaVortex;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class AncientSpellcraftEntities {
    private static final int VOID_CREEPER_SPAWN_RATE = 30;
    private static int id = 0;

    private AncientSpellcraftEntities() {
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<EntityEntry> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)AncientSpellcraftEntities.createEntry(EntityWisp.class, "will_o_wisp", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)AncientSpellcraftEntities.createEntry(EntityMageLight.class, "mage_light_entity", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)AncientSpellcraftEntities.createEntry(EntityHeart.class, "healing_heart", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)AncientSpellcraftEntities.createEntry(EntityDispelMagic.class, "dispel_magic", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)AncientSpellcraftEntities.createEntry(EntityManaVortex.class, "wizard_blast").tracker(160, 3, false).build());
        registry.register((IForgeRegistryEntry)AncientSpellcraftEntities.createEntry(EntityDevoritiumBomb.class, "devoritium_bomb", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)AncientSpellcraftEntities.createEntry(EntityDevoritiumArrow.class, "devoritium_arrow", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)AncientSpellcraftEntities.createEntry(EntityFlint.class, "flint_projectile", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)AncientSpellcraftEntities.createEntry(EntityVoidCreeper.class, "void_creeper", TrackingType.LIVING).egg(2562875, 8336891).spawn(EnumCreatureType.MONSTER, Settings.generalSettings.void_creeper_spawn_rate, 1, 1, (Iterable)ForgeRegistries.BIOMES.getValuesCollection().stream().filter(b -> !Arrays.asList(AncientSpellcraft.settings.voidCreeperBiomeBlacklist).contains(b.getRegistryName())).collect(Collectors.toSet())).build());
        registry.register((IForgeRegistryEntry)AncientSpellcraftEntities.createEntry(EntitySkeletonMageMinion.class, "skeleton_mage_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)AncientSpellcraftEntities.createEntry(EntityWolfMinion.class, "wolf_minion", TrackingType.LIVING).egg(13397831, 0x676767).build());
        registry.register((IForgeRegistryEntry)AncientSpellcraftEntities.createEntry(EntitySpiritBear.class, "spirit_bear", TrackingType.LIVING).egg(12370664, 0xFFFFFF).build());
        registry.register((IForgeRegistryEntry)AncientSpellcraftEntities.createEntry(EntityVenusFlyTrap.class, "venus_fly_trap", TrackingType.LIVING).egg(12370664, 0xFFFFFF).build());
        registry.register((IForgeRegistryEntry)AncientSpellcraftEntities.createEntry(EntityFireAnt.class, "fire_ant", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)AncientSpellcraftEntities.createEntry(EntitySkeletonHorseMinion.class, "skeleton_horse_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)AncientSpellcraftEntities.createEntry(EntityTransportationPortal.class, "transportation_portal", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)AncientSpellcraftEntities.createEntry(EntitySpiritWard.class, "spirit_ward", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)AncientSpellcraftEntities.createEntry(EntitySilencingSigil.class, "silencing_sigil", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)AncientSpellcraftEntities.createEntry(EntityVolcano.class, "entity_volcano", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)AncientSpellcraftEntities.createEntry(EntityAntiMagicField.class, "anti_magic_field", TrackingType.CONSTRUCT).build());
    }

    private static <T extends Entity> EntityEntryBuilder<T> createEntry(Class<T> entityClass, String name, TrackingType tracking) {
        return AncientSpellcraftEntities.createEntry(entityClass, name).tracker(tracking.range, tracking.interval, tracking.trackVelocity);
    }

    private static <T extends Entity> EntityEntryBuilder<T> createEntry(Class<T> entityClass, String name) {
        ResourceLocation registryName = new ResourceLocation("ancientspellcraft", name);
        return EntityEntryBuilder.create().entity(entityClass).id(registryName, id++).name(registryName.toString());
    }

    static enum TrackingType {
        LIVING(80, 3, true),
        PROJECTILE(64, 1, true),
        CONSTRUCT(160, 10, false);

        int range;
        int interval;
        boolean trackVelocity;

        private TrackingType(int range, int interval, boolean trackVelocity) {
            this.range = range;
            this.interval = interval;
            this.trackVelocity = trackVelocity;
        }
    }
}

