/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.RayTracer;
import electroblob.wizardry.util.SpellModifiers;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ArcaneBeam
extends SpellRay {
    public ArcaneBeam() {
        super("ancientspellcraft", "arcane_beam", SpellActions.POINT, true);
        this.addProperties(new String[]{"damage"});
        this.aimAssist(0.6f);
        this.particleSpacing = 0.3;
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (target instanceof EntityLivingBase) {
            if (MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.MAGIC, (Entity)target)) {
                if (!world.field_72995_K && ticksInUse == 1 && caster instanceof EntityPlayer) {
                    ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}), true);
                }
            } else {
                EntityUtils.attackEntityWithoutKnockback((Entity)target, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.MAGIC), (float)(this.getProperty("damage").floatValue() * modifiers.get("potency")));
            }
        }
        return true;
    }

    public static Predicate<Entity> ignoreEntityFilterWithCaster(Entity entity, Entity caster) {
        return e -> e == entity || e instanceof EntityLivingBase && ((EntityLivingBase)e).func_110143_aJ() <= 0.0f || e == caster;
    }

    protected SoundEvent[] createSounds() {
        return this.createContinuousSpellSounds();
    }

    protected void playSound(World world, EntityLivingBase entity, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, entity, ticksInUse);
    }

    protected void playSound(World world, double x, double y, double z, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    protected boolean shootSpell(World world, Vec3d origin, Vec3d direction, @Nullable EntityLivingBase caster, int ticksInUse, SpellModifiers modifiers) {
        if (!(caster instanceof EntityPlayer)) {
            return false;
        }
        double range = this.getRange(world, origin, direction, caster, ticksInUse, modifiers);
        Vec3d endpoint = origin.func_178787_e(direction.func_186678_a(range));
        RayTraceResult primaryTarget = RayTracer.rayTrace((World)world, (Vec3d)origin, (Vec3d)endpoint, (float)this.aimAssist, (boolean)this.hitLiquids, (boolean)this.ignoreUncollidables, (boolean)false, Entity.class, (Predicate)(this.ignoreLivingEntities ? EntityUtils::isLiving : RayTracer.ignoreEntityFilter((Entity)caster)));
        boolean flag = false;
        if (primaryTarget != null) {
            if (primaryTarget.field_72313_a == RayTraceResult.Type.ENTITY) {
                RayTraceResult secondaryTarget;
                flag = this.onEntityHit(world, primaryTarget.field_72308_g, primaryTarget.field_72307_f, caster, origin, ticksInUse, modifiers);
                range = origin.func_72438_d(primaryTarget.field_72307_f);
                if (ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)caster), (Item)AncientSpellcraftItems.ring_focus_crystal) && (secondaryTarget = RayTracer.rayTrace((World)world, (Vec3d)origin, (Vec3d)endpoint, (float)this.aimAssist, (boolean)this.hitLiquids, (boolean)this.ignoreUncollidables, (boolean)false, Entity.class, this.ignoreLivingEntities ? EntityUtils::isLiving : ArcaneBeam.ignoreEntityFilterWithCaster(primaryTarget.field_72308_g, (Entity)caster))) != null && secondaryTarget.field_72313_a == RayTraceResult.Type.ENTITY) {
                    flag = this.onEntityHit(world, secondaryTarget.field_72308_g, secondaryTarget.field_72307_f, caster, origin, ticksInUse, modifiers);
                    range = origin.func_72438_d(secondaryTarget.field_72307_f);
                }
            } else if (primaryTarget.field_72313_a == RayTraceResult.Type.BLOCK) {
                flag = this.onBlockHit(world, primaryTarget.func_178782_a(), primaryTarget.field_178784_b, primaryTarget.field_72307_f, caster, origin, ticksInUse, modifiers);
                range = origin.func_72438_d(primaryTarget.field_72307_f);
            }
        }
        if (!flag && !this.onMiss(world, caster, origin, direction, ticksInUse, modifiers)) {
            return false;
        }
        if (world.field_72995_K) {
            this.spawnParticleRay(world, origin, direction, caster, range);
        }
        return true;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(x, y, z).vel(vx, vy, vz).collide(true).scale(0.3f).spawn(world);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(x, y, z).clr(187, 87, 205).vel(vx, vy, vz).collide(true).spawn(world);
    }

    @SideOnly(value=Side.CLIENT)
    public String getDisplayNameWithFormatting() {
        return TextFormatting.GOLD + I18n.func_135052_a((String)this.getTranslationKey(), (Object[])new Object[0]);
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }
}

