/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class AttireAlteration
extends Spell {
    private static final int REPAIR_RATE = 1;
    public static final IStoredVariable<ItemStack> HEAD_SLOT = IStoredVariable.StoredVariable.ofItemStack((String)"attire_head_slot", (Persistence)Persistence.ALWAYS).withTicker(AttireAlteration::update);
    public static final IStoredVariable<ItemStack> CHEST_SLOT = IStoredVariable.StoredVariable.ofItemStack((String)"attire_chest_slot", (Persistence)Persistence.ALWAYS).withTicker(AttireAlteration::update);
    public static final IStoredVariable<ItemStack> LEGS_SLOT = IStoredVariable.StoredVariable.ofItemStack((String)"attire_legs_slot", (Persistence)Persistence.ALWAYS).withTicker(AttireAlteration::update);
    public static final IStoredVariable<ItemStack> FEET_SLOT = IStoredVariable.StoredVariable.ofItemStack((String)"attire_feet_slot", (Persistence)Persistence.ALWAYS).withTicker(AttireAlteration::update);

    public AttireAlteration() {
        super("ancientspellcraft", "attire_alteration", EnumAction.BLOCK, false);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{HEAD_SLOT, CHEST_SLOT, LEGS_SLOT, FEET_SLOT});
    }

    public boolean cast(World world, EntityPlayer player, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        WizardData data = WizardData.get((EntityPlayer)player);
        if (world.field_72995_K) {
            this.playSound(world, (EntityLivingBase)player, ticksInUse, -1, modifiers, new String[0]);
        }
        if (data != null) {
            ItemStack storedHead = (ItemStack)data.getVariable(HEAD_SLOT);
            ItemStack storedChest = (ItemStack)data.getVariable(CHEST_SLOT);
            ItemStack storedLegs = (ItemStack)data.getVariable(LEGS_SLOT);
            ItemStack storedFeet = (ItemStack)data.getVariable(FEET_SLOT);
            data.setVariable(HEAD_SLOT, (Object)player.func_184582_a(EntityEquipmentSlot.HEAD));
            data.setVariable(CHEST_SLOT, (Object)player.func_184582_a(EntityEquipmentSlot.CHEST));
            data.setVariable(LEGS_SLOT, (Object)player.func_184582_a(EntityEquipmentSlot.LEGS));
            data.setVariable(FEET_SLOT, (Object)player.func_184582_a(EntityEquipmentSlot.FEET));
            if (storedHead != null) {
                player.func_184201_a(EntityEquipmentSlot.HEAD, storedHead);
            }
            if (storedChest != null) {
                player.func_184201_a(EntityEquipmentSlot.CHEST, storedChest);
            }
            if (storedLegs != null) {
                player.func_184201_a(EntityEquipmentSlot.LEGS, storedLegs);
            }
            if (storedFeet != null) {
                player.func_184201_a(EntityEquipmentSlot.FEET, storedFeet);
            }
            if (world.field_72995_K) {
                this.spawnParticles(world, (EntityLivingBase)player, modifiers);
            }
        }
        return true;
    }

    private void spawnParticles(World world, EntityLivingBase caster, SpellModifiers modifiers) {
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BUFF).entity((Entity)caster).clr(1, 72, 0).spawn(world);
    }

    private static ItemStack update(EntityPlayer player, ItemStack stack) {
        if (!player.field_70170_p.field_72995_K && player.field_70173_aa % 200 == 0 && ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)AncientSpellcraftItems.charm_enchanted_needle) && stack != null && stack != ItemStack.field_190927_a && stack.func_77973_b() instanceof IManaStoringItem) {
            ((IManaStoringItem)stack.func_77973_b()).rechargeMana(stack, 2);
        }
        return stack;
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spellcraft_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }
}

