/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftPotions;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class CurseArmor
extends SpellRay {
    public CurseArmor(String modID, String name, EnumAction action, boolean isContinuous) {
        super(modID, name, SpellActions.THRUST, false);
        this.soundValues(1.0f, 1.1f, 0.2f);
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (EntityUtils.isLiving((Entity)target) && !world.field_72995_K && target instanceof EntityLivingBase) {
            EntityLivingBase livingTarget = (EntityLivingBase)target;
            if (livingTarget.func_70644_a(AncientSpellcraftPotions.curse_ward) || livingTarget instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)livingTarget), (Item)AncientSpellcraftItems.amulet_curse_ward)) {
                return false;
            }
            ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
            for (ItemStack stack : livingTarget.func_184193_aE()) {
                if (!(stack.func_77973_b() instanceof ItemArmor)) continue;
                itemStackList.add(stack);
            }
            if (!itemStackList.isEmpty()) {
                ItemStack itemToCurse = ASUtils.pickRandomStackFromItemStackList(itemStackList);
                return CurseArmor.attemptCurseItemStack(itemToCurse);
            }
            return false;
        }
        return false;
    }

    private static boolean attemptCurseItemStack(ItemStack stack) {
        ArrayList<Enchantment> validCurseList = new ArrayList<Enchantment>();
        if (!EnchantmentHelper.func_190939_c((ItemStack)stack)) {
            validCurseList.add(Enchantments.field_190940_C);
        }
        if (!EnchantmentHelper.func_190938_b((ItemStack)stack)) {
            validCurseList.add(Enchantments.field_190941_k);
        }
        if (!validCurseList.isEmpty()) {
            Random rand = new Random();
            try {
                stack.func_77966_a((Enchantment)validCurseList.get(rand.nextInt(validCurseList.size())), 1);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(5709413).spawn(world);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SCORCH).pos(x, y, z).clr(2430473).spawn(world);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).time(12 + world.field_73012_v.nextInt(8)).clr(740160).spawn(world);
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spellcraft_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }
}

