/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftPotions;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Martyr
extends SpellRay {
    public static final IStoredVariable<Set<UUID>> MARTYR_BOUND_CREATURES = new IStoredVariable.StoredVariable("martyrBoundCreatures", s -> NBTExtras.listToNBT((Collection)s, NBTUtil::func_186862_a), t -> new HashSet(NBTExtras.NBTToList((NBTTagList)t, NBTUtil::func_186860_b)), Persistence.DIMENSION_CHANGE);

    public Martyr() {
        super("ancientspellcraft", "martyr", SpellActions.POINT, false);
        this.soundValues(1.0f, 1.1f, 0.2f);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{MARTYR_BOUND_CREATURES});
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        WizardData data;
        if (EntityUtils.isLiving((Entity)target) && caster instanceof EntityPlayer && (data = WizardData.get((EntityPlayer)((EntityPlayer)caster))) != null) {
            if (Martyr.getMartyrBoundEntities(data).add(target.func_110124_au())) {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(AncientSpellcraftPotions.martyr_beneficial, 1200));
                caster.func_70690_d(new PotionEffect(AncientSpellcraftPotions.martyr, 1200));
            } else {
                return false;
            }
        }
        return true;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(0.4f, 0.0f, 0.0f).spawn(world);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(0.1f, 0.0f, 0.0f).spawn(world);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).time(12 + world.field_73012_v.nextInt(8)).clr(1.0f, 0.8f, 1.0f).spawn(world);
    }

    public static Set<UUID> getMartyrBoundEntities(WizardData data) {
        if (data.getVariable(MARTYR_BOUND_CREATURES) == null) {
            HashSet<UUID> result = new HashSet<UUID>();
            data.setVariable(MARTYR_BOUND_CREATURES, result);
            return result;
        }
        return (Set)data.getVariable(MARTYR_BOUND_CREATURES);
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spellcraft_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }
}

