/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;

public class WarpWood
extends SpellRay {
    public WarpWood() {
        super("ancientspellcraft", "warp_wood", SpellActions.POINT, false);
        this.ignoreLivingEntities(true);
        this.particleSpacing(0.5);
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster instanceof EntityPlayer) {
            if (caster.func_184614_ca().func_77973_b() instanceof ISpellCastingItem) {
                caster.func_184609_a(EnumHand.MAIN_HAND);
            } else if (caster.func_184592_cb().func_77973_b() instanceof ISpellCastingItem) {
                caster.func_184609_a(EnumHand.OFF_HAND);
            }
        }
        if (!world.field_72995_K) {
            if (BlockUtils.isBlockUnbreakable((World)world, (BlockPos)pos)) {
                return false;
            }
            if (!(caster instanceof EntityPlayer) && !EntityUtils.canDamageBlocks((Entity)caster, (World)world)) {
                return false;
            }
            if (world.func_175625_s(pos) != null && world.func_175625_s(pos).getTileData().func_186855_b("arcaneLockOwner")) {
                return false;
            }
            IBlockState state = world.func_180495_p(pos);
            if (world.func_180495_p(pos).func_185904_a() != Material.field_151575_d || world.func_180495_p(pos).func_185904_a() != Material.field_151584_j) {
                return false;
            }
            boolean flag = false;
            int blastUpgradeCount = (int)((modifiers.get(WizardryItems.blast_upgrade) - 1.0f) / 0.25f + 0.5f);
            float radius = 0.5f + 0.73f * (float)blastUpgradeCount;
            List sphere = BlockUtils.getBlockSphere((BlockPos)pos, (double)radius);
            for (BlockPos pos1 : BlockPos.func_177980_a((BlockPos)pos.func_177967_a(EnumFacing.DOWN, 2 + blastUpgradeCount), (BlockPos)pos.func_177967_a(EnumFacing.UP, 2 + blastUpgradeCount))) {
                if (BlockUtils.isBlockUnbreakable((World)world, (BlockPos)pos1)) continue;
                IBlockState state1 = world.func_180495_p(pos1);
                if (caster instanceof EntityPlayerMP) {
                    int xp;
                    boolean silkTouch;
                    boolean bl = silkTouch = state1.func_177230_c().canSilkHarvest(world, pos1, state1, (EntityPlayer)caster) && ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)caster), (Item)WizardryItems.charm_silk_touch);
                    if (ForgeEventFactory.getBreakSpeed((EntityPlayer)((EntityPlayer)caster), (IBlockState)state1, (float)1.0f, (BlockPos)pos1) <= 0.0f || (xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((EntityPlayerMP)caster).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)caster), (BlockPos)pos1)) == -1) continue;
                    if (silkTouch) {
                        flag = world.func_175655_b(pos1, false);
                        if (!flag) continue;
                        Block.func_180635_a((World)world, (BlockPos)pos1, (ItemStack)WarpWood.getSilkTouchDrop(state1));
                        continue;
                    }
                    flag = world.func_175655_b(pos1, true);
                    if (!flag) continue;
                    state1.func_177230_c().func_180637_b(world, pos1, xp);
                    continue;
                }
                return false;
            }
            return flag;
        }
        return false;
    }

    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.LEAF).pos(x, y, z).time(20 + world.field_73012_v.nextInt(5)).clr(0.9f, 0.95f, 1.0f).spawn(world);
    }

    private static ItemStack getSilkTouchDrop(IBlockState state) {
        Item item = Item.func_150898_a((Block)state.func_177230_c());
        int i = 0;
        if (item.func_77614_k()) {
            i = state.func_177230_c().func_176201_c(state);
        }
        return new ItemStack(item, 1, i);
    }
}

