/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.entity.EntityWisp;
import com.windanesz.ancientspellcraft.item.ItemEnchantedNameTag;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import com.windanesz.ancientspellcraft.util.ASUtils;
import com.windanesz.ancientspellcraft.util.BiomeLocator;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class WillOWisp
extends Spell {
    public WillOWisp(String modID, String name) {
        super(modID, name, EnumAction.BLOCK, false);
        this.addProperties(new String[]{"range"});
        this.soundValues(1.0f, 1.2f, 0.3f);
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        WizardData data = WizardData.get((EntityPlayer)caster);
        double maxRange = (double)this.getProperty("range").floatValue() * Math.pow(modifiers.get(WizardryItems.range_upgrade), 3.0);
        ItemStack offhand = caster.func_184592_cb();
        if (caster.func_130014_f_().field_73011_w.getDimension() == 0) {
            if (!offhand.func_190926_b() && offhand.func_77973_b() instanceof ItemEnchantedNameTag) {
                String nameTag;
                if (!offhand.func_77942_o()) {
                    if (!world.field_72995_K) {
                        caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:will_o_wisp.tag_has_no_name", new Object[0]), true);
                    }
                    return false;
                }
                try {
                    nameTag = caster.func_184592_cb().func_77978_p().func_74775_l("display").func_74779_i("Name");
                }
                catch (Exception e) {
                    if (!world.field_72995_K) {
                        caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:will_o_wisp.tag_has_no_name", new Object[0]), true);
                    }
                    return false;
                }
                if (offhand.func_77973_b().getMaxDamage(offhand) - offhand.func_77973_b().getDamage(offhand) < 50) {
                    if (!world.field_72995_K) {
                        caster.func_146105_b((ITextComponent)new TextComponentTranslation("The Enchanted Name Tag doesn't have enough charge", new Object[0]), true);
                    }
                    return false;
                }
                if (ASUtils.isBiomeNameRegistered(nameTag)) {
                    double distFromCaster;
                    if (!world.field_72995_K) {
                        caster.func_146105_b((ITextComponent)new TextComponentTranslation("Searching for biome ...", new Object[0]), true);
                    }
                    ResourceLocation biomeResourceLocation = ASUtils.getBiomeRegistryNameFromName(nameTag);
                    BlockPos biomePos = BiomeLocator.spiralOutwardsLookingForBiome(world, (Biome)ForgeRegistries.BIOMES.getValue(biomeResourceLocation), caster.field_70165_t, caster.field_70161_v);
                    if (!world.field_72995_K && (distFromCaster = Math.sqrt(biomePos.func_177954_c(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v))) > maxRange) {
                        caster.func_146105_b((ITextComponent)new TextComponentTranslation("Biome is too far away, wand range upgrades can increase the search radius", new Object[0]), true);
                        return false;
                    }
                    ((ItemEnchantedNameTag)caster.func_184592_cb().func_77973_b()).consumeMana(caster.func_184592_cb(), 50, (EntityLivingBase)caster);
                    this.createWisp(world, caster, hand, biomePos, offhand.func_77978_p(), offhand.func_77952_i());
                    this.playSound(world, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, 0, 0, modifiers, new String[0]);
                    if (!world.field_72995_K) {
                        caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:will_o_wisp.sent_to_biome", new Object[]{nameTag}), true);
                    }
                    caster.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
                    return true;
                }
                if (!world.field_72995_K && data.hasSpellBeenDiscovered((Spell)this)) {
                    caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:will_o_wisp.invalid_biome_name_in_tag", new Object[0]), true);
                }
                caster.func_145747_a((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:will_o_wisp.try_listbiomes", new Object[0]));
                return false;
            }
            if (!world.field_72995_K && data.hasSpellBeenDiscovered((Spell)this)) {
                caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:will_o_wisp.no_name_tag", new Object[0]), true);
            }
        }
        return false;
    }

    public void createWisp(World world, EntityPlayer player, EnumHand hand, BlockPos targetPos, NBTTagCompound nameTagStackTag, int nameTagDamage) {
        Random rand = new Random();
        if (!world.field_72995_K && targetPos != null) {
            EntityWisp entitywisp = new EntityWisp(world, player.field_70165_t, player.field_70163_u + (double)(player.field_70131_O / 2.0f), player.field_70161_v);
            entitywisp.moveTowards(targetPos, player);
            entitywisp.setEnchantedNameTag(nameTagStackTag, nameTagDamage);
            world.func_72838_d((Entity)entitywisp);
        }
    }

    public boolean hasCustomName(ItemStack nameTag) {
        NBTTagCompound tag = nameTag.func_77978_p();
        return !tag.func_74779_i("name").isEmpty();
    }

    public boolean hasEnoughMana(ItemStack nameTag) {
        return nameTag.func_77958_k() - nameTag.func_77952_i() >= 100;
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spellcraft_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }
}

