/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.tileentity;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.client.gui.ContainerSphereCognizance;
import com.windanesz.ancientspellcraft.item.ItemRelic;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftBlocks;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.event.DiscoverSpellEvent;
import electroblob.wizardry.item.ItemCrystal;
import electroblob.wizardry.item.ItemScroll;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.NBTExtras;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileSphereCognizance
extends TileEntity
implements IInventory,
ITickable {
    private NonNullList<ItemStack> inventory;
    private int researchDuration;
    private int researchProgress;
    public int currentHintId = 0;
    public int currentHintTypeId = 0;
    private boolean changedResearchState = false;
    private boolean inUse = false;
    private EntityPlayer currentPlayer;
    private WizardData playerWizardData;
    private NonNullList<ItemStack> furnaceItemStacks = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    public int tickCount;
    public float pageFlip;
    public float pageFlipPrev;
    public float flipT;
    public float flipA;
    public float bookSpread;
    public float sphereRotation;
    public float sphereRotationPrev;
    public float tRot;

    public WizardData getPlayerWizardData() {
        return this.playerWizardData;
    }

    public TileSphereCognizance() {
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    public void setInUse(boolean inUse) {
        this.inUse = inUse;
    }

    public EntityPlayer getCurrentPlayer() {
        return this.currentPlayer;
    }

    public void setCurrentPlayer(EntityPlayer currentPlayer) {
        this.currentPlayer = currentPlayer;
    }

    public String func_70005_c_() {
        return "container.ancientspellcraft:sphere_cognizance";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList inventoryList = compound.func_150295_c("Inventory", 10);
        for (int i = 0; i < inventoryList.func_74745_c(); ++i) {
            NBTTagCompound tag = inventoryList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.func_70299_a(slot, new ItemStack(tag));
        }
        this.researchDuration = compound.func_74765_d("researchDuration");
        this.researchProgress = compound.func_74765_d("researchProgress");
        this.currentHintId = compound.func_74765_d("currentHintId");
        this.currentHintTypeId = compound.func_74765_d("currentHintTypeId");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagList inventoryList = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            inventoryList.func_74742_a((NBTBase)tag);
        }
        compound.func_74768_a("researchDuration", (int)((short)this.researchDuration));
        compound.func_74768_a("researchProgress", (int)((short)this.researchProgress));
        compound.func_74768_a("currentHintId", (int)((short)this.currentHintId));
        compound.func_74768_a("currentHintTypeId", (int)((short)this.currentHintTypeId));
        NBTExtras.storeTagSafely((NBTTagCompound)compound, (String)"Inventory", (NBTBase)inventoryList);
        return compound;
    }

    public final NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB cbb;
        AxisAlignedBB bb = INFINITE_EXTENT_AABB;
        Block type = this.func_145838_q();
        if (type == AncientSpellcraftBlocks.SPHERE_COGNIZANCE) {
            bb = new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1));
        } else if (type != null && (cbb = this.func_145831_w().func_180495_p(this.field_174879_c).func_185900_c((IBlockAccess)this.field_145850_b, this.field_174879_c)) != null) {
            bb = cbb;
        }
        return bb;
    }

    private boolean canBeginResearch() {
        return (this.isResearchFinished() || this.researchProgress == 0) && this.hasSomethingToResearch() && this.hasCrystalForFuel();
    }

    private boolean isResearchFinished() {
        return this.researchProgress != 0 && this.researchProgress == this.researchDuration;
    }

    private boolean isCurrentBookKnown() {
        if (this.getCurrentSpell() != null) {
            return this.playerWizardData.hasSpellBeenDiscovered(this.getCurrentSpell());
        }
        return false;
    }

    public Spell getCurrentSpell() {
        if (this.getInputStack().func_77952_i() != Short.MAX_VALUE) {
            return Spell.byMetadata((int)this.getInputStack().func_77952_i());
        }
        return null;
    }

    public ItemStack getCrystalStack() {
        return (ItemStack)this.inventory.get(0);
    }

    public ItemStack getInputStack() {
        return (ItemStack)this.inventory.get(1);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean func_174903_a(IInventory parIInventory) {
        return true;
    }

    public void func_73660_a() {
        float f2;
        this.sphereRotationPrev = this.sphereRotation;
        EntityPlayer entityplayer = this.field_145850_b.func_184137_a((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), 2.5, false);
        this.tRot += 0.02f;
        this.bookSpread -= 0.1f;
        while (this.sphereRotation >= (float)Math.PI) {
            this.sphereRotation -= (float)Math.PI * 2;
        }
        while (this.sphereRotation < (float)(-Math.PI)) {
            this.sphereRotation += (float)Math.PI * 2;
        }
        while (this.tRot >= (float)Math.PI) {
            this.tRot -= (float)Math.PI * 2;
        }
        while (this.tRot < (float)(-Math.PI)) {
            this.tRot += (float)Math.PI * 2;
        }
        for (f2 = this.tRot - this.sphereRotation; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        this.sphereRotation += f2 * 0.4f;
        if (this.getInputStack().func_190926_b()) {
            this.researchProgress = 0;
            this.setResearchDuration(0);
        }
        if (!this.field_145850_b.field_72995_K && this.inUse && this.currentPlayer != null) {
            if (this.hasSomethingToResearch()) {
                if (this.shouldReseach()) {
                    this.progressResearch();
                    if (this.researchProgress >= this.researchDuration) {
                        this.onResearchComplete();
                    }
                    this.changedResearchState = true;
                }
            } else {
                this.researchProgress = 0;
            }
        }
        if (this.changedResearchState) {
            this.func_70296_d();
        }
    }

    public void setResearchDuration() {
        this.researchDuration = this.getInputStack().func_77973_b() instanceof ItemRelic ? 20 : TileSphereCognizance.getResearchDuration(this.getCurrentSpell());
        this.func_70296_d();
    }

    public void setResearchDuration(int duration) {
        this.researchDuration = duration;
        this.func_70296_d();
    }

    public boolean shouldReseach() {
        return this.researchProgress != 0 && this.researchDuration > this.researchProgress;
    }

    public void progressResearch() {
        ++this.researchProgress;
    }

    public void onResearchComplete() {
        boolean spellItem;
        double special = AncientSpellcraft.rand.nextDouble();
        boolean bl = spellItem = this.getInputStack().func_77973_b() instanceof ItemSpellBook || this.getInputStack().func_77973_b() instanceof ItemScroll;
        if (!spellItem) {
            this.currentHintTypeId = 24;
            int count = ContainerSphereCognizance.HINTS_COUNT.get("ancient_knowledge");
            this.currentHintId = ASUtils.randIntBetween(1, count);
            if (this.currentPlayer != null && !this.field_145850_b.field_72995_K) {
                ItemRelic.setRandomContentType(this.getInputStack(), this.currentPlayer);
            }
            this.func_70296_d();
            return;
        }
        if (special < Settings.generalSettings.sphere_spell_identification_chance) {
            int id;
            this.currentHintTypeId = 2;
            int count = ContainerSphereCognizance.HINTS_COUNT.get("discovered");
            this.currentHintId = id = ASUtils.randIntBetween(1, count);
            if (!MinecraftForge.EVENT_BUS.post((Event)new DiscoverSpellEvent(this.getCurrentPlayer(), this.getCurrentSpell(), DiscoverSpellEvent.Source.OTHER))) {
                if (this.getPlayerWizardData().discoverSpell(this.getCurrentSpell()) && !this.field_145850_b.field_72995_K) {
                    this.playerWizardData.sync();
                }
                this.getCurrentPlayer().func_184185_a(WizardrySounds.MISC_DISCOVER_SPELL, 1.25f, 1.0f);
                if (!this.field_145850_b.field_72995_K) {
                    this.getCurrentPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("spell.discover", new Object[]{this.getCurrentSpell().getNameForTranslationFormatted()}));
                }
                this.setPlayerWizardData(this.currentPlayer);
            }
        } else if (special < 0.4) {
            int id;
            this.currentHintTypeId = 1;
            int count = ContainerSphereCognizance.HINTS_COUNT.get("failed");
            this.currentHintId = id = ASUtils.randIntBetween(1, count);
        } else {
            int i;
            Spell spell = this.getCurrentSpell();
            String name = spell.getUnlocalisedName();
            String type = spell.getType().getUnlocalisedName();
            String element = spell.getElement().func_176610_l();
            boolean t = ContainerSphereCognizance.HINT_TYPES.contains(type);
            boolean n = ContainerSphereCognizance.HINT_TYPES.contains(name);
            boolean e = ContainerSphereCognizance.HINT_TYPES.contains(element);
            ArrayList<String> list = new ArrayList<String>(){};
            if (n) {
                i = ContainerSphereCognizance.HINTS_COUNT.get(name);
                list.add(name);
            }
            if (t) {
                i = ContainerSphereCognizance.HINTS_COUNT.get(type);
                list.add(type);
            }
            if (e) {
                i = ContainerSphereCognizance.HINTS_COUNT.get(element);
                list.add(element);
            }
            String selected = ASUtils.getRandomListItem(list);
            int count = ContainerSphereCognizance.HINTS_COUNT.get(selected);
            int id = ASUtils.randIntBetween(1, count);
            String string = "gui.ancientspellcraft:sphere_cognizance.hint." + selected + "." + id;
            this.currentHintTypeId = ContainerSphereCognizance.HINT_TYPES.indexOf(selected);
            this.currentHintId = id;
        }
    }

    public boolean hasCrystalForFuel() {
        boolean b;
        boolean bl = b = this.getCrystalStack() != null && !this.getCrystalStack().func_190926_b() && this.getCrystalStack().func_77973_b() instanceof ItemCrystal;
        return b && this.getCrystalStack().func_190916_E() >= this.getResearchCost(this.getCurrentSpell());
    }

    public boolean hasSomethingToResearch() {
        Item item = this.getInputStack().func_77973_b();
        return !this.getInputStack().func_190926_b() && ((item == AncientSpellcraftItems.stone_tablet_small || item == AncientSpellcraftItems.stone_tablet || item == AncientSpellcraftItems.stone_tablet_large || item == AncientSpellcraftItems.stone_tablet_grand) && !ItemRelic.isResearched(this.getInputStack()) || item instanceof ItemSpellBook || item instanceof ItemScroll && !this.isCurrentBookKnown());
    }

    public int getResearchCost(Spell spell) {
        switch (spell.getTier()) {
            case NOVICE: {
                return 1;
            }
            case APPRENTICE: {
                return 1;
            }
            case ADVANCED: {
                return 1;
            }
            case MASTER: {
                return 2;
            }
        }
        return 1;
    }

    public static int getResearchDuration(Spell spell) {
        switch (spell.getTier()) {
            case NOVICE: {
                return 100;
            }
            case APPRENTICE: {
                return 150;
            }
            case ADVANCED: {
                return 200;
            }
            case MASTER: {
                return 250;
            }
        }
        return 10;
    }

    public void attemptBeginResearch() {
        if (this.canBeginResearch()) {
            this.currentHintTypeId = 0;
            this.currentHintId = 1;
            this.researchProgress = 1;
            if (this.getInputStack().func_77973_b() instanceof ItemSpellBook || this.getInputStack().func_77973_b() instanceof ItemScroll) {
                int researchcost = this.getResearchCost(this.getCurrentSpell());
                this.getCrystalStack().func_190918_g(researchcost);
            } else {
                this.getCrystalStack().func_190918_g(2);
            }
        }
    }

    public boolean shouldDisplayHint() {
        return this.researchDuration != 0 && this.researchDuration == this.researchProgress;
    }

    public int func_70302_i_() {
        return 2;
    }

    public boolean func_191420_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventory, (int)slot, (int)amount);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.furnaceItemStacks, (int)index);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.inventory.get(slot);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.inventory.set(slot, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (slot == ContainerSphereCognizance.CRYSTAL_SLOT) {
            // empty if block
        }
        if (slot == ContainerSphereCognizance.BOOK_SLOT) {
            this.researchProgress = 0;
            this.setResearchDuration();
            this.currentHintId = 0;
            this.currentHintTypeId = 0;
        }
        this.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer player) {
        boolean withinDistance = this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_174831_c(this.field_174879_c) < 64.0;
        return withinDistance && (!this.inUse || player == this.getCurrentPlayer());
    }

    public void func_174889_b(EntityPlayer player) {
        this.setInUse(true);
        this.setCurrentPlayer(player);
        this.setPlayerWizardData(player);
    }

    public void setPlayerWizardData(EntityPlayer player) {
        this.playerWizardData = WizardData.get((EntityPlayer)player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.setInUse(false);
        this.setCurrentPlayer(null);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int slotNumber, ItemStack stack) {
        if (stack == ItemStack.field_190927_a) {
            return true;
        }
        if (slotNumber == ContainerSphereCognizance.CRYSTAL_SLOT) {
            return stack.func_77973_b() instanceof ItemCrystal;
        }
        if (slotNumber == ContainerSphereCognizance.BOOK_SLOT) {
            return stack.func_77973_b() instanceof ItemRelic || stack.func_77973_b() instanceof ItemSpellBook || stack.func_77973_b() instanceof ItemScroll;
        }
        return false;
    }

    public int func_174890_g() {
        return 4;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.researchProgress;
            }
            case 1: {
                return this.researchDuration;
            }
            case 2: {
                return this.currentHintTypeId;
            }
            case 3: {
                return this.currentHintId;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.researchProgress = value;
                break;
            }
            case 1: {
                this.researchDuration = value;
                break;
            }
            case 2: {
                this.currentHintTypeId = value;
                break;
            }
            case 3: {
                this.currentHintId = value;
            }
        }
    }

    public void func_174888_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.func_70299_a(i, ItemStack.field_190927_a);
        }
    }
}

