/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.util;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.network.play.server.SPacketSetExperience;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class SpellTeleporter
implements ITeleporter {
    private double x;
    private double y;
    private double z;

    public SpellTeleporter(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void placeEntity(World world, Entity entity, float yaw) {
        entity.func_70107_b(this.x, this.y, this.z);
        entity.field_70159_w = 0.0;
        entity.field_70181_x = 0.0;
        entity.field_70179_y = 0.0;
    }

    public static void teleportEntity(int targetDim, double x, double y, double z, boolean causeBlindness, EntityPlayer entity) {
        boolean sameDim;
        if (!DimensionManager.isDimensionRegistered((int)targetDim) || entity == null || entity.func_184207_aI() || entity.func_184218_aH()) {
            return;
        }
        EntityPlayerMP player = entity instanceof EntityPlayerMP ? (EntityPlayerMP)entity : null;
        boolean bl = sameDim = player.field_71093_bK == targetDim;
        if (!player.field_70170_p.field_72995_K && causeBlindness) {
            BlockPos blockPos;
            player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 70, 0));
            if (targetDim == -1) {
                if (y <= 32.0) {
                    y = 35.0;
                } else if (y >= 120.0) {
                    y = 120.0;
                }
            }
            if (!sameDim) {
                if (ForgeHooks.onTravelToDimension((Entity)player, (int)targetDim)) {
                    SpellTeleporter.teleportPlayerToDimension(player, targetDim, new BlockPos(x, y, z), player.field_71109_bG);
                }
            } else {
                player.field_71135_a.func_147364_a(x + 0.5, y, z + 0.5, player.field_71109_bG, player.field_70125_A);
            }
            if (player.field_71093_bK == -1) {
                blockPos = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                IBlockState currState = player.field_70170_p.func_180495_p(blockPos);
                Material material = currState.func_185904_a();
                while ((material == Material.field_151587_i || material == Material.field_151581_o) && y <= 100.0) {
                    blockPos = blockPos.func_177982_a(0, 3, 0);
                    currState = player.field_70170_p.func_180495_p(blockPos);
                    material = currState.func_185904_a();
                    y += 3.0;
                }
                for (BlockPos currPos : BlockPos.func_177980_a((BlockPos)blockPos.func_177982_a(-2, -1, -2), (BlockPos)blockPos.func_177982_a(2, -1, 2))) {
                    if (player.field_70170_p.isSideSolid(currPos, EnumFacing.UP)) continue;
                    player.field_70170_p.func_175656_a(currPos, Blocks.field_150424_aL.func_176223_P());
                }
                if (player.field_70170_p.func_175697_a(player.func_180425_c(), 1)) {
                    player.field_70170_p.func_175698_g(player.func_180425_c());
                    player.field_70170_p.func_175698_g(player.func_180425_c().func_177984_a());
                }
            }
            if (!(targetDim != 0 || player.field_70170_p.func_175623_d(blockPos = new BlockPos(x, y, z)) && player.field_70170_p.func_175623_d(blockPos.func_177984_a()) && !player.field_70170_p.func_175623_d(blockPos.func_177977_b()))) {
                while (player.field_70170_p.func_175623_d(blockPos.func_177977_b())) {
                    blockPos = blockPos.func_177982_a(0, -1, 0);
                    y -= 1.0;
                }
            }
        }
    }

    private static void teleportPlayerToDimension(EntityPlayerMP player, int dimension, BlockPos destination, float yaw) {
        int startDimension = player.field_71093_bK;
        MinecraftServer server = player.func_184102_h();
        PlayerList playerList = server.func_184103_al();
        WorldServer startWorld = server.func_71218_a(startDimension);
        WorldServer destinationWorld = server.func_71218_a(dimension);
        player.field_71093_bK = dimension;
        player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(dimension, destinationWorld.func_175659_aa(), destinationWorld.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        playerList.func_187243_f(player);
        startWorld.func_72973_f((Entity)player);
        player.field_70128_L = false;
        player.func_70012_b((double)destination.func_177958_n() + 0.5, (double)destination.func_177956_o(), (double)destination.func_177952_p() + 0.5, yaw, player.field_70125_A);
        destinationWorld.func_72838_d((Entity)player);
        destinationWorld.func_72866_a((Entity)player, false);
        player.func_70029_a((World)destinationWorld);
        playerList.func_72375_a(player, startWorld);
        player.field_71135_a.func_147364_a((double)destination.func_177958_n() + 0.5, (double)destination.func_177956_o(), (double)destination.func_177952_p() + 0.5, yaw, player.field_70125_A);
        player.field_71134_c.func_73080_a(destinationWorld);
        player.field_71135_a.func_147359_a((Packet)new SPacketPlayerAbilities(player.field_71075_bZ));
        playerList.func_72354_b(player, destinationWorld);
        playerList.func_72385_f(player);
        for (PotionEffect potionEffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potionEffect));
        }
        player.field_71135_a.func_147359_a((Packet)new SPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, startDimension, dimension);
    }

    public static void teleportEntity(EntityLivingBase entityLivingBase, int targetDim, double x, double y, double z) {
        MinecraftServer server = entityLivingBase.func_130014_f_().func_73046_m();
        if (server != null) {
            BlockPos pos;
            WorldServer worldServer = server.func_71218_a(targetDim);
            if (!worldServer.func_175697_a(pos = new BlockPos(x, y, z), 1)) {
                ForgeChunkManager.Ticket tk = ForgeChunkManager.requestTicket((Object)"ancientspellcraft", (World)worldServer, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)tk, (ChunkPos)new ChunkPos(pos));
            }
            entityLivingBase.func_70634_a(x, y, z);
        }
    }

    public boolean isVanilla() {
        return false;
    }
}

