/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.worldgen;

import com.google.common.base.Predicate;
import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenCrystalShardOre
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == 0 && Settings.generalSettings.generate_ore_shards) {
            Biome biome = world.func_180494_b(new BlockPos(chunkX * 16, 0, chunkZ * 16));
            if (AncientSpellcraft.settings.shardFireBiomeWhitelist.contains(biome.getRegistryName())) {
                WorldGenCrystalShardOre.generateOre(random, chunkX, chunkZ, world, AncientSpellcraftBlocks.CRYSTAL_ORE_FIRE, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b), 4, 2, 8, 1.0f, 5, 30);
            }
            if (AncientSpellcraft.settings.shardNecromancyShardBiomeWhitelist.contains(biome.getRegistryName())) {
                WorldGenCrystalShardOre.generateOre(random, chunkX, chunkZ, world, AncientSpellcraftBlocks.CRYSTAL_ORE_NECROMANCY, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b), 4, 2, 8, 1.0f, 5, 30);
            }
            if (AncientSpellcraft.settings.shardHealingBiomeWhitelist.contains(biome.getRegistryName())) {
                WorldGenCrystalShardOre.generateOre(random, chunkX, chunkZ, world, AncientSpellcraftBlocks.CRYSTAL_ORE_HEALING, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b), 4, 2, 8, 1.0f, 5, 30);
            }
            if (AncientSpellcraft.settings.shardEarthShardBiomeWhitelist.contains(biome.getRegistryName())) {
                WorldGenCrystalShardOre.generateOre(random, chunkX, chunkZ, world, AncientSpellcraftBlocks.CRYSTAL_ORE_EARTH, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b), 4, 2, 8, 1.0f, 5, 30);
            }
            if (AncientSpellcraft.settings.shardLightningBiomeWhitelist.contains(biome.getRegistryName())) {
                WorldGenCrystalShardOre.generateOre(random, chunkX, chunkZ, world, AncientSpellcraftBlocks.CRYSTAL_ORE_LIGHTNING, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b), 4, 2, 8, 1.0f, 5, 30);
            }
            if (AncientSpellcraft.settings.shardIceBiomeWhitelist.contains(biome.getRegistryName())) {
                WorldGenCrystalShardOre.generateOre(random, chunkX, chunkZ, world, AncientSpellcraftBlocks.CRYSTAL_ORE_ICE, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b), 4, 2, 8, 1.0f, 5, 30);
            }
            if (AncientSpellcraft.settings.shardSorceryShardBiomeWhitelist.contains(biome.getRegistryName())) {
                WorldGenCrystalShardOre.generateOre(random, chunkX, chunkZ, world, AncientSpellcraftBlocks.CRYSTAL_ORE_SORCERY, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b), 4, 2, 8, 1.0f, 5, 30);
            }
        }
    }

    private static void generateOre(Random seed, int chunkX, int chunkZ, World world, Block ore, Predicate<IBlockState> bed, int size, int frequencyMin, int frequencyMax, float rarity, int layerMin, int layerMax) {
        int frequency = MathHelper.func_76136_a((Random)seed, (int)frequencyMin, (int)frequencyMax);
        if (seed.nextFloat() < rarity) {
            for (int count = 0; count < frequency; ++count) {
                BlockPos pos = new BlockPos(chunkX * 16 + seed.nextInt(16), MathHelper.func_76136_a((Random)seed, (int)layerMin, (int)layerMax), chunkZ * 16 + seed.nextInt(16));
                new WorldGenMinable(ore.func_176223_P(), size, bed).func_180709_b(world, seed, pos);
            }
        }
    }
}

