/*
 * Decompiled with CFR 0.152.
 */
package tschipp.callablehorses.common.worlddata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class StoredHorsesWorldData
extends WorldSavedData {
    private static String name = "callablehorses_stored_horses";
    private Map<String, Integer> entries = new HashMap<String, Integer>();
    private List<String> killedHorses = new ArrayList<String>();
    private List<String> disbandedHorses = new ArrayList<String>();
    private Map<String, NBTTagCompound> offlineSavedHorses = new HashMap<String, NBTTagCompound>();
    private int i = 0;

    public StoredHorsesWorldData() {
        super(name);
    }

    public StoredHorsesWorldData(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        int i = 0;
        while (nbt.func_74764_b("" + i)) {
            NBTTagCompound subTag = nbt.func_74775_l("" + i);
            String storageID = subTag.func_74779_i("id");
            int num = subTag.func_74762_e("num");
            this.entries.put(storageID, num);
            ++i;
        }
        i = 0;
        NBTTagCompound killed = nbt.func_74775_l("killed");
        while (killed.func_74764_b("" + i)) {
            this.killedHorses.add(killed.func_74775_l("" + i).func_74779_i("id"));
            ++i;
        }
        i = 0;
        NBTTagCompound disbanded = nbt.func_74775_l("disbanded");
        while (disbanded.func_74764_b("" + i)) {
            this.disbandedHorses.add(disbanded.func_74775_l("" + i).func_74779_i("id"));
            ++i;
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagCompound tag = new NBTTagCompound();
        this.entries.forEach((storageID, num) -> {
            NBTTagCompound subTag = new NBTTagCompound();
            subTag.func_74778_a("id", storageID);
            subTag.func_74768_a("num", num.intValue());
            tag.func_74782_a("" + this.i, (NBTBase)subTag);
            ++this.i;
        });
        this.i = 0;
        NBTTagCompound killed = new NBTTagCompound();
        for (int k = 0; k < this.killedHorses.size(); ++k) {
            NBTTagCompound subTag = new NBTTagCompound();
            subTag.func_74778_a("id", this.killedHorses.get(k));
            killed.func_74782_a("" + k, (NBTBase)subTag);
        }
        tag.func_74782_a("killed", (NBTBase)killed);
        NBTTagCompound disbanded = new NBTTagCompound();
        for (int k = 0; k < this.disbandedHorses.size(); ++k) {
            NBTTagCompound subTag = new NBTTagCompound();
            subTag.func_74778_a("id", this.disbandedHorses.get(k));
            disbanded.func_74782_a("" + k, (NBTBase)subTag);
        }
        tag.func_74782_a("disbanded", (NBTBase)disbanded);
        return tag;
    }

    public void addHorseNum(String id, int num) {
        this.entries.put(id, num);
        this.func_76185_a();
    }

    public int getHorseNum(String id) {
        Integer i = this.entries.get(id);
        if (i == null) {
            return 0;
        }
        return i;
    }

    public void disbandHorse(String id) {
        this.disbandedHorses.add(id);
        this.func_76185_a();
    }

    public boolean isDisbanded(String id) {
        return this.disbandedHorses.contains(id);
    }

    public void clearDisbanded(String id) {
        this.disbandedHorses.remove(id);
        this.func_76185_a();
    }

    public void markKilled(String id) {
        this.killedHorses.add(id);
        this.func_76185_a();
    }

    public boolean wasKilled(String id) {
        return this.killedHorses.contains(id);
    }

    public void clearKilled(String id) {
        this.killedHorses.remove(id);
        this.func_76185_a();
    }

    public void addOfflineSavedHorse(String id, NBTTagCompound nbt) {
        this.offlineSavedHorses.put(id, nbt);
        this.func_76185_a();
    }

    public boolean wasOfflineSaved(String id) {
        return this.offlineSavedHorses.containsKey(id);
    }

    public NBTTagCompound getOfflineSavedHorse(String id) {
        return this.offlineSavedHorses.get(id);
    }

    public void clearOfflineSavedHorse(String id) {
        this.offlineSavedHorses.remove(id);
        this.func_76185_a();
    }

    public static StoredHorsesWorldData getInstance(World world) {
        MapStorage storage = world.func_175693_T();
        StoredHorsesWorldData instance = (StoredHorsesWorldData)storage.func_75742_a(StoredHorsesWorldData.class, name);
        if (instance == null) {
            instance = new StoredHorsesWorldData();
            storage.func_75745_a(name, (WorldSavedData)instance);
        }
        return instance;
    }
}

