/*
 * Decompiled with CFR 0.152.
 */
package c4.comforts.proxy;

import c4.comforts.common.ConfigHandler;
import c4.comforts.common.EventHandlerCommon;
import c4.comforts.common.blocks.BlockBase;
import c4.comforts.common.blocks.BlockRope;
import c4.comforts.common.blocks.BlockSleepingBag;
import c4.comforts.common.blocks.ComfortsBlocks;
import c4.comforts.common.capability.CapabilitySleepTime;
import c4.comforts.common.capability.CapabilitySleeping;
import c4.comforts.common.capability.CapabilityWellRested;
import c4.comforts.common.entities.EntityRest;
import c4.comforts.common.items.ItemHammock;
import c4.comforts.common.items.ItemSleepingBag;
import c4.comforts.common.tileentities.TileEntityHammock;
import c4.comforts.common.util.ComfortsUtil;
import c4.comforts.integrations.morpheus.MorpheusDayHandler;
import c4.comforts.integrations.toughasnails.EventHandlerTAN;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.quetzi.morpheus.Morpheus;
import net.quetzi.morpheus.api.INewDayHandler;

@Mod.EventBusSubscriber
public class CommonProxy {
    public static Configuration config;

    public void preInit(FMLPreInitializationEvent evt) {
        ComfortsBlocks.preInit();
        ComfortsUtil.parseDebuffs();
    }

    public void init(FMLInitializationEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerCommon());
        CapabilitySleepTime.register();
        CapabilityWellRested.register();
        CapabilitySleeping.register();
        if (Loader.isModLoaded((String)"morpheus")) {
            CommonProxy.morpheusInit();
        }
        if (Loader.isModLoaded((String)"toughasnails") && ConfigHandler.toughasnails.warmBody) {
            MinecraftForge.EVENT_BUS.register((Object)new EventHandlerTAN());
        }
    }

    public void postInit(FMLPostInitializationEvent evt) {
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> evt) {
        evt.getRegistry().register((IForgeRegistryEntry)new BlockRope());
        for (BlockSleepingBag blockSleepingBag : ComfortsBlocks.SLEEPING_BAGS) {
            evt.getRegistry().register((IForgeRegistryEntry)blockSleepingBag);
        }
        for (BlockBase blockBase : ComfortsBlocks.HAMMOCKS) {
            evt.getRegistry().register((IForgeRegistryEntry)blockBase);
        }
        GameRegistry.registerTileEntity(TileEntityHammock.class, (ResourceLocation)new ResourceLocation("comforts", "tile_entity_hammock"));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> evt) {
        evt.getRegistry().register((IForgeRegistryEntry)new ItemSleepingBag());
        evt.getRegistry().register((IForgeRegistryEntry)new ItemHammock());
        evt.getRegistry().register(new ItemBlock((Block)ComfortsBlocks.ROPE).setRegistryName("rope"));
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> evt) {
        int id = 1;
        EntityEntry entry = EntityEntryBuilder.create().entity(EntityRest.class).id(new ResourceLocation("comforts", "_entity_rest"), id++).name("entity_rest").tracker(256, 20, false).build();
        evt.getRegistry().register((IForgeRegistryEntry)entry);
    }

    @Optional.Method(modid="morpheus")
    private static void morpheusInit() {
        Morpheus.register.registerHandler((INewDayHandler)new MorpheusDayHandler(), 0);
    }
}

