/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.easiervillagertrading;

import de.guntram.mcmod.easiervillagertrading.ConfigurationHandler;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMerchant;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import org.lwjgl.input.Mouse;

public class BetterGuiMerchant
extends GuiMerchant {
    private int xBase = 0;
    private int scrollCount = 0;
    private final int lineHeight = 18;
    private final int titleDistance = 20;
    private final int firstBuyItemXpos = 0;
    private final int secondBuyItemXpos = 18;
    private final int okNokXpos = 40;
    private final int sellItemXpos = 60;
    private final int textXpos = 85;
    private static final ResourceLocation icons = new ResourceLocation("easiervillagertrading", "textures/icons.png");
    private int frames;

    BetterGuiMerchant(InventoryPlayer inv, GuiMerchant template, World world) {
        super(inv, template.func_147035_g(), world);
        if (ConfigurationHandler.showLeft()) {
            this.xBase = -ConfigurationHandler.leftPixelOffset();
            if (this.xBase == 0) {
                this.xBase = -this.getXSize();
            }
        } else {
            this.xBase = this.getXSize() + 5;
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        MerchantRecipe trade;
        int i;
        if (++this.frames % 300 == 0) {
            // empty if block
        }
        super.func_146979_b(mouseX, mouseY);
        MerchantRecipeList trades = this.func_147035_g().func_70934_b(null);
        if (trades == null) {
            return;
        }
        int topAdjust = this.getTopAdjust(trades.size());
        String s = trades.size() + " trades";
        this.field_146289_q.func_78276_b(s, this.xBase + 40, -topAdjust, 0xFF00FF);
        if (this.frames % 300 == 0) {
            // empty if block
        }
        RenderHelper.func_74520_c();
        for (int i2 = 0; i2 < trades.size() - this.scrollCount; ++i2) {
            NBTTagList enchantments;
            MerchantRecipe trade2 = (MerchantRecipe)trades.get(i2 + this.scrollCount);
            ItemStack i1 = trade2.func_77394_a();
            ItemStack i22 = trade2.func_77398_c() ? trade2.func_77396_b() : null;
            ItemStack o1 = trade2.func_77397_d();
            if (this.frames % 300 == 0) {
                // empty if block
            }
            this.drawItem(i1, this.xBase + 0, i2 * 18 - topAdjust + 20);
            this.drawItem(i22, this.xBase + 18, i2 * 18 - topAdjust + 20);
            this.drawItem(o1, this.xBase + 60, i2 * 18 - topAdjust + 20);
            if (o1.func_77973_b() instanceof ItemEnchantedBook) {
                ItemEnchantedBook cfr_ignored_0 = (ItemEnchantedBook)o1.func_77973_b();
                enchantments = ItemEnchantedBook.func_92110_g((ItemStack)o1);
            } else {
                enchantments = o1.func_77986_q();
            }
            if (enchantments == null) continue;
            StringBuilder enchants = new StringBuilder();
            for (int t = 0; t < enchantments.func_74745_c(); ++t) {
                short j = enchantments.func_150305_b(t).func_74765_d("id");
                short k = enchantments.func_150305_b(t).func_74765_d("lvl");
                Enchantment enchant = Enchantment.func_185262_c((int)j);
                if (enchant == null) continue;
                if (t > 0) {
                    enchants.append(", ");
                }
                enchants.append(enchant.func_77316_c((int)k));
            }
            String shownEnchants = enchants.toString();
            if (this.xBase < 0) {
                shownEnchants = this.field_146289_q.func_78269_a(shownEnchants, -this.xBase - 85 - 5);
            }
            if (this.frames % 300 == 0) {
                // empty if block
            }
            this.field_146289_q.func_78276_b(shownEnchants, this.xBase + 85, i2 * 18 - topAdjust + 24, 0xFFFF00);
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        this.field_146297_k.func_110434_K().func_110577_a(icons);
        int arrowX = this.xBase + 40;
        int[] tradeState = new int[trades.size()];
        for (i = 0; i < trades.size() - this.scrollCount; ++i) {
            int y = i * 18 - topAdjust + 20;
            trade = (MerchantRecipe)trades.get(i + this.scrollCount);
            if (!trade.func_82784_g() && this.inputSlotsAreEmpty() && this.hasEnoughItemsInInventory(trade) && this.canReceiveOutput(trade.func_77397_d())) {
                this.func_73729_b(arrowX, y, 108, 36, 18, 18);
                tradeState[i] = 0;
                continue;
            }
            if (!trade.func_82784_g()) {
                this.func_73729_b(arrowX, y, 90, 54, 18, 18);
                tradeState[i] = 1;
                continue;
            }
            this.func_73729_b(arrowX, y, 216, 54, 18, 18);
            tradeState[i] = 2;
        }
        if (this.scrollCount > 0) {
            this.func_73729_b(this.xBase + 0, -topAdjust - 3, 162, 36, 18, 18);
        }
        if ((trades.size() - 1 - this.scrollCount) * 18 + 40 >= this.field_146295_m) {
            if (this.frames % 300 == 0) {
                // empty if block
            }
            this.func_73729_b(this.xBase + 18, -topAdjust - 3, 18, 36, 18, 18);
        }
        block8: for (i = 0; i < trades.size(); ++i) {
            int y = i * 18 - topAdjust + 20;
            trade = (MerchantRecipe)trades.get(i);
            ItemStack i1 = trade.func_77394_a();
            ItemStack i2 = trade.func_77398_c() ? trade.func_77396_b() : null;
            ItemStack o1 = trade.func_77397_d();
            this.drawTooltip(i1, this.xBase + 0, y, mouseX, mouseY);
            this.drawTooltip(i2, this.xBase + 18, y, mouseX, mouseY);
            this.drawTooltip(o1, this.xBase + 60, y, mouseX, mouseY);
            switch (tradeState[i]) {
                case 0: {
                    this.drawTooltip(I18n.func_135052_a((String)"msg.cantrade", (Object[])null), arrowX, y, mouseX, mouseY);
                    continue block8;
                }
                case 1: {
                    this.drawTooltip(I18n.func_135052_a((String)"msg.notradeinv", (Object[])null), arrowX, y, mouseX, mouseY);
                    continue block8;
                }
                case 2: {
                    this.drawTooltip(I18n.func_135052_a((String)"msg.tradelocked", (Object[])null), arrowX, y, mouseX, mouseY);
                }
            }
        }
    }

    private int getTopAdjust(int numTrades) {
        int topAdjust = (numTrades * 18 + 20 - this.field_147000_g) / 2;
        if (topAdjust < 0) {
            topAdjust = 0;
        }
        if (topAdjust > this.field_147009_r - this.titleDistance / 2) {
            topAdjust = this.field_147009_r - this.titleDistance / 2;
        }
        return topAdjust;
    }

    private void drawItem(ItemStack stack, int x, int y) {
        if (stack == null) {
            return;
        }
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_175030_a(this.field_146289_q, stack, x, y);
    }

    private void drawTooltip(ItemStack stack, int x, int y, int mousex, int mousey) {
        if (stack == null) {
            return;
        }
        if ((mousex -= this.field_147003_i) >= x && mousex <= x + 16 && (mousey -= this.field_147009_r) >= y && mousey <= y + 16) {
            this.func_146285_a(stack, mousex, mousey);
        }
    }

    private void drawTooltip(String s, int x, int y, int mousex, int mousey) {
        if ((mousex -= this.field_147003_i) >= x && mousex <= x + 16 && (mousey -= this.field_147009_r) >= y && mousey <= y + 16) {
            this.func_146279_a(s, mousex, mousey);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0 && mouseX - this.field_147003_i >= this.xBase && mouseX - this.field_147003_i <= this.xBase + 85) {
            MerchantRecipeList trades = this.func_147035_g().func_70934_b(null);
            if (trades == null) {
                return;
            }
            int numTrades = trades.size();
            int topAdjust = this.getTopAdjust(numTrades);
            int yPixel = mouseY + topAdjust - this.field_147009_r - 20;
            if (yPixel >= 0) {
                int tradeIndex = yPixel / 18 + this.scrollCount;
                if (tradeIndex >= 0 && tradeIndex < numTrades) {
                    int i;
                    GuiButton myNextButton = (GuiButton)this.field_146292_n.get(0);
                    GuiButton myPrevButton = (GuiButton)this.field_146292_n.get(1);
                    for (i = 0; i < numTrades; ++i) {
                        this.func_146284_a(myPrevButton);
                    }
                    for (i = 0; i < tradeIndex; ++i) {
                        this.func_146284_a(myNextButton);
                    }
                    MerchantRecipe recipe = (MerchantRecipe)trades.get(tradeIndex);
                    while (!recipe.func_82784_g() && this.inputSlotsAreEmpty() && this.hasEnoughItemsInInventory(recipe) && this.canReceiveOutput(recipe.func_77397_d())) {
                        this.transact(recipe);
                        if (BetterGuiMerchant.func_146272_n()) continue;
                        break;
                    }
                }
            } else if (mouseX - this.field_147003_i < this.xBase + 18) {
                this.mouseScrolled(1);
            } else if (mouseX - this.field_147003_i < this.xBase + 40) {
                this.mouseScrolled(-1);
            }
        } else {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0) {
            this.mouseScrolled(i < 0 ? -1 : 1);
        }
    }

    public void mouseScrolled(int delta) {
        MerchantRecipeList trades = this.func_147035_g().func_70934_b(null);
        if (trades != null) {
            this.scrollCount -= delta;
            while ((trades.size() - this.scrollCount) * 18 + 40 < this.field_146295_m) {
                --this.scrollCount;
            }
            if (this.scrollCount < 0) {
                this.scrollCount = 0;
            }
        }
    }

    private boolean inputSlotsAreEmpty() {
        return !this.field_147002_h.func_75139_a(0).func_75216_d() && !this.field_147002_h.func_75139_a(1).func_75216_d() && !this.field_147002_h.func_75139_a(2).func_75216_d();
    }

    private boolean hasEnoughItemsInInventory(MerchantRecipe recipe) {
        if (!this.hasEnoughItemsInInventory(recipe.func_77394_a())) {
            return false;
        }
        return !recipe.func_77398_c() || this.hasEnoughItemsInInventory(recipe.func_77396_b());
    }

    private boolean hasEnoughItemsInInventory(ItemStack stack) {
        int remaining = stack.func_190916_E();
        for (int i = this.field_147002_h.field_75151_b.size() - 36; i < this.field_147002_h.field_75151_b.size(); ++i) {
            ItemStack invstack = this.field_147002_h.func_75139_a(i).func_75211_c();
            if (invstack == null) continue;
            if (this.areItemStacksMergable(stack, invstack)) {
                remaining -= invstack.func_190916_E();
            }
            if (remaining > 0) continue;
            return true;
        }
        return false;
    }

    private boolean canReceiveOutput(ItemStack stack) {
        int remaining = stack.func_190916_E();
        for (int i = this.field_147002_h.field_75151_b.size() - 36; i < this.field_147002_h.field_75151_b.size(); ++i) {
            ItemStack invstack = this.field_147002_h.func_75139_a(i).func_75211_c();
            if (invstack == null || invstack.func_190926_b()) {
                return true;
            }
            if (this.areItemStacksMergable(stack, invstack) && stack.func_77976_d() >= stack.func_190916_E() + invstack.func_190916_E()) {
                remaining -= invstack.func_77976_d() - invstack.func_190916_E();
            }
            if (remaining > 0) continue;
            return true;
        }
        return false;
    }

    private void transact(MerchantRecipe recipe) {
        int putback1 = -1;
        int putback0 = this.fillSlot(0, recipe.func_77394_a());
        if (recipe.func_77398_c()) {
            putback1 = this.fillSlot(1, recipe.func_77396_b());
        }
        this.getslot(2, recipe.func_77397_d(), putback0, putback1);
        if (putback0 != -1) {
            this.slotClick(0);
            this.slotClick(putback0);
        }
        if (putback1 != -1) {
            this.slotClick(1);
            this.slotClick(putback1);
        }
    }

    private int fillSlot(int slot, ItemStack stack) {
        int remaining = stack.func_190916_E();
        for (int i = this.field_147002_h.field_75151_b.size() - 36; i < this.field_147002_h.field_75151_b.size(); ++i) {
            ItemStack invstack = this.field_147002_h.func_75139_a(i).func_75211_c();
            if (invstack == null) continue;
            boolean needPutBack = false;
            if (this.areItemStacksMergable(stack, invstack)) {
                if (stack.func_190916_E() + invstack.func_190916_E() > stack.func_77976_d()) {
                    needPutBack = true;
                }
                remaining -= invstack.func_190916_E();
                this.slotClick(i);
                this.slotClick(slot);
            }
            if (needPutBack) {
                this.slotClick(i);
            }
            if (remaining > 0) continue;
            return remaining < 0 ? i : -1;
        }
        return -1;
    }

    private boolean areItemStacksMergable(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return false;
        }
        return a.func_77973_b() == b.func_77973_b() && (!a.func_77981_g() || a.func_77952_i() == b.func_77952_i()) && ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }

    private void getslot(int slot, ItemStack stack, int ... forbidden) {
        int i;
        int remaining = stack.func_190916_E();
        this.slotClick(slot);
        for (i = this.field_147002_h.field_75151_b.size() - 36; i < this.field_147002_h.field_75151_b.size(); ++i) {
            ItemStack invstack = this.field_147002_h.func_75139_a(i).func_75211_c();
            if (invstack == null || invstack.func_190926_b()) continue;
            if (this.areItemStacksMergable(stack, invstack) && invstack.func_190916_E() < invstack.func_77976_d()) {
                remaining -= invstack.func_77976_d() - invstack.func_190916_E();
                this.slotClick(i);
            }
            if (remaining > 0) continue;
            return;
        }
        for (i = this.field_147002_h.field_75151_b.size() - 36; i < this.field_147002_h.field_75151_b.size(); ++i) {
            ItemStack invstack;
            boolean isForbidden = false;
            for (int f : forbidden) {
                if (i != f) continue;
                isForbidden = true;
            }
            if (isForbidden || (invstack = this.field_147002_h.func_75139_a(i).func_75211_c()) != null && !invstack.func_190926_b()) continue;
            this.slotClick(i);
            return;
        }
    }

    private void slotClick(int slot) {
        this.field_146297_k.field_71442_b.func_187098_a(this.field_146297_k.field_71439_g.field_71070_bA.field_75152_c, slot, 0, ClickType.PICKUP, (EntityPlayer)this.field_146297_k.field_71439_g);
    }
}

