/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.easiervillagertrading;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigurationHandler {
    private static ConfigurationHandler instance;
    private Configuration config;
    private String configFileName;
    private boolean showLeft;
    private int leftPixelOffset;
    private boolean autoFocusSearch;

    public static ConfigurationHandler getInstance() {
        if (instance == null) {
            instance = new ConfigurationHandler();
        }
        return instance;
    }

    public void load(File configFile) {
        if (this.config == null) {
            this.config = new Configuration(configFile);
            this.configFileName = configFile.getPath();
            this.loadConfig();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("easiervillagertrading")) {
            this.loadConfig();
        }
    }

    private void loadConfig() {
        this.showLeft = this.config.getBoolean("Trades list left", "client", Loader.isModLoaded((String)"jei"), "Show trades list to the left, for Just Enough Items compatibility");
        this.leftPixelOffset = this.config.getInt("Trades left pixel offset", "client", 0, 0, Integer.MAX_VALUE, "How many pixels left of the GUI the trades list will be shown. Use 0 for auto detect. Only used if Trades list left is true.");
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public static Configuration getConfig() {
        return ConfigurationHandler.getInstance().config;
    }

    public static String getConfigFileName() {
        return ConfigurationHandler.getInstance().configFileName;
    }

    public static boolean showLeft() {
        return ConfigurationHandler.getInstance().showLeft;
    }

    public static int leftPixelOffset() {
        return ConfigurationHandler.getInstance().leftPixelOffset;
    }

    public static boolean autoFocusSearch() {
        return ConfigurationHandler.getInstance().autoFocusSearch;
    }
}

