/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge;

import net.minecraftforge.common.config.Config;

@Config(modid="elenaidodge", name="elenaidodge", type=Config.Type.INSTANCE)
public class ModConfig {
    public static Client client = new Client();
    public static Common common = new Common();
    public static Modpacks modpacks = new Modpacks();
    @Config.Name(value="other movement")
    public static OtherMovement otherMovement = new OtherMovement();
    @Config.Name(value="armor weights")
    public static ArmorWeights armorWeights = new ArmorWeights();

    public static class ArmorWeights {
        @Config.Name(value="Enable Weight System")
        @Config.Comment(value={"Whether or not you want a tiered dodging system similar to Dark Souls. I recommend this heavily! This was suggested by SandwichHorror so go buy them a coffee or something."})
        public boolean enabled = false;
        @Config.Name(value="Armor Weights")
        @Config.Comment(value={"Insert values as a comma seperated string, I've already done all the vanilla ones for you, but feel free to edit them, and add custom values for modded armor like this: modid:itemname=value"})
        public String weights = "minecraft:leather_boots=1,minecraft:leather_leggings=2,minecraft:leather_chestplate=3,minecraft:leather_helmet=1,minecraft:iron_boots=2,minecraft:iron_leggings=3,minecraft:iron_chestplate=4,minecraft:iron_helmet=2,minecraft:diamond_boots=3,minecraft:diamond_leggings=4,minecraft:diamond_chestplate=5,minecraft:diamond_helmet=3,minecraft:gold_boots=2,minecraft:gold_leggings=2,minecraft:gold_chestplate=3,minecraft:gold_helmet=2,minecraft:chainmail_boots=1,minecraft:chainmail_leggings=2,minecraft:chainmail_chestplate=3,minecraft:chainmail_helmet=1,minecraft:elytra=2,minecraft:wood_sword=1,minecraft:stone_sword=2,minecraft:iron_sword=3,minecraft:gold_sword=3,minecraft:diamond_sword=4,minecraft:shield=5";
        @Config.Name(value="Dodge Tiers")
        @Config.Comment(value={"This is slightly complex, so please read carefully! Tiers allow you to add different levels of power and cooldown to dodging depending on how heavy the armor the player is wearing is. You format each tier like so: minimumWeightToAccessTier=powerOfTier/cooldownOfTier, and seperate each tier with a comma. The tiers NEED to increase in weight requirements, so for example, the first tier must always start at 0, then the next could start at 5... then 7... and so on. The last tier you enter will prevent the player from dodging regardless of the power or cooldown you set. So for example 100=100/0 would completely prevent the player from dodging if they had a weight of over 100."})
        public String tiers = "0=1.4/30,8=0.8/60,12=0.6/80,15=0/0";
    }

    public static class OtherMovement {
        @Config.Name(value="Wall Jump")
        public WallJump wallJump = new WallJump();
        @Config.Name(value="Ledge Grab")
        public LedgeGrab ledgeGrab = new LedgeGrab();

        public class LedgeGrab {
            @Config.Name(value="Enable Ledgegrab")
            @Config.Comment(value={"Toggles whether you can LedgeGrab. To use, press shift against the top of a block to climb up it. MUST BE ENABLED BY BOTH SERVERS AND CLIENTS"})
            public boolean enableLedgeGrab = false;
            @Config.Name(value="Ledge Grab Exhaustion")
            @Config.Comment(value={"How much exhaustion is added when ledge-grabbing. Exhaustion is a value that decreases your hunger. For reference, sprinting adds 0.01 exhaustion per meter, and the Hunger effect adds 0.1 per second."})
            @Config.RangeDouble(min=0.0, max=40.0)
            public double exhaustion = 0.0;
            @Config.Name(value="Hunger Requirement")
            @Config.Comment(value={"How many half drumsticks the player needs to ledge grab. The default six is the same as sprinting."})
            @Config.RangeInt(min=-1, max=20)
            public int hungerRequirement = 6;
            @Config.Name(value="Grab Boost")
            @Config.Comment(value={"How high you're pushed when ledgegrabbing. Really you should keep this under one or even 0.5. But I've let you go up to 50 if you wanna mess around :)"})
            @Config.RangeDouble(min=0.0, max=50.0)
            public double climbSpeed = 0.46;
        }

        public class WallJump {
            @Config.Name(value="Enable Walljump")
            @Config.Comment(value={"Toggles whether you can WallJump. To use, press space against a wall to bounce off of it."})
            public boolean enableWallJump = false;
            @Config.Name(value="Wall Jump Exhaustion")
            @Config.Comment(value={"How much exhaustion is added when wall-jumping. Exhaustion is a value that decreases your hunger. For reference, sprinting adds 0.01 exhaustion per meter, and the Hunger effect adds 0.1 per second."})
            @Config.RangeDouble(min=0.0, max=40.0)
            public double exhaustion = 0.0;
            @Config.Name(value="Wall Jump Pushback")
            @Config.Comment(value={"How far players are pushed away from the wall."})
            @Config.RangeDouble(min=0.0, max=1.7976931348623157E308)
            public double pushback = 0.4;
            @Config.Name(value="Wall Jump Height")
            @Config.Comment(value={"How high players are pushed up from the wall."})
            @Config.RangeDouble(min=0.0, max=1.7976931348623157E308)
            public double height = 0.5;
            @Config.Name(value="Limit Jumps")
            @Config.Comment(value={"Toggles whether you only have X amount of jumps before touching the floor."})
            public boolean limitJumps = true;
            @Config.Name(value="Jump Amount")
            @Config.Comment(value={"How many walljumps you have before touching the floor."})
            @Config.RangeInt(min=0, max=0x7FFFFFFF)
            public int jumpAmount = 3;
            @Config.Name(value="Cooldown")
            @Config.Comment(value={"A value to prevent spamming the walljump. Keep this low or you won't be able to jump much!"})
            @Config.RangeInt(min=0, max=0x7FFFFFFF)
            public int cooldown = 3;
            @Config.Name(value="Hunger Requirement")
            @Config.Comment(value={"How many half drumsticks the player needs to wall jump. The default six is the same as sprinting."})
            @Config.RangeInt(min=-1, max=20)
            public int hungerRequirement = 6;
            @Config.Name(value="Wall Jump Angle (Read me!)")
            @Config.Comment(value={"How wide of an angle you have to face away from the wall to kick off it. Decrease this value to make it so you have to face away FURTHER."})
            @Config.RangeDouble(min=0.0, max=0.3)
            public double angle = 0.16;
            @Config.Name(value="Wall Jump Range")
            @Config.Comment(value={"How far away from the wall you can be to dodge."})
            @Config.RangeDouble(min=0.0, max=100.0)
            public double range = 0.26;
        }
    }

    public static class Modpacks {
        @Config.Name(value="Requires Gamestage or Potion Effect")
        @Config.Comment(value={"Toggles whether you need either the gamestage 'can_dodge' or the potion effect 'can_dodge' to dodge. Does not require gamestages to be installed if you only want to check for the potion effect!"})
        public boolean dodgingRequiresGamestage = false;
        @Config.Name(value="Midair requires Gamestage")
        @Config.Comment(value={"Will not work without GameStages installed! Toggles whether you need the gamestage 'can_dodge_airborne' to dodge in midair. If enabled, this overrules 'always allow dodge while airborne'."})
        public boolean airborneRequiresGamestage = false;
    }

    public static class Common {
        public Balance balance = new Balance();
        public Cooldown cooldown = new Cooldown();
        public Particles particles = new Particles();

        public class Particles {
            @Config.Name(value="Display Particles")
            @Config.Comment(value={"Affects all Players on the world and is overwritten by server config"})
            public boolean displayParticles = true;
        }

        public class Cooldown {
            @Config.Name(value="Enable Cooldown")
            @Config.Comment(value={"Toggles whether you need to wait for a cooldown bar in order to dodge."})
            public boolean enableCooldown = true;
            @Config.Name(value="Cooldown Duration")
            @Config.Comment(value={"How long the cooldown bar takes to deplete in Ticks. This value can be increased or decreased by other mods, so view this as the standard time for all players on the server. Anything above 180 will never decrease because numbers are evil."})
            @Config.RangeInt(min=1, max=180)
            public int cooldownLength = 60;
        }

        public class Balance {
            @Config.Name(value="Dodge Power")
            @Config.Comment(value={"How far the player dodges by default. This value can be added on or decreased by equipping items or meeting conditions from other mods, so view it as a baseline for all players on the server. This value is EXTREMELY sensitive!"})
            @Config.RangeDouble(min=0.0, max=1.7976931348623157E308)
            public double dodgePower = 1.15;
            @Config.Name(value="Dodge Exhaustion")
            @Config.Comment(value={"How much exhaustion is added when dodging. Exhaustion is a value that decreases your hunger. For reference, sprinting adds 0.01 exhaustion per meter, and the Hunger effect adds 0.1 per second."})
            @Config.RangeDouble(min=0.0, max=40.0)
            public double exhaustion = 0.0;
            @Config.Name(value="Hunger Requirement")
            @Config.Comment(value={"How many half drumsticks the player needs to dodge. The default six is the same as sprinting."})
            @Config.RangeInt(min=-1, max=20)
            public int hungerRequirement = 6;
            @Config.Name(value="Always allow dodge while airborne")
            @Config.Comment(value={"Whether or not the player can dodge in mid-air. Please note this is always enabled in Creative and Spectator mode, and if disabled can be over-ruled with conditions set in the modpacks section of the config!"})
            public boolean allowDodgeWhileAirborne = false;
            @Config.Name(value="Dodge Verticallity")
            @Config.Comment(value={"How much you hop of the ground when dodging. Please note that this may ever so slightly increase how far you dodge, so you may need to reduce dodge power in accordance."})
            @Config.RangeDouble(min=0.0, max=1.7976931348623157E308)
            public double verticallity = 0.0;
            @Config.Name(value="Keep Velocity")
            @Config.Comment(value={"Whether to maintain the player's current velocity when dodging."})
            public boolean keepVelocity = true;
            @Config.Name(value="Disable dodge whilst Sneaking/Blocking")
            @Config.Comment(value={"Whether you can dodge whilst sneaking or blocking. By default this is true incase you keep accidentally dodging."})
            public boolean disableWhilstSneaking = true;
            @Config.Name(value="Invincibility Ticks")
            @Config.Comment(value={"How many in-game ticks of invincibility the player has after dodging. For reference, 20 ticks is one second!"})
            @Config.RangeInt(min=0, max=80)
            public int invincibilityTicks = 20;
        }
    }

    public static class Client {
        public Hud hud = new Hud();
        public Sound sound = new Sound();
        public Controls controls = new Controls();

        public class Controls {
            @Config.Name(value="Double Tap Mode")
            @Config.Comment(value={"Set to 0 to disable. Set to 1 to make dodging left, right or backwards require a double tap, and forwards requiring a tap of the dodge button. Set to 2 to allow dodging in all directions by a double tap, however double tapping forwards will make you sprint."})
            @Config.RangeInt(min=0, max=2)
            public int doubleTapMode = 0;
            @Config.Name(value="Double Tap Ticks")
            @Config.Comment(value={"How many system ticks you have between double tapping (these are NOT minecraft ticks, and are way faster). Increase if you have motor issues or are like me and suck at gaming, decrease if you keep accidentally double tapping."})
            @Config.RangeInt(min=1, max=0x7FFFFFFF)
            public int doubleTapTicks = 250;
        }

        public class Sound {
            @Config.Name(value="Enable 'Ding' Sound")
            public boolean enableSound = true;
        }

        public class Hud {
            @Config.Name(value="Unlock Hud")
            @Config.Comment(value={"You must first enable this before making any changes to the GUI!"})
            public boolean unlockHUD = false;
            @Config.Name(value="X Offset")
            @Config.Comment(value={"How far away from the default position the bar is horizontally when unlocked.\nIncrease this value to go right, decrease it to go left."})
            @Config.RangeInt(min=-2147483648, max=0x7FFFFFFF)
            public int xHUD = 0;
            @Config.Name(value="Y Offset")
            @Config.Comment(value={"How far away from the default position the bar is vertically when unlocked.\nIncrease this value to go down, decrease it to go up."})
            @Config.RangeInt(min=-2147483648, max=0x7FFFFFFF)
            public int yHUD = 0;
        }
    }
}

