/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge.event;

import com.elenai.elenaidodge.ModConfig;
import com.elenai.elenaidodge.client.gui.DodgeGui;
import com.elenai.elenaidodge.event.TickEvents;
import com.elenai.elenaidodge.network.PacketHandler;
import com.elenai.elenaidodge.network.message.HandleDodgeMessage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class DoubleTapEvent {
    public static boolean needsInit = true;
    public static HashMap<KeyBinding, Long> keyTimesLastPressed = new HashMap();
    public static HashMap<KeyBinding, Boolean> keyLastState = new HashMap();
    public static HashMap<KeyBinding, String> lookupKeyToDirection = new HashMap();

    @SubscribeEvent
    public void tickClient(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (needsInit) {
                needsInit = false;
                DoubleTapEvent.tickInit();
            }
            if (ModConfig.client.controls.doubleTapMode > 0) {
                DoubleTapEvent.tickDodging();
            }
        }
    }

    public static void tickInit() {
        lookupKeyToDirection.put(Minecraft.func_71410_x().field_71474_y.field_74351_w, "forward");
        lookupKeyToDirection.put(Minecraft.func_71410_x().field_71474_y.field_74368_y, "back");
        lookupKeyToDirection.put(Minecraft.func_71410_x().field_71474_y.field_74370_x, "left");
        lookupKeyToDirection.put(Minecraft.func_71410_x().field_71474_y.field_74366_z, "right");
        keyLastState.put(Minecraft.func_71410_x().field_71474_y.field_74351_w, false);
        keyLastState.put(Minecraft.func_71410_x().field_71474_y.field_74368_y, false);
        keyLastState.put(Minecraft.func_71410_x().field_71474_y.field_74370_x, false);
        keyLastState.put(Minecraft.func_71410_x().field_71474_y.field_74366_z, false);
    }

    public static void tickDodging() {
        lookupKeyToDirection.forEach((k, d) -> DoubleTapEvent.processDodgeKey(k, d));
    }

    public static void processDodgeKey(KeyBinding key, String direction) {
        long curTime = System.currentTimeMillis();
        long lastTime = DoubleTapEvent.getLastKeyTime(key);
        if (key.func_151463_i() > 0) {
            if (Keyboard.isKeyDown((int)key.func_151463_i()) && !keyLastState.get(key).booleanValue()) {
                if (lastTime == -1L) {
                    DoubleTapEvent.setLastKeyTime(key, curTime);
                } else if (lastTime + (long)ModConfig.client.controls.doubleTapTicks > curTime) {
                    if (DodgeGui.len <= 0 && TickEvents.spamPreventer >= 12 && Minecraft.func_71410_x().field_71462_r == null) {
                        if (ModConfig.client.controls.doubleTapMode == 2) {
                            PacketHandler.instance.sendToServer((IMessage)new HandleDodgeMessage(ModConfig.client.hud.unlockHUD, ModConfig.client.sound.enableSound, direction));
                        } else if (ModConfig.client.controls.doubleTapMode == 1 && !direction.contains("forward")) {
                            PacketHandler.instance.sendToServer((IMessage)new HandleDodgeMessage(ModConfig.client.hud.unlockHUD, ModConfig.client.sound.enableSound, direction));
                        }
                    }
                    DoubleTapEvent.setLastKeyTime(key, -1L);
                } else {
                    DoubleTapEvent.setLastKeyTime(key, curTime);
                }
            }
            if (!Keyboard.isKeyDown((int)key.func_151463_i()) && keyLastState.get(key).booleanValue()) {
                for (Map.Entry<KeyBinding, Long> entry : keyTimesLastPressed.entrySet()) {
                    if (entry.getKey() == key) continue;
                    entry.setValue(-1L);
                }
            }
            keyLastState.put(key, Keyboard.isKeyDown((int)key.func_151463_i()));
        }
    }

    public static long getLastKeyTime(KeyBinding keybind) {
        if (!keyTimesLastPressed.containsKey(keybind)) {
            keyTimesLastPressed.put(keybind, -1L);
        }
        return keyTimesLastPressed.get(keybind);
    }

    public static void setLastKeyTime(KeyBinding keybind, long time) {
        keyTimesLastPressed.put(keybind, time);
    }
}

