/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge.modpacks.capability;

import com.elenai.elenaidodge.modpacks.capability.airborne.AirborneProvider;
import com.elenai.elenaidodge.modpacks.capability.airborne.IAirborne;
import com.elenai.elenaidodge.modpacks.capability.cooldown.CooldownProvider;
import com.elenai.elenaidodge.modpacks.capability.cooldown.ICooldown;
import com.elenai.elenaidodge.modpacks.capability.invincibility.InvincibilityProvider;
import com.elenai.elenaidodge.modpacks.capability.power.IPower;
import com.elenai.elenaidodge.modpacks.capability.power.PowerProvider;
import com.elenai.elenaidodge.modpacks.capability.toggle.IPlayerCanDodge;
import com.elenai.elenaidodge.modpacks.capability.toggle.PlayerCanDodgeProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CapabilityHandler {
    public static final ResourceLocation POWER_CAP = new ResourceLocation("elenaidodge", "power");
    public static final ResourceLocation COOLDOWN_CAP = new ResourceLocation("elenaidodge", "cooldown");
    public static final ResourceLocation TIMER_CAP = new ResourceLocation("elenaidodge", "timer");
    public static final ResourceLocation PLAYER_CAN_DODGE_CAP = new ResourceLocation("elenaidodge", "playercandodge");
    public static final ResourceLocation AIRBORNE_CAP = new ResourceLocation("elenaidodge", "airborne");
    public static final ResourceLocation INVINCIBILITY_CAP = new ResourceLocation("elenaidodge", "invincibility");

    @SubscribeEvent
    public void onEntityConstructing(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            if (!((Entity)event.getObject()).hasCapability(PowerProvider.POWER_CAP, null)) {
                event.addCapability(POWER_CAP, (ICapabilityProvider)new PowerProvider());
            }
            if (!((Entity)event.getObject()).hasCapability(CooldownProvider.COOLDOWN_CAP, null)) {
                event.addCapability(COOLDOWN_CAP, (ICapabilityProvider)new CooldownProvider());
            }
            if (!((Entity)event.getObject()).hasCapability(PlayerCanDodgeProvider.PLAYER_CAN_DODGE_CAP, null)) {
                event.addCapability(PLAYER_CAN_DODGE_CAP, (ICapabilityProvider)new PlayerCanDodgeProvider());
            }
            if (!((Entity)event.getObject()).hasCapability(AirborneProvider.AIRBORNE_CAP, null)) {
                event.addCapability(AIRBORNE_CAP, (ICapabilityProvider)new AirborneProvider());
            }
            if (!((Entity)event.getObject()).hasCapability(InvincibilityProvider.INVINCIBILITY_CAP, null)) {
                event.addCapability(INVINCIBILITY_CAP, (ICapabilityProvider)new InvincibilityProvider());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        EntityPlayer player = event.getEntityPlayer();
        IPower power = (IPower)player.getCapability(PowerProvider.POWER_CAP, null);
        IPower oldPower = (IPower)event.getOriginal().getCapability(PowerProvider.POWER_CAP, null);
        power.set(oldPower.getPower());
        ICooldown cooldown = (ICooldown)player.getCapability(CooldownProvider.COOLDOWN_CAP, null);
        ICooldown oldCooldown = (ICooldown)event.getOriginal().getCapability(CooldownProvider.COOLDOWN_CAP, null);
        cooldown.set(oldCooldown.getCooldown());
        IPlayerCanDodge playerCanDodge = (IPlayerCanDodge)player.getCapability(PlayerCanDodgeProvider.PLAYER_CAN_DODGE_CAP, null);
        IPlayerCanDodge oldPlayerCanDodge = (IPlayerCanDodge)event.getOriginal().getCapability(PlayerCanDodgeProvider.PLAYER_CAN_DODGE_CAP, null);
        playerCanDodge.set(oldPlayerCanDodge.getPlayerCanDodge());
        IAirborne airborne = (IAirborne)player.getCapability(AirborneProvider.AIRBORNE_CAP, null);
        IAirborne oldAirborne = (IAirborne)event.getOriginal().getCapability(AirborneProvider.AIRBORNE_CAP, null);
        airborne.set(oldAirborne.getAirborne());
    }
}

