/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge.network.message;

import com.elenai.elenaidodge.ElenaiDodge;
import com.elenai.elenaidodge.logic.DodgeLogic;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class HandleDodgeMessage
implements IMessage {
    private boolean messageValid;
    private boolean unlockHud;
    private boolean enableSound;
    private String direction;

    public HandleDodgeMessage() {
        this.messageValid = false;
    }

    public HandleDodgeMessage(boolean unlockHud, boolean enableSound, String direction) {
        this.unlockHud = unlockHud;
        this.enableSound = enableSound;
        this.direction = direction;
        this.messageValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.unlockHud = buf.readBoolean();
            this.enableSound = buf.readBoolean();
            this.direction = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
        catch (IndexOutOfBoundsException ioe) {
            ElenaiDodge.LOG.error("Error occured whilst networking!", (Throwable)ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeBoolean(this.unlockHud);
        buf.writeBoolean(this.enableSound);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.direction);
    }

    public static class Handler
    implements IMessageHandler<HandleDodgeMessage, IMessage> {
        public IMessage onMessage(HandleDodgeMessage message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.SERVER) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(HandleDodgeMessage message, MessageContext ctx) {
            DodgeLogic dodgeLogic = new DodgeLogic(ctx.getServerHandler().field_147369_b, message.unlockHud, message.enableSound, message.direction);
            dodgeLogic.handleDodgeLogic();
        }
    }
}

