/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge.network.message;

import com.elenai.elenaidodge.ElenaiDodge;
import com.elenai.elenaidodge.logic.LedgeGrabLogic;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class ServerLGMessage
implements IMessage {
    private boolean messageValid;
    private int grabs;

    public ServerLGMessage() {
        this.messageValid = false;
    }

    public ServerLGMessage(int grabs) {
        this.grabs = grabs;
        this.messageValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.grabs = buf.readInt();
        }
        catch (IndexOutOfBoundsException ioe) {
            ElenaiDodge.LOG.error("Error occured whilst networking!", (Throwable)ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeInt(this.grabs);
    }

    public static class Handler
    implements IMessageHandler<ServerLGMessage, IMessage> {
        public IMessage onMessage(ServerLGMessage message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.SERVER) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(ServerLGMessage message, MessageContext ctx) {
            LedgeGrabLogic logic = new LedgeGrabLogic();
            logic.handleWallGrab(ctx.getServerHandler().field_147369_b, message.grabs);
        }
    }
}

