/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge.network.message;

import com.elenai.elenaidodge.ElenaiDodge;
import com.elenai.elenaidodge.logic.WallJumpLogic;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class ServerWJMessage
implements IMessage {
    private boolean messageValid;
    private int jumps;
    private int ticks;

    public ServerWJMessage() {
        this.messageValid = false;
    }

    public ServerWJMessage(int jumps, int ticks) {
        this.jumps = jumps;
        this.ticks = ticks;
        this.messageValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.jumps = buf.readInt();
            this.ticks = buf.readInt();
        }
        catch (IndexOutOfBoundsException ioe) {
            ElenaiDodge.LOG.error("Error occured whilst networking!", (Throwable)ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeInt(this.jumps);
        buf.writeInt(this.ticks);
    }

    public static class Handler
    implements IMessageHandler<ServerWJMessage, IMessage> {
        public IMessage onMessage(ServerWJMessage message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.SERVER) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(ServerWJMessage message, MessageContext ctx) {
            WallJumpLogic logic = new WallJumpLogic();
            logic.handleWallJump(ctx.getServerHandler().field_147369_b, message.jumps, message.ticks);
        }
    }
}

