/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge.network.message;

import com.elenai.elenaidodge.ElenaiDodge;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class SetVelocityMessage
implements IMessage {
    private double motionX;
    private double motionY;
    private double motionZ;
    private boolean messageValid;
    private boolean addNotSet;

    public SetVelocityMessage() {
        this.messageValid = false;
    }

    public SetVelocityMessage(double motionX, double motionY, double motionZ, boolean addNotSet) {
        this.motionX = motionX;
        this.motionY = motionY;
        this.motionZ = motionZ;
        this.addNotSet = addNotSet;
        this.messageValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.motionX = buf.readDouble();
            this.motionY = buf.readDouble();
            this.motionZ = buf.readDouble();
            this.addNotSet = buf.readBoolean();
        }
        catch (IndexOutOfBoundsException ioe) {
            ElenaiDodge.LOG.error("Error occured whilst networking!", (Throwable)ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeDouble(this.motionX);
        buf.writeDouble(this.motionY);
        buf.writeDouble(this.motionZ);
        buf.writeBoolean(this.addNotSet);
    }

    public static class Handler
    implements IMessageHandler<SetVelocityMessage, IMessage> {
        public IMessage onMessage(SetVelocityMessage message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.CLIENT) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(SetVelocityMessage message, MessageContext ctx) {
            if (message.addNotSet) {
                Minecraft.func_71410_x().field_71439_g.func_70016_h(Minecraft.func_71410_x().field_71439_g.field_70159_w + message.motionX, Minecraft.func_71410_x().field_71439_g.field_70181_x + message.motionY, Minecraft.func_71410_x().field_71439_g.field_70179_y + message.motionZ);
            } else {
                Minecraft.func_71410_x().field_71439_g.func_70016_h(message.motionX, message.motionY, message.motionZ);
            }
        }
    }
}

