/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy.client;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zabi.minecraft.extraalchemy.ModConfig;
import zabi.minecraft.extraalchemy.gui.container.window.GuiPotionBag;
import zabi.minecraft.extraalchemy.integration.ModIDs;
import zabi.minecraft.extraalchemy.items.MinervaMedal;
import zabi.minecraft.extraalchemy.potion.PotionTypeBase;

@SideOnly(value=Side.CLIENT)
public class PotionDescriptionTooltipHandler {
    private static final HashSet<String> FORBIDDEN_BAG_POT_TYPES = new HashSet();

    @SubscribeEvent
    public void onTooltipEvent(ItemTooltipEvent evt) {
        ItemStack stack = evt.getItemStack();
        if (stack.func_77973_b() != MinervaMedal.medal) {
            if (!PotionDescriptionTooltipHandler.hasHiddenTag(stack)) {
                PotionType pt = PotionUtils.func_185191_c((ItemStack)stack);
                if (pt instanceof PotionTypeBase && !((PotionTypeBase)pt).isArtificial()) {
                    this.displayModOwnTooltip(evt, pt);
                } else if (!pt.func_185170_a().isEmpty()) {
                    PotionDescriptionTooltipHandler.addCredits(evt.getToolTip(), ModIDs.getModName(pt.getRegistryName().func_110624_b()), stack);
                }
            }
            this.showHintForPotionBag(evt);
        }
        this.addByproductString(evt);
    }

    private void showHintForPotionBag(ItemTooltipEvent evt) {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiPotionBag && FORBIDDEN_BAG_POT_TYPES.contains(evt.getItemStack().func_77973_b().getRegistryName().toString())) {
            evt.getToolTip().add(TextFormatting.RED + I18n.func_135052_a((String)"tooltip.no_potion_bag", (Object[])new Object[0]));
        }
    }

    private void displayModOwnTooltip(ItemTooltipEvent evt, PotionType pt) {
        List toolTip = evt.getToolTip();
        String potName = ((PotionTypeBase)pt).getPotion().func_76393_a();
        PotionDescriptionTooltipHandler.addCredits(toolTip, "Extra Alchemy", evt.getItemStack());
        this.addBadJoke(toolTip, potName);
        if (PotionDescriptionTooltipHandler.shouldShowHint(evt.getFlags().func_194127_a())) {
            String textRaw = I18n.func_135052_a((String)("description." + potName), (Object[])new Object[0]);
            toolTip.add("");
            toolTip.add(textRaw);
        } else if (!ModConfig.client.descriptionMode.name().equals("NONE")) {
            toolTip.add(I18n.func_135052_a((String)("tooltip.togglef3." + ModConfig.client.descriptionMode.name()), (Object[])new Object[0]));
        }
    }

    private void addBadJoke(List<String> toolTip, String potName) {
        if (ModConfig.client.showBadJoke) {
            String badJoke = I18n.func_135052_a((String)("funny." + potName), (Object[])new Object[0]);
            toolTip.add(ChatFormatting.GREEN + ChatFormatting.ITALIC.toString() + I18n.func_135052_a((String)badJoke, (Object[])new Object[0]));
        }
    }

    private void addByproductString(ItemTooltipEvent evt) {
        if (evt.getItemStack().func_77942_o() && evt.getItemStack().func_77978_p().func_74764_b("splitresult")) {
            evt.getToolTip().add(I18n.func_135052_a((String)"item.byproduct", (Object[])new Object[0]).replace("%", "" + evt.getItemStack().func_77978_p().func_74762_e("splitresult")));
        }
    }

    private static boolean shouldShowHint(boolean advTooltips) {
        return advTooltips && ModConfig.client.descriptionMode == ModConfig.Mode.F3H || GuiScreen.func_175283_s() && ModConfig.client.descriptionMode == ModConfig.Mode.ALT || GuiScreen.func_146271_m() && ModConfig.client.descriptionMode == ModConfig.Mode.CTRL || GuiScreen.func_146272_n() && ModConfig.client.descriptionMode == ModConfig.Mode.SHIFT;
    }

    private static void addCredits(List<String> toolTip, String modname, ItemStack stack) {
        if (!PotionDescriptionTooltipHandler.isVanillaItem(stack)) {
            toolTip.add("");
            toolTip.add(ChatFormatting.GOLD + I18n.func_135052_a((String)"tooltip.credit", (Object[])new Object[]{modname}));
        }
    }

    private static boolean hasHiddenTag(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_150297_b("HideFlags", 99) && (stack.func_77978_p().func_74762_e("HideFlags") & 0x20) == 1;
    }

    private static boolean isVanillaItem(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151068_bn || stack.func_77973_b() == Items.field_185156_bI || stack.func_77973_b() == Items.field_185155_bH || stack.func_77973_b() == Items.field_185167_i;
    }

    static {
        FORBIDDEN_BAG_POT_TYPES.add("botania:brewVial");
        FORBIDDEN_BAG_POT_TYPES.add("botania:brewFlask");
        FORBIDDEN_BAG_POT_TYPES.add("botania:bloodPendant");
        FORBIDDEN_BAG_POT_TYPES.add("covens:brew_phial_drink");
        FORBIDDEN_BAG_POT_TYPES.add("covens:brew_phial_splash");
        FORBIDDEN_BAG_POT_TYPES.add("covens:brew_phial_linger");
        FORBIDDEN_BAG_POT_TYPES.add("rustic:elixir");
        FORBIDDEN_BAG_POT_TYPES.add("minecraft:lingering_potion");
        FORBIDDEN_BAG_POT_TYPES.add("minecraft:splash_potion");
    }
}

