/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy.integration;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.Loader;
import zabi.minecraft.extraalchemy.ModConfig;
import zabi.minecraft.extraalchemy.lib.Log;

public class BotaniaHandler {
    private static Method hasSolegnolia;
    public static String botaniaID;

    public static void checkLoadBotania() {
        if (Loader.isModLoaded((String)"Botania")) {
            botaniaID = "Botania";
        } else if (Loader.isModLoaded((String)"Botania".toLowerCase())) {
            botaniaID = "Botania".toLowerCase();
        }
        if (botaniaID != null) {
            Log.i("Botania detected, loaiding compatibility");
            BotaniaHandler.loadSolegnoliaCompat();
        }
    }

    public static boolean isSolegnoliaAround(Entity i) {
        try {
            if (hasSolegnolia != null && ((Boolean)hasSolegnolia.invoke(null, i)).booleanValue()) {
                return true;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e1) {
            Log.e(e1);
            Log.w("Failed to check for solegnolias around. Removing integration completely");
            hasSolegnolia = null;
        }
        return false;
    }

    private static void loadSolegnoliaCompat() {
        if (ModConfig.options.respectSolegnolias) {
            try {
                Log.i("Loading Botania Solegnolia integration");
                hasSolegnolia = Class.forName("vazkii.botania.common.block.subtile.functional.SubTileSolegnolia").getMethod("hasSolegnoliaAround", Entity.class);
            }
            catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
                Log.w("Failed to load Solegnolia integration");
                hasSolegnolia = null;
            }
        }
    }

    static {
        botaniaID = null;
    }
}

