/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy.network.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import zabi.minecraft.extraalchemy.ModConfig;
import zabi.minecraft.extraalchemy.lib.Log;

public class PacketConfigStatus
implements IMessage {
    protected long status = 0L;

    public PacketConfigStatus() {
    }

    public PacketConfigStatus(long stat) {
        this.status = stat;
        Log.d("Sending client config status: " + this.status);
    }

    public void fromBytes(ByteBuf buf) {
        this.status = buf.readLong();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.status);
    }

    public static class Handler
    implements IMessageHandler<PacketConfigStatus, IMessage> {
        public IMessage onMessage(PacketConfigStatus message, MessageContext ctx) {
            if (ModConfig.getConfigSignature() != message.status) {
                Log.w("Configuration mismatch for " + ctx.getServerHandler().field_147369_b.func_146103_bH().getName());
                String reasons = ModConfig.getDifferences(message.status);
                ctx.getServerHandler().field_147369_b.field_71135_a.func_147231_a((ITextComponent)new TextComponentString("Your Extra Alchemy configuration isn't compatible with the server, you need to change the following config(s):\n\n" + reasons + "\n\nand restart your game"));
            }
            Log.d("Valid configuration found (" + message.status + ")");
            return null;
        }
    }
}

