/*
 * Decompiled with CFR 0.152.
 */
package heroicarmory;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="heroicarmory")
@Config.LangKey(value="heroicarmory.config.title")
public class ModConfig {
    @Config.Comment(value={"Whether to generate items in chests added by mods. WARNING: This may cause duplicates in vanilla chests, so you may want to lower the loot chance."})
    @Config.Name(value="Include mod chests")
    @Config.RequiresWorldRestart
    public static boolean includeModChests = false;
    @Config.Name(value="Scale Damage")
    @Config.Comment(value={"This number multiplies how much damage every weapon does."})
    @Config.RangeDouble(min=0.0, max=3.0)
    @Config.RequiresMcRestart
    public static double damageScale = 1.0;
    @Config.Name(value="Scale Rarity")
    @Config.Comment(value={"This number exponentially multiplies how rare weapons are to each other (0 means all are equal, 3 means rare weapons are extremely rare)"})
    @Config.RangeDouble(min=0.0, max=3.0)
    @Config.RequiresWorldRestart
    public static double rarityScale = 1.0;
    @Config.Name(value="Scale Loot Chance")
    @Config.Comment(value={"This is the percentage chance that you will find an item in each chest."})
    @Config.RangeDouble(min=0.0, max=1.0)
    @Config.RequiresWorldRestart
    public static double lootChance = 0.75;
    @Config.Comment(value={"Disable items by various types"})
    @Config.RequiresMcRestart
    @Config.Name(value="Disable By Type")
    public static final DisableSets disableSets = new DisableSets();
    @Config.Comment(value={"Disable items by their source series"})
    @Config.RequiresMcRestart
    @Config.Name(value="Disable By Series")
    public static final DisableSeries disableSeries = new DisableSeries();
    @Config.Comment(value={"Disable items one at a time from spawning / showing in creative mode"})
    @Config.RequiresMcRestart
    @Config.Name(value="Disable Individual Items")
    public static final EnabledItems enabledItems = new EnabledItems();

    @Mod.EventBusSubscriber(modid="heroicarmory")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("heroicarmory")) {
                ConfigManager.sync((String)"heroicarmory", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class EnabledItems {
        @Config.Name(value="Lord of the Rings")
        public final lotrEnabled lotrenabled = new lotrEnabled();
        @Config.Name(value="Legend of Zelda")
        public final lozEnabled lozenabled = new lozEnabled();
        @Config.Name(value="Adventure Time")
        public final atEnabled atenabled = new atEnabled();
        @Config.Name(value="Final Fantasy")
        public final ffEnabled ffenabled = new ffEnabled();
        @Config.Name(value="Realm of the Mad God")
        public final rotmgEnabled rotmgenabled = new rotmgEnabled();
        @Config.Name(value="Soul Calibur")
        public final scEnabled scenabled = new scEnabled();
        @Config.Name(value="Runescape")
        public final rsEnabled rsenabled = new rsEnabled();
        @Config.Name(value="Devil May Cry")
        public final dmcEnabled dmcenabled = new dmcEnabled();
        @Config.Name(value="Pokemon")
        public final pkmnEnabled pkmnenabled = new pkmnEnabled();
        @Config.Name(value="Kirby")
        public final kirbyEnabled kirbyenabled = new kirbyEnabled();
        @Config.Name(value="Fire Emblem")
        public final feEnabled feenabled = new feEnabled();
        @Config.Name(value="Kingdom Hearts")
        public final khEnabled khenabled = new khEnabled();
        @Config.Name(value="Bleach")
        public final bleachEnabled bleachenabled = new bleachEnabled();
        @Config.Name(value="Dark Souls")
        public final dsEnabled dsenabled = new dsEnabled();
        @Config.Name(value="Mythology")
        public final mythEnabled mythenabled = new mythEnabled();
        @Config.Name(value="Bayonetta")
        public final bayonettaEnabled bayonettaenabled = new bayonettaEnabled();
        @Config.Name(value="God of War")
        public final gowEnabled gowenabled = new gowEnabled();
        @Config.Name(value="Skyrim")
        public final skyrimEnabled skyrimenabled = new skyrimEnabled();
        @Config.Name(value="Monster Hunter")
        public final mhEnabled mhenabled = new mhEnabled();
        @Config.Name(value="Terraria")
        public final terrariaEnabled terrariaenabled = new terrariaEnabled();
        @Config.Name(value="Star Wars")
        public final swEnabled swenabled = new swEnabled();
        @Config.Name(value="Internet")
        public final internetEnabled internetenabled = new internetEnabled();
        @Config.Name(value="Nethack")
        public final nhEnabled nhenabled = new nhEnabled();
        @Config.Name(value="Merlin (ABC)")
        public final abcmEnabled abcmenabled = new abcmEnabled();

        public static class abcmEnabled {
            @Config.Name(value="Excalibur")
            public boolean abcmExcalibur = true;
        }

        public static class nhEnabled {
            @Config.Name(value="Magicbane")
            public boolean nhMagicbane = true;
            @Config.Name(value="Athame")
            public boolean nhAthame = true;
            @Config.Name(value="Grayswandir")
            public boolean nhGrayswandir = true;
            @Config.Name(value="Silver Saber")
            public boolean nhSilverSaber = true;
        }

        public static class internetEnabled {
            @Config.Name(value="Demonoid's Pitchfork")
            public boolean internetDemonoidPitchfork = true;
        }

        public static class swEnabled {
            @Config.Name(value="Yellow Lightsaber")
            public boolean swYellowLightsaber = true;
            @Config.Name(value="Green Lightsaber")
            public boolean swGreenLightsaber = true;
            @Config.Name(value="Blue Lightsaber")
            public boolean swBlueLightsaber = true;
            @Config.Name(value="Red Lightsaber")
            public boolean swRedLightsaber = true;
            @Config.Name(value="Mace Windu's Lightsaber")
            public boolean swMaceWinduLightsaber = true;
            @Config.Name(value="The Inquisitor's Lightsaber")
            public boolean swTheInquisitorLightsaber = true;
            @Config.Name(value="Darth Maul's Lightsaber")
            public boolean swDarthMaulLightsaber = true;
            @Config.Name(value="Qui Gon Jinn's Lightsaber")
            public boolean swQuiGonJinnLightsaber = true;
            @Config.Name(value="Kylo Ren's Lightsaber")
            public boolean swKyloRenLightsaber = true;
            @Config.Name(value="Count Dooku's Lightsaber")
            public boolean swCountDookuLightsaber = true;
            @Config.Name(value="Darksaber")
            public boolean swDarksaber = true;
        }

        public static class terrariaEnabled {
            @Config.Name(value="Palm Wood Sword")
            public boolean terrariaPalmWoodSword = true;
            @Config.Name(value="Boreal Wood Sword")
            public boolean terrariaBorealWoodSword = true;
            @Config.Name(value="Shadewood Sword")
            public boolean terrariaShadewoodSword = true;
            @Config.Name(value="Ebonwood Sword")
            public boolean terrariaEbonwoodSword = true;
            @Config.Name(value="Copper Shortsword")
            public boolean terrariaCopperShortsword = true;
            @Config.Name(value="Copper Broadsword")
            public boolean terrariaCopperBroadsword = true;
            @Config.Name(value="Tin Shortsword")
            public boolean terrariaTinShortsword = true;
            @Config.Name(value="Tin Broadsword")
            public boolean terrariaTinBroadsword = true;
            @Config.Name(value="Lead Shortsword")
            public boolean terrariaLeadShortsword = true;
            @Config.Name(value="Lead Broadsword")
            public boolean terrariaLeadBroadsword = true;
            @Config.Name(value="Spear")
            public boolean terrariaSpear = true;
            @Config.Name(value="Iron Shortsword")
            public boolean terrariaIronShortsword = true;
            @Config.Name(value="Iron Broadsword")
            public boolean terrariaIronBroadsword = true;
            @Config.Name(value="Silver Broadsword")
            public boolean terrariaSilverBroadsword = true;
            @Config.Name(value="Silver Shortsword")
            public boolean terrariaSilverShortsword = true;
            @Config.Name(value="Gold Shortsword")
            public boolean terrariaGoldShortsword = true;
            @Config.Name(value="Gold Broadsword")
            public boolean terrariaGoldBroadsword = true;
            @Config.Name(value="Tungsten Broadsword")
            public boolean terrariaTungstenBroadsword = true;
            @Config.Name(value="Tungsten Shortsword")
            public boolean terrariaTungstenShortsword = true;
            @Config.Name(value="Platinum Shortsword")
            public boolean terrariaPlatinumShortsword = true;
            @Config.Name(value="Platinum Broadsword")
            public boolean terrariaPlatinumBroadsword = true;
            @Config.Name(value="Mandible Blade")
            public boolean terrariaMandibleBlade = true;
            @Config.Name(value="Katana")
            public boolean terrariaKatana = true;
            @Config.Name(value="Exotic Scimitar")
            public boolean terrariaExoticScimitar = true;
            @Config.Name(value="Muramasa")
            public boolean terrariaMuramasa = true;
            @Config.Name(value="Falcon Blade")
            public boolean terrariaFalconBlade = true;
            @Config.Name(value="Blade of Grass")
            public boolean terrariaBladeofGrass = true;
            @Config.Name(value="Fiery Greatsword")
            public boolean terrariaFieryGreatsword = true;
            @Config.Name(value="Bone Sword")
            public boolean terrariaBoneSword = true;
            @Config.Name(value="Blood Butcherer")
            public boolean terrariaBloodButcherer = true;
            @Config.Name(value="Enchanted Sword")
            public boolean terrariaEnchantedSword = true;
            @Config.Name(value="Starfury")
            public boolean terrariaStarfury = true;
            @Config.Name(value="Bee Keeper")
            public boolean terrariaBeeKeeper = true;
            @Config.Name(value="Ice Blade")
            public boolean terrariaIceBlade = true;
            @Config.Name(value="Night's Edge")
            public boolean terrariaNightEdge = true;
            @Config.Name(value="Arkhalis")
            public boolean terrariaArkhalis = true;
            @Config.Name(value="Trident")
            public boolean terrariaTrident = true;
            @Config.Name(value="The Rotted Fork")
            public boolean terrariaTheRottedFork = true;
            @Config.Name(value="White Phaseblade")
            public boolean terrariaWhitePhaseblade = true;
            @Config.Name(value="Yellow Phaseblade")
            public boolean terrariaYellowPhaseblade = true;
            @Config.Name(value="Purple Phaseblade")
            public boolean terrariaPurplePhaseblade = true;
            @Config.Name(value="Green Phaseblade")
            public boolean terrariaGreenPhaseblade = true;
            @Config.Name(value="Red Phaseblade")
            public boolean terrariaRedPhaseblade = true;
            @Config.Name(value="Blue Phaseblade")
            public boolean terrariaBluePhaseblade = true;
            @Config.Name(value="Light's Bane")
            public boolean terrariaLightBane = true;
            @Config.Name(value="Dark Lance")
            public boolean terrariaDarkLance = true;
            @Config.Name(value="Purple Clubberfish")
            public boolean terrariaPurpleClubberfish = true;
            @Config.Name(value="Cactus Sword")
            public boolean terrariaCactusSword = true;
            @Config.Name(value="Swordfish")
            public boolean terrariaSwordfish = true;
        }

        public static class mhEnabled {
            @Config.Name(value="Chicken Decapitator")
            public boolean mhChickenDecapitator = true;
            @Config.Name(value="Golem Blade")
            public boolean mhGolemBlade = true;
            @Config.Name(value="Defender")
            public boolean mhDefender = true;
            @Config.Name(value="Black Belt Blade")
            public boolean mhBlackBeltBlade = true;
            @Config.Name(value="Wailing Cleaver")
            public boolean mhWailingCleaver = true;
            @Config.Name(value="Gaelic Flame")
            public boolean mhGaelicFlame = true;
            @Config.Name(value="Bone Katana")
            public boolean mhBoneKatana = true;
            @Config.Name(value="Hellish Slasher")
            public boolean mhHellishSlasher = true;
            @Config.Name(value="Centenarian Dagger")
            public boolean mhCentenarianDagger = true;
            @Config.Name(value="Wyvern Blade Blood")
            public boolean mhWyvernBladeBlood = true;
            @Config.Name(value="Wyvern Blade Holly")
            public boolean mhWyvernBladeHolly = true;
            @Config.Name(value="Wyvern Blade Pale")
            public boolean mhWyvernBladePale = true;
            @Config.Name(value="Wyvern Blade Azure")
            public boolean mhWyvernBladeAzure = true;
            @Config.Name(value="Wyvern Blade Leaf")
            public boolean mhWyvernBladeLeaf = true;
            @Config.Name(value="Rathalos Flamesword")
            public boolean mhRathalosFlamesword = true;
        }

        public static class skyrimEnabled {
            @Config.Name(value="Iron Sword")
            public boolean skyrimIronSword = true;
            @Config.Name(value="Iron Warhammer")
            public boolean skyrimIronWarhammer = true;
            @Config.Name(value="Steel Sword")
            public boolean skyrimSteelSword = true;
            @Config.Name(value="Steel Warhammer")
            public boolean skyrimSteelWarhammer = true;
            @Config.Name(value="Orcish Sword")
            public boolean skyrimOrcishSword = true;
            @Config.Name(value="Orcish Warhammer")
            public boolean skyrimOrcishWarhammer = true;
            @Config.Name(value="Dwarven Sword")
            public boolean skyrimDwarvenSword = true;
            @Config.Name(value="Dwarven Warhammer")
            public boolean skyrimDwarvenWarhammer = true;
            @Config.Name(value="Elven Sword")
            public boolean skyrimElvenSword = true;
            @Config.Name(value="Elven Warhammer")
            public boolean skyrimElvenWarhammer = true;
            @Config.Name(value="Glass Sword")
            public boolean skyrimGlassSword = true;
            @Config.Name(value="Glass Warhammer")
            public boolean skyrimGlassWarhammer = true;
            @Config.Name(value="Ebony Sword")
            public boolean skyrimEbonySword = true;
            @Config.Name(value="Ebony Warhammer")
            public boolean skyrimEbonyWarhammer = true;
            @Config.Name(value="Daedric Sword")
            public boolean skyrimDaedricSword = true;
            @Config.Name(value="Daedric Warhammer")
            public boolean skyrimDaedricWarhammer = true;
            @Config.Name(value="Dragonbone Sword")
            public boolean skyrimDragonboneSword = true;
            @Config.Name(value="Dragonbone Warhammer")
            public boolean skyrimDragonboneWarhammer = true;
            @Config.Name(value="Imperial Sword")
            public boolean skyrimImperialSword = true;
            @Config.Name(value="Dawnbreaker")
            public boolean skyrimDawnbreaker = true;
            @Config.Name(value="Ancient Nord Sword")
            public boolean skyrimAncientNordSword = true;
            @Config.Name(value="Chillrend")
            public boolean skyrimChillrend = true;
            @Config.Name(value="Ebony Blade")
            public boolean skyrimEbonyBlade = true;
        }

        public static class gowEnabled {
            @Config.Name(value="Leviathan")
            public boolean gowLeviathanUpgraded = true;
            @Config.Name(value="Leviathan")
            public boolean gowLeviathan = true;
            @Config.Name(value="Blade of Olympus")
            public boolean gowBladeofOlympus = true;
            @Config.Name(value="Blade of Chaos")
            public boolean gowBladeofChaos = true;
        }

        public static class bayonettaEnabled {
            @Config.Name(value="Shuraba")
            public boolean bayonettaShuraba = true;
            @Config.Name(value="Angel Slayer")
            public boolean bayonettaAngelSlayer = true;
        }

        public static class mythEnabled {
            @Config.Name(value="Death's Scythe")
            public boolean mythDeathScythe = true;
            @Config.Name(value="The Devil's Pitchfork")
            public boolean mythTheDevilPitchfork = true;
        }

        public static class dsEnabled {
            @Config.Name(value="Greatsword of Artorias")
            public boolean dsGreatswordofArtorias = true;
            @Config.Name(value="Great Lord Greatsword")
            public boolean dsGreatLordGreatsword = true;
            @Config.Name(value="Astora Greatsword")
            public boolean dsAstoraGreatsword = true;
            @Config.Name(value="Zweilhander")
            public boolean dsZweilhander = true;
        }

        public static class bleachEnabled {
            @Config.Name(value="Zabimaru")
            public boolean bleachZabimaru = true;
            @Config.Name(value="Zangestsu")
            public boolean bleachZangestsu = true;
        }

        public static class khEnabled {
            @Config.Name(value="Keyblade")
            public boolean khKeyblade = true;
        }

        public static class feEnabled {
            @Config.Name(value="Chrom's Falchion")
            public boolean feChromFalchion = true;
            @Config.Name(value="Falchion")
            public boolean feFalchion = true;
        }

        public static class kirbyEnabled {
            @Config.Name(value="Galaxia")
            public boolean kirbyGalaxia = true;
            @Config.Name(value="Kirby's Ultra Sword")
            public boolean kirbyKirbyUltraSword = true;
            @Config.Name(value="Kirby's Sword")
            public boolean kirbyKirbySword = true;
        }

        public static class pkmnEnabled {
            @Config.Name(value="Honedge")
            public boolean pkmnHonedgeShiny = true;
            @Config.Name(value="Honedge")
            public boolean pkmnHonedge = true;
        }

        public static class dmcEnabled {
            @Config.Name(value="Red Queen")
            public boolean dmcRedQueen = true;
            @Config.Name(value="Rebellion")
            public boolean dmcRebellion = true;
            @Config.Name(value="Yamato")
            public boolean dmcYamato = true;
        }

        public static class rsEnabled {
            @Config.Name(value="Bronze Sword")
            public boolean rsBronzeSword = true;
            @Config.Name(value="Iron Sword")
            public boolean rsIronSword = true;
            @Config.Name(value="White Sword")
            public boolean rsWhiteSword = true;
            @Config.Name(value="Black Sword")
            public boolean rsBlackSword = true;
            @Config.Name(value="Steel Sword")
            public boolean rsSteelSword = true;
            @Config.Name(value="Mithril Sword")
            public boolean rsMithrilSword = true;
            @Config.Name(value="Adamant Sword")
            public boolean rsAdamantSword = true;
            @Config.Name(value="Rune Sword")
            public boolean rsRuneSword = true;
            @Config.Name(value="Dragon Sword")
            public boolean rsDragonSword = true;
            @Config.Name(value="Bronze Battleaxe")
            public boolean rsBronzeBattleaxe = true;
            @Config.Name(value="Iron Battleaxe")
            public boolean rsIronBattleaxe = true;
            @Config.Name(value="Steel Battleaxe")
            public boolean rsSteelBattleaxe = true;
            @Config.Name(value="Black Battleaxe")
            public boolean rsBlackBattleaxe = true;
            @Config.Name(value="White Battleaxe")
            public boolean rsWhiteBattleaxe = true;
            @Config.Name(value="Mithril Battleaxe")
            public boolean rsMithrilBattleaxe = true;
            @Config.Name(value="Adamant Battleaxe")
            public boolean rsAdamantBattleaxe = true;
            @Config.Name(value="Rune Battleaxe")
            public boolean rsRuneBattleaxe = true;
            @Config.Name(value="Dragon Battleaxe")
            public boolean rsDragonBattleaxe = true;
            @Config.Name(value="Bronze Scimitar")
            public boolean rsBronzeScimitar = true;
            @Config.Name(value="Iron Scimitar")
            public boolean rsIronScimitar = true;
            @Config.Name(value="Black Scimitar")
            public boolean rsBlackScimitar = true;
            @Config.Name(value="White Scimitar")
            public boolean rsWhiteScimitar = true;
            @Config.Name(value="Steel Scimitar")
            public boolean rsSteelScimitar = true;
            @Config.Name(value="Mithril Scimitar")
            public boolean rsMithrilScimitar = true;
            @Config.Name(value="Adamant Scimitar")
            public boolean rsAdamantScimitar = true;
            @Config.Name(value="Rune Scimitar")
            public boolean rsRuneScimitar = true;
            @Config.Name(value="Dragon Scimitar")
            public boolean rsDragonScimitar = true;
            @Config.Name(value="Bronze Warhammer")
            public boolean rsBronzeWarhammer = true;
            @Config.Name(value="Iron Warhammer")
            public boolean rsIronWarhammer = true;
            @Config.Name(value="Steel Warhammer")
            public boolean rsSteelWarhammer = true;
            @Config.Name(value="Black Warhammer")
            public boolean rsBlackWarhammer = true;
            @Config.Name(value="White Warhammer")
            public boolean rsWhiteWarhammer = true;
            @Config.Name(value="Mithril Warhammer")
            public boolean rsMithrilWarhammer = true;
            @Config.Name(value="Adamant Warhammer")
            public boolean rsAdamantWarhammer = true;
            @Config.Name(value="Rune Warhammer")
            public boolean rsRuneWarhammer = true;
            @Config.Name(value="Bronze Mace")
            public boolean rsBronzeMace = true;
            @Config.Name(value="Iron Mace")
            public boolean rsIronMace = true;
            @Config.Name(value="Steel Mace")
            public boolean rsSteelMace = true;
            @Config.Name(value="Black Mace")
            public boolean rsBlackMace = true;
            @Config.Name(value="White Mace")
            public boolean rsWhiteMace = true;
            @Config.Name(value="Mithril Mace")
            public boolean rsMithrilMace = true;
            @Config.Name(value="Adamant Mace")
            public boolean rsAdamantMace = true;
            @Config.Name(value="Rune Mace")
            public boolean rsRuneMace = true;
            @Config.Name(value="Granite Longsword")
            public boolean rsGraniteLongsword = true;
            @Config.Name(value="Granite Hammer")
            public boolean rsGraniteHammer = true;
            @Config.Name(value="Granite Maul")
            public boolean rsGraniteMaul = true;
            @Config.Name(value="Elder Maul")
            public boolean rsElderMaul = true;
            @Config.Name(value="Toktz-xil-ak")
            public boolean rsToktzxilak = true;
            @Config.Name(value="Wolfsbane")
            public boolean rsWolfsbane = true;
            @Config.Name(value="Zamorak Godsword")
            public boolean rsZamorakGodsword = true;
            @Config.Name(value="Bandos Godsword")
            public boolean rsBandosGodsword = true;
            @Config.Name(value="Armadyl Godsword")
            public boolean rsArmadylGodsword = true;
            @Config.Name(value="Saradomin Godsword")
            public boolean rsSaradominGodsword = true;
            @Config.Name(value="Barrelchest Anchor")
            public boolean rsBarrelchestAnchor = true;
        }

        public static class scEnabled {
            @Config.Name(value="Firangi")
            public boolean scFirangi = true;
            @Config.Name(value="Cocytus")
            public boolean scCocytus = true;
            @Config.Name(value="Erlang's Blade")
            public boolean scErlangBlade = true;
            @Config.Name(value="Soul Edge")
            public boolean scSoulEdgeNightmare = true;
            @Config.Name(value="Phlegathon")
            public boolean scPhlegathon = true;
            @Config.Name(value="Acheron")
            public boolean scAcheron = true;
            @Config.Name(value="Lethe")
            public boolean scLethe = true;
            @Config.Name(value="Queen's Guard")
            public boolean scQueenGuard = true;
            @Config.Name(value="Holy Antler")
            public boolean scHolyAntler = true;
            @Config.Name(value="Epee")
            public boolean scEpee = true;
            @Config.Name(value="War Hammer")
            public boolean scWarHammer = true;
            @Config.Name(value="Kalutues")
            public boolean scKalutues = true;
            @Config.Name(value="Estoc")
            public boolean scEstoc = true;
            @Config.Name(value="Flambert")
            public boolean scFlambert2P = true;
            @Config.Name(value="Reiterpallasch")
            public boolean scReiterpallasch = true;
            @Config.Name(value="Flambert")
            public boolean scFlambert = true;
            @Config.Name(value="Blue Crystal Rod")
            public boolean scBlueCrystalRod = true;
            @Config.Name(value="Fire Blade")
            public boolean scFireBlade = true;
            @Config.Name(value="Xi Sword")
            public boolean scXiSword = true;
            @Config.Name(value="Omega Sword")
            public boolean scOmegaSword2P = true;
            @Config.Name(value="Omega Sword")
            public boolean scOmegaSword = true;
            @Config.Name(value="Orichalcum")
            public boolean scOrichalcum = true;
            @Config.Name(value="Stiletto")
            public boolean scStiletto = true;
            @Config.Name(value="Requiem")
            public boolean scRequiem = true;
            @Config.Name(value="Faust")
            public boolean scFaust = true;
            @Config.Name(value="Flamberge")
            public boolean scFlamberge = true;
            @Config.Name(value="Steel Paddle")
            public boolean scSteelPaddle = true;
            @Config.Name(value="Glam")
            public boolean scGlam = true;
            @Config.Name(value="Great Blade")
            public boolean scGreatBlade = true;
        }

        public static class rotmgEnabled {
            @Config.Name(value="Sword of the Colossus")
            public boolean rotmgSwordoftheColossus = true;
            @Config.Name(value="Crystal Sword")
            public boolean rotmgCrystalSword = true;
            @Config.Name(value="Pixie-Enchanted Sword")
            public boolean rotmgPixieEnchantedSword = true;
            @Config.Name(value="Sword Of Acclaim")
            public boolean rotmgSwordOfAcclaim = true;
            @Config.Name(value="Demon Blade")
            public boolean rotmgDemonBlade = true;
            @Config.Name(value="Sword of the Mad God")
            public boolean rotmgSwordoftheMadGod = true;
            @Config.Name(value="Indomptable")
            public boolean rotmgIndomptable = true;
            @Config.Name(value="Pirate King's Cutlass")
            public boolean rotmgPirateKingCutlass = true;
            @Config.Name(value="Sword of Splendor")
            public boolean rotmgSwordofSplendor = true;
            @Config.Name(value="Skysplitter Sword")
            public boolean rotmgSkysplitterSword = true;
            @Config.Name(value="Archon Sword")
            public boolean rotmgArchonSword = true;
            @Config.Name(value="Ancient Stone Sword")
            public boolean rotmgAncientStoneSword = true;
            @Config.Name(value="Dragonsoul Sword")
            public boolean rotmgDragonsoulSword = true;
            @Config.Name(value="Ravenheart Sword")
            public boolean rotmgRavenheartSword = true;
        }

        public static class ffEnabled {
            @Config.Name(value="The Masamune")
            public boolean ffTheMasamune = true;
            @Config.Name(value="Buster Sword")
            public boolean ffBusterSword = true;
            @Config.Name(value="Caladbolg")
            public boolean ffCaladbolg = true;
        }

        public static class atEnabled {
            @Config.Name(value="Jake's Sword")
            public boolean atJakeSword = true;
            @Config.Name(value="Crystal Sword")
            public boolean atCrystalSword = true;
            @Config.Name(value="Nothung")
            public boolean atNothung = true;
            @Config.Name(value="Finn Sword")
            public boolean atFinnSword = true;
            @Config.Name(value="Sword of the Dead")
            public boolean atSwordoftheDead = true;
            @Config.Name(value="Wish Star Sword")
            public boolean atWishStarSword = true;
            @Config.Name(value="Fight King Sword")
            public boolean atFightKingSword = true;
            @Config.Name(value="Root Sword")
            public boolean atRootSword = true;
            @Config.Name(value="Scarlet")
            public boolean atScarlet = true;
            @Config.Name(value="Grass Sword")
            public boolean atGrassSword = true;
            @Config.Name(value="Demon Blood Sword")
            public boolean atDemonBloodSword = true;
            @Config.Name(value="Axe Bass")
            public boolean atAxeBass = true;
        }

        public static class lozEnabled {
            @Config.Name(value="Master Sword")
            public boolean lozMasterSword = true;
            @Config.Name(value="Master Sword II")
            public boolean lozMasterSwordII = true;
            @Config.Name(value="Tempered Sword")
            public boolean lozTemperedSword = true;
            @Config.Name(value="Master Sword III")
            public boolean lozMasterSwordIII = true;
            @Config.Name(value="Golden Sword")
            public boolean lozGoldenSword = true;
            @Config.Name(value="Flameblade")
            public boolean lozFlameblade = true;
            @Config.Name(value="Darknut Sword")
            public boolean lozDarknutSwordTp = true;
            @Config.Name(value="Ghirahim Sword")
            public boolean lozGhirahimSword = true;
            @Config.Name(value="Fierce Diety's Sword")
            public boolean lozFierceDietySword = true;
            @Config.Name(value="Zelda's Sword")
            public boolean lozZeldaSword = true;
            @Config.Name(value="Boko Stick")
            public boolean lozBokoStick = true;
            @Config.Name(value="Cane of Byrna")
            public boolean lozCaneofByrna = true;
            @Config.Name(value="Megaton Hammer")
            public boolean lozMegatonHammer = true;
            @Config.Name(value="Kokiri Sword")
            public boolean lozKokiriSwordMm = true;
            @Config.Name(value="Kokiri Sword")
            public boolean lozKokiriSwordOoT = true;
            @Config.Name(value="Demise's Sword")
            public boolean lozDemiseSword = true;
            @Config.Name(value="Giant's Knife")
            public boolean lozGiantKnife = true;
            @Config.Name(value="Biggoron's Sword")
            public boolean lozBiggoronSword = true;
            @Config.Name(value="Phantom Ganon's Sword")
            public boolean lozPhantomGanonSword = true;
            @Config.Name(value="Ultimate Sword")
            public boolean lozUltimateSword = true;
            @Config.Name(value="Royal Guard's Sword")
            public boolean lozRoyalGuardSword = true;
            @Config.Name(value="Magic Sword")
            public boolean lozMagicSwordConcept = true;
            @Config.Name(value="Magic Sword")
            public boolean lozMagicSword = true;
            @Config.Name(value="White Sword")
            public boolean lozWhiteSword = true;
            @Config.Name(value="White Sword")
            public boolean lozWhiteSwordConcept = true;
            @Config.Name(value="Picori Blade")
            public boolean lozPicoriBlade = true;
            @Config.Name(value="Razor Sword")
            public boolean lozRazorSword = true;
            @Config.Name(value="Great Fairy's Sword")
            public boolean lozGreatFairySword = true;
            @Config.Name(value="Goddess White Sword")
            public boolean lozGoddessWhiteSword = true;
            @Config.Name(value="Goddess Sword")
            public boolean lozGoddessSword = true;
            @Config.Name(value="Gilded Sword")
            public boolean lozGildedSword = true;
            @Config.Name(value="Spiked Boko Club")
            public boolean lozSpikedBokoClub = true;
            @Config.Name(value="Boko Club")
            public boolean lozBokoClub = true;
        }

        public static class lotrEnabled {
            @Config.Name(value="Gimli's Battle Axe")
            public boolean lotrGimliBattleAxe = true;
            @Config.Name(value="Gimli's Long Axe")
            public boolean lotrGimliLongAxe = true;
            @Config.Name(value="Morgul Blade")
            public boolean lotrMorgulBlade = true;
            @Config.Name(value="Sting")
            public boolean lotrSting = true;
            @Config.Name(value="Glamdring")
            public boolean lotrGlamdring = true;
            @Config.Name(value="Anduril")
            public boolean lotrAnduril = true;
            @Config.Name(value="Narsil")
            public boolean lotrNarsil = true;
            @Config.Name(value="Sauron's Mace")
            public boolean lotrSauronMace = true;
            @Config.Name(value="Witch King's Sword")
            public boolean lotrWitchKingSword = true;
        }
    }

    public static class DisableSeries {
        @Config.Name(value="Include Lord of the Rings")
        @Config.Comment(value={"Remove all Lord of the Rings items from drop tables / creative mode"})
        public boolean lotr = true;
        @Config.Name(value="Include Legend of Zelda")
        @Config.Comment(value={"Remove all Legend of Zelda items from drop tables / creative mode"})
        public boolean loz = true;
        @Config.Name(value="Include Adventure Time")
        @Config.Comment(value={"Remove all Adventure Time items from drop tables / creative mode"})
        public boolean at = true;
        @Config.Name(value="Include Final Fantasy")
        @Config.Comment(value={"Remove all Final Fantasy items from drop tables / creative mode"})
        public boolean ff = true;
        @Config.Name(value="Include Realm of the Mad God")
        @Config.Comment(value={"Remove all Realm of the Mad God items from drop tables / creative mode"})
        public boolean rotmg = true;
        @Config.Name(value="Include Soul Calibur")
        @Config.Comment(value={"Remove all Soul Calibur items from drop tables / creative mode"})
        public boolean sc = true;
        @Config.Name(value="Include Runescape")
        @Config.Comment(value={"Remove all Runescape items from drop tables / creative mode"})
        public boolean rs = true;
        @Config.Name(value="Include Devil May Cry")
        @Config.Comment(value={"Remove all Devil May Cry items from drop tables / creative mode"})
        public boolean dmc = true;
        @Config.Name(value="Include Pokemon")
        @Config.Comment(value={"Remove all Pokemon items from drop tables / creative mode"})
        public boolean pkmn = true;
        @Config.Name(value="Include Kirby")
        @Config.Comment(value={"Remove all Kirby items from drop tables / creative mode"})
        public boolean kirby = true;
        @Config.Name(value="Include Fire Emblem")
        @Config.Comment(value={"Remove all Fire Emblem items from drop tables / creative mode"})
        public boolean fe = true;
        @Config.Name(value="Include Kingdom Hearts")
        @Config.Comment(value={"Remove all Kingdom Hearts items from drop tables / creative mode"})
        public boolean kh = true;
        @Config.Name(value="Include Bleach")
        @Config.Comment(value={"Remove all Bleach items from drop tables / creative mode"})
        public boolean bleach = true;
        @Config.Name(value="Include Dark Souls")
        @Config.Comment(value={"Remove all Dark Souls items from drop tables / creative mode"})
        public boolean ds = true;
        @Config.Name(value="Include Mythology")
        @Config.Comment(value={"Remove all Mythology items from drop tables / creative mode"})
        public boolean myth = true;
        @Config.Name(value="Include Bayonetta")
        @Config.Comment(value={"Remove all Bayonetta items from drop tables / creative mode"})
        public boolean bayonetta = true;
        @Config.Name(value="Include God of War")
        @Config.Comment(value={"Remove all God of War items from drop tables / creative mode"})
        public boolean gow = true;
        @Config.Name(value="Include Skyrim")
        @Config.Comment(value={"Remove all Skyrim items from drop tables / creative mode"})
        public boolean skyrim = true;
        @Config.Name(value="Include Monster Hunter")
        @Config.Comment(value={"Remove all Monster Hunter items from drop tables / creative mode"})
        public boolean mh = true;
        @Config.Name(value="Include Terraria")
        @Config.Comment(value={"Remove all Terraria items from drop tables / creative mode"})
        public boolean terraria = true;
        @Config.Name(value="Include Star Wars")
        @Config.Comment(value={"Remove all Star Wars items from drop tables / creative mode"})
        public boolean sw = true;
        @Config.Name(value="Include Internet")
        @Config.Comment(value={"Remove all Internet items from drop tables / creative mode"})
        public boolean internet = true;
        @Config.Name(value="Include Nethack")
        @Config.Comment(value={"Remove all Nethack items from drop tables / creative mode"})
        public boolean nh = true;
        @Config.Name(value="Include Merlin (ABC)")
        @Config.Comment(value={"Remove all Merlin (ABC) items from drop tables / creative mode"})
        public boolean abcm = true;
    }

    public static class DisableSets {
        @Config.Comment(value={"Removes any futuristic weapons such as light sabers."})
        @Config.Name(value="Include high tech weapons")
        @Config.RequiresWorldRestart
        public boolean tech = true;
        @Config.Comment(value={"Removes all generic weapons (tiered/crafted items from other games)"})
        @Config.Name(value="Include generic weapons")
        @Config.RequiresWorldRestart
        public boolean generic = true;
        @Config.Comment(value={"Removes any generic weapons that have an attack lower than diamond swords."})
        @Config.Name(value="Include low-tier weapons")
        @Config.RequiresWorldRestart
        public boolean lowtier = true;
        @Config.Comment(value={"Removes any silly weapons that don't really make sense as weapons."})
        @Config.Name(value="Include joke weapons")
        @Config.RequiresWorldRestart
        public boolean joke = true;
    }
}

