/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity;

import com.github.alexthe666.iceandfire.client.model.ModelHippocampus;
import com.github.alexthe666.iceandfire.entity.EntityHippocampus;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderHippocampus
extends RenderLiving<EntityHippocampus> {
    private static final ResourceLocation VARIANT_0 = new ResourceLocation("iceandfire:textures/models/hippocampus/hippocampus_0.png");
    private static final ResourceLocation VARIANT_0_BLINK = new ResourceLocation("iceandfire:textures/models/hippocampus/hippocampus_0_blinking.png");
    private static final ResourceLocation VARIANT_1 = new ResourceLocation("iceandfire:textures/models/hippocampus/hippocampus_1.png");
    private static final ResourceLocation VARIANT_1_BLINK = new ResourceLocation("iceandfire:textures/models/hippocampus/hippocampus_1_blinking.png");
    private static final ResourceLocation VARIANT_2 = new ResourceLocation("iceandfire:textures/models/hippocampus/hippocampus_2.png");
    private static final ResourceLocation VARIANT_2_BLINK = new ResourceLocation("iceandfire:textures/models/hippocampus/hippocampus_2_blinking.png");
    private static final ResourceLocation VARIANT_3 = new ResourceLocation("iceandfire:textures/models/hippocampus/hippocampus_3.png");
    private static final ResourceLocation VARIANT_3_BLINK = new ResourceLocation("iceandfire:textures/models/hippocampus/hippocampus_3_blinking.png");
    private static final ResourceLocation VARIANT_4 = new ResourceLocation("iceandfire:textures/models/hippocampus/hippocampus_4.png");
    private static final ResourceLocation VARIANT_4_BLINK = new ResourceLocation("iceandfire:textures/models/hippocampus/hippocampus_4_blinking.png");
    private static final ResourceLocation VARIANT_5 = new ResourceLocation("iceandfire:textures/models/hippocampus/hippocampus_5.png");
    private static final ResourceLocation VARIANT_5_BLINK = new ResourceLocation("iceandfire:textures/models/hippocampus/hippocampus_5_blinking.png");

    public RenderHippocampus(RenderManager renderManager) {
        super(renderManager, (ModelBase)new ModelHippocampus(), 0.8f);
        this.field_177097_h.add(new LayerHippocampusSaddle(this));
        this.field_177097_h.add(new LayerHippocampusBridle(this));
        this.field_177097_h.add(new LayerHippocampusChest(this));
        this.field_177097_h.add(new LayerHippocampusRainbow(this));
        this.field_177097_h.add(new LayerHippocampusArmor(this));
    }

    @Nullable
    protected ResourceLocation getEntityTexture(EntityHippocampus entity) {
        switch (entity.getVariant()) {
            default: {
                return entity.isBlinking() ? VARIANT_0_BLINK : VARIANT_0;
            }
            case 1: {
                return entity.isBlinking() ? VARIANT_1_BLINK : VARIANT_1;
            }
            case 2: {
                return entity.isBlinking() ? VARIANT_2_BLINK : VARIANT_2;
            }
            case 3: {
                return entity.isBlinking() ? VARIANT_3_BLINK : VARIANT_3;
            }
            case 4: {
                return entity.isBlinking() ? VARIANT_4_BLINK : VARIANT_4;
            }
            case 5: 
        }
        return entity.isBlinking() ? VARIANT_5_BLINK : VARIANT_5;
    }

    @SideOnly(value=Side.CLIENT)
    private class LayerHippocampusArmor
    implements LayerRenderer {
        private final RenderHippocampus renderer;
        private final ResourceLocation TEXTURE_DIAMOND = new ResourceLocation("iceandfire:textures/models/hippocampus/armor_diamond.png");
        private final ResourceLocation TEXTURE_GOLD = new ResourceLocation("iceandfire:textures/models/hippocampus/armor_gold.png");
        private final ResourceLocation TEXTURE_IRON = new ResourceLocation("iceandfire:textures/models/hippocampus/armor_iron.png");

        public LayerHippocampusArmor(RenderHippocampus renderer) {
            this.renderer = renderer;
        }

        public void doRenderLayer(EntityHippocampus entity, float f, float f1, float i, float f2, float f3, float f4, float f5) {
            if (entity.getArmor() != 0) {
                GL11.glPushMatrix();
                switch (entity.getArmor()) {
                    case 1: {
                        this.renderer.func_110776_a(this.TEXTURE_IRON);
                        break;
                    }
                    case 2: {
                        this.renderer.func_110776_a(this.TEXTURE_GOLD);
                        break;
                    }
                    case 3: {
                        this.renderer.func_110776_a(this.TEXTURE_DIAMOND);
                    }
                }
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                this.renderer.func_177087_b().func_78088_a((Entity)entity, f, f1, f2, f3, f4, f5);
                GL11.glPopMatrix();
            }
        }

        public boolean func_177142_b() {
            return false;
        }

        public void func_177141_a(EntityLivingBase entity, float f, float f1, float f2, float f3, float f4, float f5, float f6) {
            this.doRenderLayer((EntityHippocampus)entity, f, f1, f2, f3, f4, f5, f6);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private class LayerHippocampusChest
    implements LayerRenderer {
        private final RenderHippocampus renderer;
        private final ResourceLocation TEXTURE = new ResourceLocation("iceandfire:textures/models/hippocampus/chest.png");

        public LayerHippocampusChest(RenderHippocampus renderer) {
            this.renderer = renderer;
        }

        public void doRenderLayer(EntityHippocampus entity, float f, float f1, float i, float f2, float f3, float f4, float f5) {
            if (entity.isChested()) {
                this.renderer.func_110776_a(this.TEXTURE);
                this.renderer.func_177087_b().func_78088_a((Entity)entity, f, f1, f2, f3, f4, f5);
            }
        }

        public boolean func_177142_b() {
            return false;
        }

        public void func_177141_a(EntityLivingBase entity, float f, float f1, float f2, float f3, float f4, float f5, float f6) {
            this.doRenderLayer((EntityHippocampus)entity, f, f1, f2, f3, f4, f5, f6);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private class LayerHippocampusBridle
    implements LayerRenderer {
        private final RenderHippocampus renderer;
        private final ResourceLocation TEXTURE = new ResourceLocation("iceandfire:textures/models/hippocampus/bridle.png");

        public LayerHippocampusBridle(RenderHippocampus renderer) {
            this.renderer = renderer;
        }

        public void doRenderLayer(EntityHippocampus entity, float f, float f1, float i, float f2, float f3, float f4, float f5) {
            if (entity.isSaddled() && entity.func_184179_bs() != null) {
                this.renderer.func_110776_a(this.TEXTURE);
                this.renderer.func_177087_b().func_78088_a((Entity)entity, f, f1, f2, f3, f4, f5);
            }
        }

        public boolean func_177142_b() {
            return false;
        }

        public void func_177141_a(EntityLivingBase entity, float f, float f1, float f2, float f3, float f4, float f5, float f6) {
            this.doRenderLayer((EntityHippocampus)entity, f, f1, f2, f3, f4, f5, f6);
        }
    }

    private class LayerHippocampusRainbow
    implements LayerRenderer {
        private final RenderHippocampus renderer;
        private final ResourceLocation TEXTURE = new ResourceLocation("iceandfire:textures/models/hippocampus/rainbow.png");
        private final ResourceLocation TEXTURE_BLINK = new ResourceLocation("iceandfire:textures/models/hippocampus/rainbow_blink.png");

        public LayerHippocampusRainbow(RenderHippocampus renderer) {
            this.renderer = renderer;
        }

        public void doRenderLayer(EntityHippocampus entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (entitylivingbaseIn.func_145818_k_() && entitylivingbaseIn.func_95999_t().toLowerCase().contains("rainbow")) {
                GL11.glPushMatrix();
                this.renderer.func_110776_a(entitylivingbaseIn.isBlinking() ? this.TEXTURE_BLINK : this.TEXTURE);
                int i1 = 25;
                int i = entitylivingbaseIn.field_70173_aa / 25 + entitylivingbaseIn.func_145782_y();
                int j = EnumDyeColor.values().length;
                int k = i % j;
                int l = (i + 1) % j;
                float f = ((float)(entitylivingbaseIn.field_70173_aa % 25) + partialTicks) / 25.0f;
                float[] afloat1 = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)k));
                float[] afloat2 = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)l));
                GlStateManager.func_179124_c((float)(afloat1[0] * (1.0f - f) + afloat2[0] * f), (float)(afloat1[1] * (1.0f - f) + afloat2[1] * f), (float)(afloat1[2] * (1.0f - f) + afloat2[2] * f));
                this.renderer.func_177087_b().func_78088_a((Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                GL11.glPopMatrix();
            }
        }

        public boolean func_177142_b() {
            return false;
        }

        public void func_177141_a(EntityLivingBase entity, float f, float f1, float f2, float f3, float f4, float f5, float f6) {
            this.doRenderLayer((EntityHippocampus)entity, f, f1, f2, f3, f4, f5, f6);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private class LayerHippocampusSaddle
    implements LayerRenderer {
        private final RenderHippocampus renderer;

        public LayerHippocampusSaddle(RenderHippocampus renderer) {
            this.renderer = renderer;
        }

        public void doRenderLayer(EntityHippocampus entity, float f, float f1, float i, float f2, float f3, float f4, float f5) {
            if (entity.isSaddled()) {
                this.renderer.func_110776_a(new ResourceLocation("iceandfire:textures/models/hippocampus/saddle.png"));
                this.renderer.func_177087_b().func_78088_a((Entity)entity, f, f1, f2, f3, f4, f5);
            }
        }

        public boolean func_177142_b() {
            return false;
        }

        public void func_177141_a(EntityLivingBase entity, float f, float f1, float f2, float f3, float f4, float f5, float f6) {
            this.doRenderLayer((EntityHippocampus)entity, f, f1, f2, f3, f4, f5, f6);
        }
    }
}

