/*
 * Decompiled with CFR 0.152.
 */
package net.pearx.jehc.jei.sbm;

import java.lang.reflect.Field;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.gui.recipes.RecipesGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.pearx.jehc.Jehc;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public abstract class SBMRecipeTransferHandler<C extends Container, G extends GuiScreen, TE extends TileEntity>
implements IRecipeTransferHandler<C> {
    private Class<C> containerClass;
    private Class<G> guiClass;
    private Field fieldItemNum;
    private Field fieldTileEntity;

    public SBMRecipeTransferHandler(Class<C> containerClass, Class<G> guiClass, String tileEntityFieldName) {
        this.containerClass = containerClass;
        this.guiClass = guiClass;
        this.setupFields(tileEntityFieldName);
    }

    private void setupFields(String tileEntityFieldName) {
        this.fieldItemNum = FieldUtils.getDeclaredField(this.guiClass, (String)"itemNum", (boolean)true);
        this.fieldTileEntity = FieldUtils.getDeclaredField(this.guiClass, (String)tileEntityFieldName, (boolean)true);
    }

    public Class<C> getContainerClass() {
        return this.containerClass;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(C container, IRecipeLayout recipeLayout, EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        if (doTransfer) {
            try {
                GuiScreen parentScreen;
                GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
                if (screen instanceof RecipesGui && this.guiClass.isInstance(parentScreen = ((RecipesGui)screen).getParentScreen())) {
                    List recipeIns = ((IGuiIngredient)recipeLayout.getItemStacks().getGuiIngredients().get(1)).getAllIngredients();
                    List recipeOuts = ((IGuiIngredient)recipeLayout.getItemStacks().getGuiIngredients().get(0)).getAllIngredients();
                    int itemNum = -1;
                    block2: for (int i = 0; i < this.getRegistrySize(); ++i) {
                        Pair<ItemStack, ItemStack> p = this.getRecipe(i);
                        ItemStack datIn = (ItemStack)p.getLeft();
                        ItemStack datOut = (ItemStack)p.getRight();
                        for (ItemStack recipeIn : recipeIns) {
                            for (ItemStack recipeOut : recipeOuts) {
                                if (!ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)recipeIn, (ItemStack)datIn) || !ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)recipeOut, (ItemStack)datOut)) continue;
                                itemNum = i;
                                break block2;
                            }
                        }
                    }
                    if (itemNum >= 0) {
                        FieldUtils.writeField((Field)this.fieldItemNum, (Object)parentScreen, (Object)itemNum);
                        this.setBrowsingInfo((TileEntity)FieldUtils.readField((Field)this.fieldTileEntity, (Object)parentScreen), itemNum);
                    }
                }
            }
            catch (Exception e) {
                Jehc.INSTANCE.getLog().error("An error occurred while transferring shipping bin or market recipe!", (Throwable)e);
            }
        }
        return null;
    }

    public abstract void setBrowsingInfo(TE var1, int var2);

    public abstract int getRegistrySize();

    public abstract Pair<ItemStack, ItemStack> getRecipe(int var1);
}

