/*
 * Decompiled with CFR 0.152.
 */
package levelup2.api;

import java.util.List;
import javax.annotation.Nonnull;
import levelup2.api.IPlayerSkill;
import levelup2.api.PlayerSkillStorage;
import levelup2.capability.PlayerCapability;
import levelup2.player.IPlayerClass;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public interface ICharacterClass {
    @Nonnull
    public ResourceLocation getClassName();

    default public String getUnlocalizedName() {
        return "class." + this.getClassName().toString() + ".name";
    }

    default public String getUnlocalizedDescription() {
        return "class." + this.getClassName().toString() + ".desc";
    }

    @Nonnull
    public IPlayerSkill getSpecializationSkill();

    public List<PlayerSkillStorage> getSkillBonuses();

    default public int getBonusSkillLevel(IPlayerSkill skill) {
        if (this.getSkillBonuses() != null && !this.getSkillBonuses().isEmpty()) {
            for (PlayerSkillStorage stor : this.getSkillBonuses()) {
                if (!stor.getSkill().getSkillName().equals((Object)skill.getSkillName())) continue;
                return stor.getLevel();
            }
        }
        return 0;
    }

    default public ItemStack getRepresentativeStack() {
        return this.getSpecializationSkill() != null ? this.getSpecializationSkill().getRepresentativeStack() : ItemStack.field_190927_a;
    }

    default public void applyBonus(EntityPlayer player) {
        IPlayerClass pClass = (IPlayerClass)player.getCapability(PlayerCapability.PLAYER_CLASS, EnumFacing.UP);
        if (pClass != null) {
            pClass.setSkillLevel(this.getSpecializationSkill().getSkillName(), 1);
            if (!this.getSkillBonuses().isEmpty()) {
                for (PlayerSkillStorage skill : this.getSkillBonuses()) {
                    pClass.setSkillLevel(skill.getSkill().getSkillName(), skill.getLevel());
                }
            }
        }
    }
}

