/*
 * Decompiled with CFR 0.152.
 */
package levelup2.gui;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import levelup2.LevelUp2;
import levelup2.api.IPlayerSkill;
import levelup2.gui.GuiSkillChoice;
import levelup2.network.SkillPacketHandler;
import levelup2.player.PlayerExtension;
import levelup2.skills.SkillRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Mouse;

public class GuiSkills
extends GuiScreen {
    private static final int X_MIN = SkillRegistry.smallestDisplayColumn * 32 - 12;
    private static final int Y_MIN = SkillRegistry.smallestDisplayRow * 32 - 170;
    private static final int X_MAX = SkillRegistry.largestDisplayColumn * 32 - 77;
    private static final int Y_MAX = SkillRegistry.largestDisplayRow * 32 - 247;
    private static final ResourceLocation BACKGROUND = new ResourceLocation("levelup2", "textures/gui/background.png");
    private int imageWidth = 256;
    private int imageHeight = 202;
    private int lastX;
    private int lastY;
    private double xScrollO;
    private double yScrollO;
    private double xScrollP;
    private double yScrollP;
    private double targetX = -12.0;
    private double targetY;
    private boolean isScrolling;
    private byte skillTree = 0;
    protected List<ResourceLocation> skillTrees;
    protected PlayerExtension player;
    protected Map<ResourceLocation, Integer> skills = Maps.newHashMap();
    private IPlayerSkill highlightedSkill = null;

    public GuiSkills() {
        this.player = (PlayerExtension)SkillRegistry.getPlayer(LevelUp2.proxy.getPlayer());
        this.targetY = Y_MIN;
        this.xScrollO = this.targetX;
        this.xScrollP = this.targetX;
        this.yScrollO = this.targetY;
        this.yScrollP = this.targetY;
        this.skills.clear();
        for (ResourceLocation str : this.player.getSkills().keySet()) {
            this.skills.put(str, this.player.getSkills().get(str));
        }
        this.skillTrees = SkillRegistry.getSpecializations();
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(3, this.field_146294_l / 2 + 32, this.field_146295_m / 2 + 74, 80, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(0, (this.field_146294_l - this.imageWidth) / 2 + 16, this.field_146295_m / 2 + 74, 20, 20, "<"));
        this.field_146292_n.add(new GuiButton(1, (this.field_146294_l - this.imageWidth) / 2 + 40, this.field_146295_m / 2 + 74, 60, 20, I18n.func_135052_a((String)"gui.addlevel", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(2, (this.field_146294_l - this.imageWidth) / 2 + 104, this.field_146295_m / 2 + 74, 20, 20, ">"));
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 3) {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
        } else if (button.field_146127_k >= 0 && button.field_146127_k < 3) {
            switch (button.field_146127_k) {
                case 0: {
                    this.skillTree = this.skillTree != 0 ? (byte)(this.skillTree - 1) : (byte)(this.skillTrees.size() - 1);
                    break;
                }
                case 2: {
                    this.skillTree = this.skillTree != this.skillTrees.size() - 1 ? (byte)(this.skillTree + 1) : (byte)0;
                    break;
                }
                default: {
                    SkillPacketHandler.levelChannel.sendToServer(SkillPacketHandler.getLevelUpPacket(-1));
                }
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73876_c() {
        this.xScrollO = this.xScrollP;
        this.yScrollO = this.yScrollP;
        double d0 = this.targetX - this.xScrollP;
        double d1 = this.targetY - this.yScrollP;
        if (d0 * d0 + d1 * d1 < 4.0) {
            this.xScrollP += d0;
            this.yScrollP += d1;
        } else {
            this.xScrollP += d0 * 0.85;
            this.yScrollP += d1 * 0.85;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (Mouse.isButtonDown((int)0)) {
            int edgeX = (this.field_146294_l - this.imageWidth) / 2;
            int edgeY = (this.field_146295_m - this.imageHeight) / 2;
            int offX = edgeX + 8;
            int offY = edgeY + 17;
            if (mouseX >= offX && mouseX < offX + 224 && mouseY >= offY && mouseY < offY + 155 && this.highlightedSkill == null) {
                if (!this.isScrolling) {
                    this.isScrolling = true;
                } else {
                    this.xScrollP -= (double)(mouseX - this.lastX);
                    this.yScrollP -= (double)(mouseY - this.lastY);
                    this.xScrollO = this.xScrollP;
                    this.yScrollO = this.yScrollP;
                    this.targetX = this.xScrollP;
                    this.targetY = this.yScrollP;
                }
                this.lastX = mouseX;
                this.lastY = mouseY;
            }
        } else {
            this.isScrolling = false;
        }
        if (this.targetX < (double)X_MIN) {
            this.targetX = X_MIN;
        }
        if (this.targetY < (double)Y_MIN) {
            this.targetY = Y_MIN;
        }
        if (this.targetX >= (double)X_MAX) {
            this.targetX = X_MAX - 1;
        }
        if (this.targetY >= (double)Y_MAX) {
            this.targetY = Y_MAX - 1;
        }
        this.func_146276_q_();
        this.drawSkills(mouseX, mouseY, partialTicks);
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        this.drawTitle();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.highlightedSkill != null && mouseButton == 0) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiSkillChoice(this.highlightedSkill, this.skills.get(this.highlightedSkill.getSkillName()), this));
        }
    }

    private void drawTitle() {
        int edgeX = (this.field_146294_l - this.imageWidth) / 2;
        int edgeY = (this.field_146295_m - this.imageHeight) / 2;
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)("gui." + this.getSpec(this.skillTree).toString() + ".spec"), (Object[])new Object[0]), edgeX + 15, edgeY + 5, 0x404040);
        this.drawLevelOnEnd(edgeX, edgeY);
    }

    private void drawLevelOnEnd(int edgeX, int edgeY) {
        String levels = I18n.func_135052_a((String)"gui.levelup.budget", (Object[])new Object[]{this.player.getLevelBank()});
        int textWidth = this.field_146289_q.func_78256_a(levels);
        int x = edgeX + this.imageWidth - 15 - textWidth;
        int y = edgeY + 5;
        this.field_146289_q.func_78276_b(levels, x, y, 1607962);
    }

    private void drawSkills(int mouseX, int mouseY, float partialTicks) {
        int x = MathHelper.func_76128_c((double)(this.xScrollO + (this.xScrollP - this.xScrollO) * (double)partialTicks));
        int y = MathHelper.func_76128_c((double)(this.yScrollO + (this.yScrollP - this.yScrollO) * (double)partialTicks));
        if (x < X_MIN) {
            x = X_MIN;
        }
        if (y < Y_MIN) {
            y = Y_MIN;
        }
        if (x > X_MAX) {
            x = X_MAX;
        }
        if (y > Y_MAX) {
            y = Y_MAX;
        }
        int edgeX = (this.field_146294_l - this.imageWidth) / 2;
        int edgeY = (this.field_146295_m - this.imageHeight) / 2;
        int offsetX = edgeX + 16;
        int offsetY = edgeY + 17;
        this.field_73735_i = 0.0f;
        GlStateManager.func_179143_c((int)518);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)offsetX, (float)offsetY, (float)-200.0f);
        GlStateManager.func_179126_j();
        GlStateManager.func_179098_w();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        int k1 = x + 288 >> 4;
        int l1 = y + 288 >> 4;
        int i2 = (x + 288) % 16;
        int j2 = (y + 288) % 16;
        Random random = new Random();
        float f = 16.0f;
        float f1 = 16.0f;
        int l3 = 0;
        while ((float)l3 * f - (float)j2 < 155.0f) {
            float f2 = 0.6f - (float)(l1 + l3) / 25.0f * 0.3f;
            GlStateManager.func_179131_c((float)f2, (float)f2, (float)f2, (float)1.0f);
            int i4 = 0;
            while ((float)i4 * f1 - (float)i2 < 224.0f) {
                random.setSeed(this.field_146297_k.func_110432_I().func_148255_b().hashCode() + k1 + i4 + (l1 + l3) * 16);
                int j4 = random.nextInt(1 + l1 + l3) + (l1 + l3) / 2;
                TextureAtlasSprite textureatlassprite = this.getTexture((Block)Blocks.field_150354_m);
                if (j4 <= 37 && l1 + l3 != 35) {
                    if (j4 == 22) {
                        textureatlassprite = random.nextInt(2) == 0 ? this.getTexture(Blocks.field_150482_ag) : this.getTexture(Blocks.field_150450_ax);
                    } else if (j4 == 10) {
                        textureatlassprite = this.getTexture(Blocks.field_150366_p);
                    } else if (j4 == 8) {
                        textureatlassprite = this.getTexture(Blocks.field_150365_q);
                    } else if (j4 > 4) {
                        textureatlassprite = this.getTexture(Blocks.field_150348_b);
                    } else if (j4 > 0) {
                        textureatlassprite = this.getTexture(Blocks.field_150346_d);
                    }
                } else {
                    Block block = Blocks.field_150357_h;
                    textureatlassprite = this.getTexture(block);
                }
                this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
                this.func_175175_a(i4 * 16 - i2, l3 * 16 - j2, textureatlassprite, 16, 16);
                ++i4;
            }
            ++l3;
        }
        GlStateManager.func_179143_c((int)515);
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        for (IPlayerSkill skill : SkillRegistry.getSkillsForSpec(this.getSpec(this.skillTree))) {
            List<IPlayerSkill> prerequisite;
            if (!skill.getSkillType().equals((Object)this.getSpec(this.skillTree)) || !skill.isEnabled() || (prerequisite = this.getPrerequisiteSkills(skill)).isEmpty()) continue;
            int skillX = skill.getSkillColumn() * 32 - x + 11;
            int skillY = skill.getSkillRow() * 32 - 160 - y + 11;
            for (IPlayerSkill pre : prerequisite) {
                int preX = pre.getSkillColumn() * 32 - x + 11;
                int preY = pre.getSkillRow() * 32 - 160 - y + 11;
                int lineColor = this.skills.get(skill.getSkillName()) > 0 ? -6250336 : (this.skills.get(pre.getSkillName()) > 0 ? -16711936 : -16777216);
                this.func_73730_a(skillX, preX, skillY, lineColor);
                this.func_73728_b(preX, skillY, preY, lineColor);
            }
        }
        IPlayerSkill skill = null;
        int xPos = mouseX - offsetX;
        int yPos = mouseY - offsetY;
        RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        for (IPlayerSkill check : SkillRegistry.getSkillsForSpec(this.getSpec(this.skillTree))) {
            if (!check.getSkillType().equals((Object)this.getSpec(this.skillTree)) || !check.isEnabled()) continue;
            int checkX = check.getSkillColumn() * 32 - x;
            int checkY = check.getSkillRow() * 32 - 160 - y;
            if (checkX < -24 || checkY < -24 || checkX > 224 || checkY > 155) continue;
            float col = 0.3f;
            if (this.isMaxLevel(check)) {
                col = 0.9f;
            } else if (this.skills.get(check.getSkillName()) > 0) {
                col = 0.75f;
            } else if (this.canUnlock(check)) {
                col = 0.6f;
            }
            GlStateManager.func_179131_c((float)col, (float)col, (float)col, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
            GlStateManager.func_179147_l();
            if (check.isMaxLevel(this.skills.get(check.getSkillName()))) {
                this.func_73729_b(checkX, checkY, 26, 202, 26, 26);
            } else {
                this.func_73729_b(checkX, checkY, 0, 202, 26, 26);
            }
            GlStateManager.func_179084_k();
            if (this.skills.get(check.getSkillName()) == 0) {
                GlStateManager.func_179131_c((float)0.1f, (float)0.1f, (float)0.1f, (float)1.0f);
            }
            GlStateManager.func_179140_f();
            GlStateManager.func_179089_o();
            this.field_146297_k.func_175599_af().func_180450_b(check.getRepresentativeStack(), checkX + 4, checkY + 4);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179140_f();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (xPos < checkX || xPos > checkX + 22 || yPos < checkY || yPos > checkY + 22) continue;
            skill = check;
        }
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        this.func_73729_b(edgeX, edgeY, 0, 0, this.imageWidth, this.imageHeight);
        this.field_73735_i = 0.0f;
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179097_i();
        GlStateManager.func_179098_w();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (skill != null) {
            int height;
            int xOff = mouseX + 12;
            int yOff = mouseY - 4;
            String skillName = I18n.func_135052_a((String)("skill." + skill.getSkillName() + ".name"), (Object[])new Object[0]);
            String skillLevel = this.skills.get(skill.getSkillName()) + "/" + skill.getMaxLevel();
            if (this.canUnlock(skill)) {
                int width = Math.max(this.field_146289_q.func_78256_a(skillName), 80);
                height = this.field_146289_q.func_78267_b(skillName, width);
                int levelCost = skill.getLevelCost(this.skills.get(skill.getSkillName()));
                if (levelCost > 0) {
                    height += 12;
                    this.field_146289_q.func_78279_b(I18n.func_135052_a((String)"levelup.cost", (Object[])new Object[]{levelCost}), xOff, yOff + 24, width, 16514415);
                }
                this.func_73733_a(xOff - 3, yOff - 3, xOff + width + 3, yOff + height + 3 + 12, -1073741824, -1073741824);
                this.field_146289_q.func_78279_b(skillLevel, xOff, yOff + 12, width, 16514415);
            } else {
                int width = Math.max(this.field_146289_q.func_78256_a(skillName), 80);
                if (this.isLockedSkill(skill)) {
                    height = this.field_146289_q.func_78267_b(skillName, width);
                    this.func_73733_a(xOff - 3, yOff - 3, xOff + width + 3, yOff + height + 3, -1073741824, -1073741824);
                } else if (this.hasPrerequisites(skill)) {
                    height = this.field_146289_q.func_78267_b(skillName, width) + 12 * this.getMissingPrereqAmount(skill);
                    if (this.getMissingPrereqAmount(skill) > 0) {
                        List<String> names = this.getMissingPrereqSkills(skill);
                        for (int i = 0; i < names.size(); ++i) {
                            String name = i == 0 ? I18n.func_135052_a((String)"levelup.prereq", (Object[])new Object[]{names.get(i)}) : names.get(i);
                            int place = i + 1;
                            if (this.field_146289_q.func_78256_a(name) > width) {
                                width = this.field_146289_q.func_78256_a(name);
                            }
                            this.field_146289_q.func_78279_b(name, xOff, yOff + 12 * place, width, 16514415);
                        }
                    }
                    this.func_73733_a(xOff - 3, yOff - 3, xOff + width + 3, yOff + height + 3, -1073741824, -1073741824);
                }
            }
            this.field_146289_q.func_175063_a(skillName, (float)xOff, (float)yOff, -8355712);
        }
        if (skill != this.highlightedSkill) {
            this.highlightedSkill = skill;
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179145_e();
        RenderHelper.func_74518_a();
    }

    private ResourceLocation getSpec(byte spec) {
        return this.skillTrees.get(spec);
    }

    private boolean hasPrerequisites(IPlayerSkill skill) {
        return skill.getPrerequisites() != null && skill.getPrerequisites().length != 0;
    }

    private IPlayerSkill getSkillFromName(ResourceLocation name) {
        return SkillRegistry.getSkillFromName(name);
    }

    private List<IPlayerSkill> getPrerequisiteSkills(IPlayerSkill skill) {
        ArrayList<IPlayerSkill> skills = new ArrayList<IPlayerSkill>();
        if (this.hasPrerequisites(skill)) {
            for (ResourceLocation name : skill.getPrerequisites()) {
                IPlayerSkill check = this.getSkillFromName(name);
                if (check == null || !check.isEnabled()) continue;
                skills.add(check);
            }
        }
        return skills;
    }

    private int getMissingPrereqAmount(IPlayerSkill skill) {
        return this.getMissingPrereqSkills(skill).size();
    }

    private List<String> getMissingPrereqSkills(IPlayerSkill skill) {
        ArrayList<String> names = new ArrayList<String>();
        List<IPlayerSkill> skills = this.getPrerequisiteSkills(skill);
        if (!skills.isEmpty()) {
            for (IPlayerSkill check : skills) {
                if (this.skills.get(check.getSkillName()) != 0) continue;
                names.add(I18n.func_135052_a((String)("skill." + check.getSkillName() + ".name"), (Object[])new Object[0]));
            }
        }
        return names;
    }

    private boolean isMaxLevel(IPlayerSkill skill) {
        return this.skills.get(skill.getSkillName()).intValue() == skill.getMaxLevel();
    }

    private boolean isLockedSkill(IPlayerSkill skill) {
        return skill.getLevelCost(0) == -1;
    }

    protected boolean canUnlock(IPlayerSkill skill) {
        List<IPlayerSkill> skills = this.getPrerequisiteSkills(skill);
        if (!skills.isEmpty()) {
            for (IPlayerSkill check : skills) {
                if (this.skills.get(check.getSkillName()) != 0) continue;
                return false;
            }
        }
        return skill.getLevelCost(this.skills.get(skill.getSkillName())) > -1;
    }

    private TextureAtlasSprite getTexture(Block blockIn) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(blockIn.func_176223_P());
    }

    public void func_146281_b() {
        Map<ResourceLocation, Integer> map = this.skillsChanged();
        if (!map.isEmpty()) {
            FMLProxyPacket pkt = SkillPacketHandler.getSkillPacket(Side.SERVER, 2, map, this.player.getLevelBank(), null);
            SkillPacketHandler.skillChannel.sendToServer(pkt);
        }
    }

    private Map<ResourceLocation, Integer> skillsChanged() {
        HashMap map = Maps.newHashMap();
        for (ResourceLocation loc : SkillRegistry.getSkills().keySet()) {
            if (this.skills.get(loc).equals(this.player.getSkills().get(loc))) continue;
            map.put(loc, this.skills.get(loc));
        }
        return map;
    }

    private boolean canUnlockSkill(IPlayerSkill skill) {
        int levels = this.player.getLevelBank();
        return this.canUnlock(skill) && levels > 0 && skill.getLevelCost(this.skills.get(skill.getSkillName())) >= levels && skill.getLevelCost(this.skills.get(skill.getSkillName())) > -1;
    }
}

