/*
 * Decompiled with CFR 0.152.
 */
package levelup2.mixin;

import levelup2.api.IProcessor;
import levelup2.capability.PlayerCapability;
import levelup2.skills.SkillRegistry;
import levelup2.util.SmeltingBlacklist;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TileEntityFurnace.class})
public abstract class MixinFurnace
implements ICapabilityProvider {
    private static final ResourceLocation FURNACESPEED = new ResourceLocation("levelup", "furnacespeed");
    private static final ResourceLocation FURNACEBONUS = new ResourceLocation("levelup", "furnacebonus");

    @Shadow
    public abstract boolean func_145948_k();

    @Shadow
    public abstract ItemStack func_70301_a(int var1);

    @Shadow
    public abstract void func_70299_a(int var1, ItemStack var2);

    @Inject(method={"getCookTime"}, at={@At(value="RETURN")}, cancellable=true)
    private void levelUpGetCookTime(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        IProcessor cap = this.getCapability();
        if (cap != null) {
            int skillLevel;
            int cookTime = 200;
            if (cap.getPlayerFromUUID() != null && (skillLevel = SkillRegistry.getSkillLevel(cap.getPlayerFromUUID(), FURNACESPEED)) > 0) {
                int cookMinus = Math.min(skillLevel * 20, 180);
                cir.setReturnValue(cookTime - cookMinus);
            }
        }
    }

    @Inject(method={"smeltItem"}, at={@At(value="HEAD")})
    private void levelUpSmeltItem(CallbackInfo ci) {
        EntityPlayer player;
        int doubleChance;
        IProcessor cap = this.getCapability();
        if (this.func_145948_k() && this.isDoublingValid() && cap != null && cap.getPlayerFromUUID() != null && (doubleChance = SkillRegistry.getSkillLevel(player = cap.getPlayerFromUUID(), FURNACEBONUS)) > 0 && player.func_70681_au().nextFloat() < (float)doubleChance / 40.0f) {
            ItemStack smeltingItem = FurnaceRecipes.func_77602_a().func_151395_a(this.func_70301_a(0));
            ItemStack resultSlot = this.func_70301_a(2);
            if (resultSlot.func_190926_b()) {
                this.func_70299_a(2, smeltingItem.func_77946_l());
            } else if (resultSlot.func_190916_E() + smeltingItem.func_190916_E() * 2 <= resultSlot.func_77976_d()) {
                resultSlot.func_190917_f(smeltingItem.func_190916_E());
            }
        }
    }

    private boolean isDoublingValid() {
        ItemStack smeltingItem = this.func_70301_a(0);
        return !smeltingItem.func_190926_b() && !SmeltingBlacklist.contains(smeltingItem);
    }

    private IProcessor getCapability() {
        return this.hasCapability(PlayerCapability.MACHINE_PROCESSING, EnumFacing.UP) ? (IProcessor)this.getCapability(PlayerCapability.MACHINE_PROCESSING, EnumFacing.UP) : null;
    }
}

