/*
 * Decompiled with CFR 0.152.
 */
package levelup2.mixin.fastfurnace;

import levelup2.api.IProcessor;
import levelup2.capability.PlayerCapability;
import levelup2.skills.SkillRegistry;
import levelup2.util.SmeltingBlacklist;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import shadows.fastfurnace.block.TileFastFurnace;

@Mixin(value={TileFastFurnace.class})
public abstract class MixinFastFurnace
extends TileEntityFurnace
implements ICapabilityProvider {
    private static final ResourceLocation FURNACEBONUS = new ResourceLocation("levelup", "furnacebonus");
    @Shadow(remap=false)
    protected ItemStack recipeKey;

    @Shadow(remap=false)
    abstract boolean itemsMatch(ItemStack var1, ItemStack var2);

    @Inject(method={"smeltItem"}, at={@At(value="HEAD")})
    private void levelUpSmeltItem(CallbackInfo ci) {
        EntityPlayer player;
        int doubleChance;
        IProcessor cap = this.getCapability();
        if (this.isDoublingValid() && cap != null && cap.getPlayerFromUUID() != null && (doubleChance = SkillRegistry.getSkillLevel(player = cap.getPlayerFromUUID(), FURNACEBONUS)) > 0 && player.func_70681_au().nextFloat() < (float)doubleChance / 40.0f) {
            ItemStack input = this.func_70301_a(0);
            ItemStack recipeOutput = (ItemStack)FurnaceRecipes.func_77602_a().func_77599_b().get(this.recipeKey);
            ItemStack output = this.func_70301_a(2);
            if (output.func_190926_b()) {
                this.func_70299_a(2, recipeOutput.func_77946_l());
            } else if (this.itemsMatch(output, recipeOutput)) {
                output.func_190917_f(recipeOutput.func_190916_E());
            }
        }
    }

    private boolean isDoublingValid() {
        ItemStack smeltingItem = this.func_70301_a(0);
        return !smeltingItem.func_190926_b() && !SmeltingBlacklist.contains(smeltingItem);
    }

    private IProcessor getCapability() {
        return this.hasCapability(PlayerCapability.MACHINE_PROCESSING, EnumFacing.UP) ? (IProcessor)this.getCapability(PlayerCapability.MACHINE_PROCESSING, EnumFacing.UP) : null;
    }
}

