/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.book;

import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Article {
    protected String text;
    protected NonNullList<ItemStack> stacks = NonNullList.func_191196_a();
    private String name;
    protected int index;
    static final int maxItems = 10;

    public Article(String name) {
        this.name = name;
    }

    public Article(String name, ItemStack ... stacks) {
        this(name);
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b() || this.stacks.size() >= 10) continue;
            this.stacks.add((Object)stack);
        }
    }

    public Article(String name, IForgeRegistryEntry.Impl<?> ... impls) {
        this(name);
        for (IForgeRegistryEntry.Impl<?> impl : impls) {
            if (impl instanceof Item && this.stacks.size() < 10) {
                this.stacks.add((Object)new ItemStack((Item)impl));
                continue;
            }
            if (!(impl instanceof Block) || this.stacks.size() >= 10) continue;
            this.stacks.add((Object)new ItemStack((Block)impl));
        }
    }

    public Article setText(String text) {
        this.text = text;
        return this;
    }

    public String getName() {
        return I18n.func_135052_a((String)this.name, (Object[])new Object[0]);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Article other = (Article)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

