/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.gui.button;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.List;
import mrriegel.limelib.gui.GuiDrawer;
import mrriegel.limelib.gui.element.ITooltip;
import mrriegel.limelib.helper.ColorHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.input.Mouse;

public class CommonGuiButton
extends GuiButtonExt
implements ITooltip {
    protected List<String> tooltip;
    protected Minecraft mc = Minecraft.func_71410_x();
    protected GuiDrawer drawer = new GuiDrawer(0, 0, 0, 0, this.field_73735_i);
    protected int frameColor = Color.BLACK.getRGB();
    protected int buttonColor = Color.DARK_GRAY.getRGB();
    protected int overlayColor = Integer.MAX_VALUE;
    protected Design design = Design.NORMAL;
    protected ItemStack stack = ItemStack.field_190927_a;

    public CommonGuiButton(int id, int xPos, int yPos, int width, int height, String displayString) {
        super(id, xPos, yPos, width, height, displayString);
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partial) {
        if (this.field_146125_m) {
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            int k = this.func_146114_a(this.field_146123_n);
            if (this.design == Design.NORMAL) {
                GuiUtils.drawContinuousTexturedBox((ResourceLocation)field_146122_a, (int)this.field_146128_h, (int)this.field_146129_i, (int)0, (int)(46 + k * 20), (int)this.field_146120_f, (int)this.field_146121_g, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.field_73735_i);
            } else if (this.design == Design.SIMPLE) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                this.drawer.drawFrame(this.field_146128_h, this.field_146129_i, this.field_146120_f - 1, this.field_146121_g - 1, 1, this.frameColor);
                this.drawer.drawColoredRectangle(this.field_146128_h + 1, this.field_146129_i + 1, this.field_146120_f - 2, this.field_146121_g - 2, this.field_146124_l ? (this.field_146123_n && !Mouse.isButtonDown((int)0) ? ColorHelper.brighter(this.buttonColor, 0.1) : this.buttonColor) : ColorHelper.darker(this.buttonColor, 0.1));
            } else if (this.design == Design.NONE) {
                // empty if block
            }
            if (this.overlayColor != Integer.MAX_VALUE) {
                CommonGuiButton.func_73734_a((int)(this.field_146128_h + 0), (int)(this.field_146129_i + 0), (int)(this.field_146128_h + this.field_146120_f - 0), (int)(this.field_146129_i + this.field_146121_g - 0), (int)ColorHelper.getRGB(this.overlayColor, 140 + (k == 2 ? 60 : 0)));
            }
            this.func_146119_b(mc, mouseX, mouseY);
            int color = 0xE0E0E0;
            if (this.packedFGColour != 0) {
                color = this.packedFGColour;
            } else if (!this.field_146124_l) {
                color = 0xA0A0A0;
            } else if (this.field_146123_n) {
                color = 0xFFFFA0;
            }
            if (!Strings.isNullOrEmpty((String)this.field_146126_j)) {
                String buttonText = this.field_146126_j;
                int strWidth = mc.field_71466_p.func_78256_a(buttonText);
                int ellipsisWidth = mc.field_71466_p.func_78256_a("...");
                if (strWidth > this.field_146120_f - 6 && strWidth > ellipsisWidth) {
                    buttonText = mc.field_71466_p.func_78269_a(buttonText, this.field_146120_f - 6 - ellipsisWidth).trim() + "...";
                }
                int xS = this.field_146128_h + this.field_146120_f / 2;
                this.func_73732_a(mc.field_71466_p, buttonText, xS, this.field_146129_i + (this.field_146121_g - 8) / 2, color);
            }
            if (!this.stack.func_190926_b()) {
                int yp = Math.max(this.field_146129_i, this.field_146129_i + Math.max(this.field_146121_g - 16, 0) / 2);
                int xp = Math.max(this.field_146128_h, this.field_146128_h + Math.max(this.field_146120_f - 16, 0) / 2);
                this.drawer.drawItemStack(this.stack, xp, yp);
            }
        }
    }

    @Override
    public void drawTooltip(int mouseX, int mouseY) {
        int h;
        int w;
        GlStateManager.func_179094_E();
        if (this.mc.field_71462_r == null) {
            ScaledResolution sr = new ScaledResolution(this.mc);
            w = sr.func_78326_a();
            h = sr.func_78328_b();
        } else {
            w = this.mc.field_71462_r.field_146294_l;
            h = this.mc.field_71462_r.field_146295_m;
        }
        if (this.tooltip != null) {
            GuiUtils.drawHoveringText(this.tooltip, (int)mouseX, (int)mouseY, (int)w, (int)h, (int)-1, (FontRenderer)this.mc.field_71466_p);
        }
        GlStateManager.func_179121_F();
    }

    public CommonGuiButton setTooltip(List<String> lines) {
        this.tooltip = lines;
        return this;
    }

    public CommonGuiButton setTooltip(String string) {
        this.tooltip = Lists.newArrayList((Object[])new String[]{string});
        return this;
    }

    public CommonGuiButton setFrameColor(int frameColor) {
        this.frameColor = frameColor;
        return this;
    }

    public CommonGuiButton setButtonColor(int buttonColor) {
        this.buttonColor = buttonColor;
        return this;
    }

    public CommonGuiButton setOverlayColor(int overlayColor) {
        this.overlayColor = overlayColor;
        return this;
    }

    public CommonGuiButton setDesign(Design design) {
        this.design = design;
        return this;
    }

    public CommonGuiButton setStack(ItemStack stack) {
        this.stack = stack;
        return this;
    }

    public static enum Design {
        NORMAL,
        SIMPLE,
        NONE;

    }
}

