/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.helper;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mrriegel.limelib.LimeLib;
import mrriegel.limelib.helper.StackHelper;
import mrriegel.limelib.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class BlockHelper {
    private static Field harvesters = ReflectionHelper.findField(Block.class, (String[])new String[]{"harvesters"});
    private static Reference2ObjectMap<Block, ThreadLocal<EntityPlayer>> players = new Reference2ObjectOpenHashMap();
    private static Map<Class<?>, Method> methodMap = Maps.newHashMap();

    public static boolean isBlockBreakable(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return !world.func_175623_d(pos) && !state.func_177230_c().func_149688_o(state).func_76224_d() && state.func_177230_c().func_176195_g(state, world, pos) > -1.0f;
    }

    private static ThreadLocal<EntityPlayer> getPlayer(Block block) {
        ThreadLocal harvesters = (ThreadLocal)players.get((Object)block);
        if (harvesters == null) {
            try {
                harvesters = (ThreadLocal)BlockHelper.harvesters.get(block);
                players.put((Object)block, (Object)harvesters);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return harvesters;
    }

    public static NonNullList<ItemStack> breakBlock(World world, BlockPos pos, IBlockState state, @Nullable EntityPlayer player, boolean silk, int fortune, boolean dropXP, boolean particle) {
        if (!BlockHelper.isBlockBreakable(world, pos)) {
            return NonNullList.func_191196_a();
        }
        Block block = state.func_177230_c();
        int exp = block.getExpDrop(state, (IBlockAccess)world, pos, fortune);
        if (player != null) {
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, player);
            event.setExpToDrop(exp);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return NonNullList.func_191196_a();
            }
            exp = event.getExpToDrop();
        }
        if (particle) {
            world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
        }
        NonNullList lis = null;
        if (silk && block.canSilkHarvest(world, pos, state, player)) {
            lis = NonNullList.func_191196_a();
            ItemStack drop = BlockHelper.getSilkDrop(world, pos, player);
            if (!drop.func_190926_b()) {
                lis.add((Object)drop);
            }
        } else {
            lis = BlockHelper.getFortuneDrops(world, pos, player, fortune);
        }
        if (player != null && !ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos)) {
            lis.clear();
        }
        world.func_175698_g(pos);
        if (block instanceof BlockShulkerBox) {
            return NonNullList.func_191196_a();
        }
        if (dropXP && !silk && exp > 0) {
            block.func_180637_b(world, pos, exp);
        }
        return lis;
    }

    public static NonNullList<ItemStack> getFortuneDrops(World world, BlockPos pos, EntityPlayer player, int fortune) {
        IBlockState state = world.func_180495_p(pos);
        ThreadLocal<EntityPlayer> harvesters = BlockHelper.getPlayer(state.func_177230_c());
        if (player != null) {
            harvesters.set(player);
        }
        Object tmp = NonNullList.func_191196_a();
        state.func_177230_c().getDrops(tmp, (IBlockAccess)world, pos, state, fortune);
        try {
            Method m = state.func_177230_c().getClass().getMethod("getDrops", IBlockAccess.class, BlockPos.class, IBlockState.class, Integer.TYPE);
            if (m.getDeclaringClass() != Block.class) {
                tmp = state.func_177230_c().getDrops((IBlockAccess)world, pos, state, fortune);
            }
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        float chance = ForgeEventFactory.fireBlockHarvesting((List)tmp, (World)world, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)player);
        NonNullList lis = NonNullList.func_191196_a();
        for (ItemStack item : tmp) {
            if (item.func_190926_b() || !(world.field_73012_v.nextFloat() <= chance)) continue;
            lis.add((Object)item);
        }
        harvesters.set(null);
        return lis;
    }

    public static ItemStack getSilkDrop(World world, BlockPos pos, EntityPlayer player) {
        IBlockState state = world.func_180495_p(pos);
        ThreadLocal<EntityPlayer> harvesters = BlockHelper.getPlayer(state.func_177230_c());
        if (player != null) {
            harvesters.set(player);
        }
        NonNullList tmp = NonNullList.func_191196_a();
        if (state.func_177230_c().canSilkHarvest(world, pos, state, player)) {
            Method m = null;
            Class<?> clazz = state.func_177230_c().getClass();
            HashSet clazzes = Sets.newHashSet((Object[])new Class[]{clazz});
            while (m == null) {
                if (methodMap.containsKey(clazz)) {
                    m = methodMap.get(clazz);
                    continue;
                }
                try {
                    m = ReflectionHelper.findMethod(clazz, (String)"getSilkTouchDrop", (String)"func_180643_i", (Class[])new Class[]{IBlockState.class});
                }
                catch (Exception e) {
                    clazz = clazz.getSuperclass();
                    if (clazz == null) break;
                    clazzes.add(clazz);
                }
            }
            for (Class c : clazzes) {
                methodMap.put(c, m);
            }
            ItemStack silked = ItemStack.field_190927_a;
            try {
                silked = (ItemStack)m.invoke((Object)state.func_177230_c(), state);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
            if (!silked.func_190926_b()) {
                tmp.add((Object)silked);
            }
        }
        ForgeEventFactory.fireBlockHarvesting((List)tmp, (World)world, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
        harvesters.set(null);
        return tmp.isEmpty() ? ItemStack.field_190927_a : (ItemStack)tmp.get(0);
    }

    public static boolean isOre(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (!state.func_177230_c().func_149686_d(state)) {
            return false;
        }
        try {
            ItemStack stack = ItemStack.field_190927_a;
            try {
                EntityPlayer player = world.field_72995_K ? LimeLib.proxy.getClientPlayer() : Utils.getFakePlayer((WorldServer)world);
                stack = BlockHelper.getSilkDrop(world, pos, player);
                if (stack.func_190926_b()) {
                    stack = state.func_177230_c().getPickBlock(state, new RayTraceResult(new Vec3d(0.0, 0.0, 0.0), EnumFacing.UP), world, pos, player);
                }
                return StackHelper.isOre(stack);
            }
            catch (Exception e) {
                stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_180651_a(state));
                return StackHelper.isOre(stack);
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isToolEffective(ItemStack tool, World world, BlockPos pos, boolean reallyEffective) {
        if (ForgeHooks.isToolEffective((IBlockAccess)world, (BlockPos)pos, (ItemStack)tool)) {
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        if ((state = state.func_177230_c().func_176221_a(state, (IBlockAccess)world, pos)).func_185887_b(world, pos) < 0.0f) {
            return false;
        }
        return !reallyEffective && state.func_177230_c().getHarvestTool(state) == null || tool.func_77973_b().getToolClasses(tool).contains(state.func_177230_c().getHarvestTool(state));
    }

    public static boolean canToolHarvestBlock(IBlockAccess world, BlockPos pos, @Nonnull ItemStack stack) {
        IBlockState state = world.func_180495_p(pos);
        state = state.func_177230_c().func_176221_a(state, world, pos);
        if (world instanceof World && state.func_185887_b((World)world, pos) < 0.0f) {
            return false;
        }
        String tool = state.func_177230_c().getHarvestTool(state);
        if (state.func_177230_c().func_149688_o(state).func_76229_l()) {
            return true;
        }
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b().getHarvestLevel(stack, tool, null, null) >= state.func_177230_c().getHarvestLevel(state);
    }
}

