/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.helper;

import java.awt.Color;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.math.MathHelper;

public class ColorHelper {
    public static int getRGB(EnumDyeColor color) {
        return color.func_193350_e() | 0xFF000000;
    }

    public static int getRGB(EnumDyeColor color, int alpha) {
        return ColorHelper.getRGB(ColorHelper.getRGB(color), alpha);
    }

    public static int getRGB(int color, int alpha) {
        alpha = MathHelper.func_76125_a((int)alpha, (int)0, (int)255);
        Color c = new Color(color, true);
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha).getRGB();
    }

    public static void glColor(int color) {
        GlStateManager.func_179131_c((float)((float)ColorHelper.getRed(color) / 255.0f), (float)((float)ColorHelper.getGreen(color) / 255.0f), (float)((float)ColorHelper.getBlue(color) / 255.0f), (float)((float)ColorHelper.getAlpha(color) / 255.0f));
    }

    public static int getRed(int color) {
        return (0xFF000000 | color) >> 16 & 0xFF;
    }

    public static int getGreen(int color) {
        return (0xFF000000 | color) >> 8 & 0xFF;
    }

    public static int getBlue(int color) {
        return (0xFF000000 | color) >> 0 & 0xFF;
    }

    public static int getAlpha(int color) {
        return color >> 24 & 0xFF;
    }

    public static int getRainbow(int frequence) {
        if (frequence <= 0) {
            frequence = 1;
        }
        return Color.getHSBColor((float)(System.currentTimeMillis() / (long)frequence % 360L) / 360.0f, 1.0f, 1.0f).getRGB();
    }

    public static int brighter(int color, double factor) {
        if (factor < 0.0) {
            factor = 0.0;
        } else if (factor > 1.0) {
            factor = 1.0;
        }
        int red = (int)Math.round(Math.min(255.0, (double)ColorHelper.getRed(color) + 255.0 * factor));
        int green = (int)Math.round(Math.min(255.0, (double)ColorHelper.getGreen(color) + 255.0 * factor));
        int blue = (int)Math.round(Math.min(255.0, (double)ColorHelper.getBlue(color) + 255.0 * factor));
        return new Color(red, green, blue, ColorHelper.getAlpha(color)).getRGB();
    }

    public static int darker(int color, double factor) {
        if (factor < 0.0) {
            factor = 0.0;
        } else if (factor > 1.0) {
            factor = 1.0;
        }
        int red = (int)Math.round(Math.max(0.0, (double)ColorHelper.getRed(color) - 255.0 * factor));
        int green = (int)Math.round(Math.max(0.0, (double)ColorHelper.getGreen(color) - 255.0 * factor));
        int blue = (int)Math.round(Math.max(0.0, (double)ColorHelper.getBlue(color) - 255.0 * factor));
        return new Color(red, green, blue, ColorHelper.getAlpha(color)).getRGB();
    }
}

