/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import mrriegel.limelib.helper.StackHelper;
import mrriegel.limelib.item.CommonItem;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CommonItemTool
extends CommonItem {
    protected Set<String> toolClasses;
    protected final Set<Block> effectiveBlocks;
    protected final Item.ToolMaterial toolMaterial;

    public CommonItemTool(String name, Item.ToolMaterial material, String ... toolClasses) {
        super(name);
        this.toolMaterial = material;
        this.toolClasses = toolClasses != null ? Sets.newHashSet((Object[])toolClasses) : Collections.EMPTY_SET;
        this.effectiveBlocks = CommonItemTool.effectives(this.toolClasses);
        this.func_77625_d(1);
        this.func_77656_e(material.func_77997_a());
    }

    private static Set<Block> effectives(Set<String> toolClasses) {
        HashSet blocks = Sets.newHashSet();
        if (toolClasses.contains("pickaxe")) {
            blocks.addAll((Collection)ReflectionHelper.getPrivateValue(ItemPickaxe.class, null, (int)0));
        }
        if (toolClasses.contains("shovel")) {
            blocks.addAll((Collection)ReflectionHelper.getPrivateValue(ItemSpade.class, null, (int)0));
        }
        if (toolClasses.contains("axe")) {
            blocks.addAll((Collection)ReflectionHelper.getPrivateValue(ItemAxe.class, null, (int)0));
        }
        return blocks;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return this.toolClasses;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.toolMaterial.func_77995_e();
    }

    public Item.ToolMaterial getToolMaterial() {
        return this.toolMaterial;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(2, attacker);
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if (!worldIn.field_72995_K && (double)state.func_185887_b(worldIn, pos) != 0.0) {
            stack.func_77972_a(1, entityLiving);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    protected final double getBaseDamage(ItemStack stack) {
        ArrayList lis = Lists.newArrayList();
        if (this.getToolClasses(stack).contains("axe")) {
            lis.add(5.0);
        }
        if (this.getToolClasses(stack).contains("shovel")) {
            lis.add(1.5);
        }
        if (this.getToolClasses(stack).contains("pickaxe")) {
            lis.add(1.0);
        }
        return (double)Math.round(lis.stream().mapToDouble(Double::doubleValue).sum() / (double)lis.size() * 10.0) / 10.0;
    }

    protected final double getBaseSpeed(ItemStack stack) {
        ArrayList lis = Lists.newArrayList();
        if (this.getToolClasses(stack).contains("axe")) {
            lis.add(-3.0);
        }
        if (this.getToolClasses(stack).contains("shovel")) {
            lis.add(-3.0);
        }
        if (this.getToolClasses(stack).contains("pickaxe")) {
            lis.add(-2.8);
        }
        return (double)Math.round(lis.stream().mapToDouble(Double::doubleValue).sum() / (double)lis.size() * 10.0) / 10.0;
    }

    protected double getAttackDamage(ItemStack stack) {
        return this.getBaseDamage(stack) + (double)this.toolMaterial.func_78000_c();
    }

    protected double getAttackSpeed(ItemStack stack) {
        return this.getBaseSpeed(stack);
    }

    protected float getDigSpeed(ItemStack stack, float efficiencyOnProperMaterial) {
        return efficiencyOnProperMaterial;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        float result = 1.0f;
        if (this.toolClasses.contains("pickaxe")) {
            result = this.getDigSpeed(stack, Items.field_151046_w.func_150893_a(stack, state));
        }
        if (this.toolClasses.contains("axe")) {
            result = Math.max(result, this.getDigSpeed(stack, Items.field_151056_x.func_150893_a(stack, state)));
        }
        for (String type : this.getToolClasses(stack)) {
            if (!state.func_177230_c().isToolEffective(type, state)) continue;
            result = Math.max(result, this.getDigSpeed(stack, this.toolMaterial.func_77998_b()));
        }
        return Math.max(result, this.effectiveBlocks.contains(state.func_177230_c()) ? this.getDigSpeed(stack, this.toolMaterial.func_77998_b()) : 1.0f);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, EntityPlayer player, IBlockState blockState) {
        return this.getToolClasses(stack).contains(toolClass) ? this.toolMaterial.func_77996_d() : super.getHarvestLevel(stack, toolClass, player, blockState);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        boolean sup = super.func_82789_a(toRepair, repair);
        if (!sup) {
            sup = StackHelper.equalOreDict(this.toolMaterial.getRepairItemStack(), repair);
        }
        return sup;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", this.getAttackDamage(stack), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", this.getAttackSpeed(stack), 0));
        }
        return multimap;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        if (this.toolClasses.contains("pickaxe")) {
            return Items.field_151046_w.canHarvestBlock(state, stack);
        }
        if (this.toolClasses.contains("shovel")) {
            return Items.field_151047_v.canHarvestBlock(state, stack);
        }
        return super.canHarvestBlock(state, stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!player.func_184586_b(hand).func_77973_b().getToolClasses(player.func_184586_b(hand)).contains("shovel")) {
            return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        }
        return Items.field_151047_v.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }
}

