/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.network;

import mrriegel.limelib.datapart.DataPart;
import mrriegel.limelib.datapart.DataPartRegistry;
import mrriegel.limelib.helper.NBTHelper;
import mrriegel.limelib.network.AbstractMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;

public class PlayerClickMessage
extends AbstractMessage {
    public PlayerClickMessage() {
    }

    public PlayerClickMessage(BlockPos pos, EnumHand hand, boolean left) {
        NBTHelper.set(this.nbt, "pos", pos);
        NBTHelper.set(this.nbt, "left", left);
        NBTHelper.set(this.nbt, "mainhand", hand == EnumHand.MAIN_HAND);
    }

    @Override
    public void handleMessage(EntityPlayer player, NBTTagCompound nbt, Side side) {
        EnumHand hand;
        DataPartRegistry reg = DataPartRegistry.get(player.field_70170_p);
        DataPart part = reg.getDataPart(NBTHelper.get(nbt, "pos", BlockPos.class));
        EnumHand enumHand = hand = NBTHelper.get(nbt, "mainhand", Boolean.class) != false ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
        if (part != null) {
            if (NBTHelper.get(nbt, "left", Boolean.class).booleanValue()) {
                part.onLeftClicked(player, hand);
            } else {
                part.onRightClicked(player, hand);
            }
        }
    }
}

