/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.tile;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import mrriegel.limelib.network.PacketHandler;
import mrriegel.limelib.network.TileGuiMessage;
import mrriegel.limelib.network.TileMessage;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CommonTile
extends TileEntity {
    private boolean syncDirty;
    public Set<EntityPlayer> activePlayers = Sets.newHashSet();

    public NBTTagCompound func_189517_E_() {
        return this.serializeNBT();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = this.writeToSyncNBT(new NBTTagCompound());
        return new SPacketUpdateTileEntity(this.field_174879_c, 1337, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.readFromSyncNBT(tag);
    }

    public void readFromSyncNBT(NBTTagCompound compound) {
        this.func_145839_a(compound);
    }

    public NBTTagCompound writeToSyncNBT(NBTTagCompound compound) {
        return this.func_189515_b(compound);
    }

    public boolean needsSync() {
        return this.syncDirty;
    }

    public void markForSync() {
        this.syncDirty = true;
    }

    public void unmarkForSync() {
        this.syncDirty = false;
    }

    public void sync() {
        this.func_70296_d();
        if (this.onServer()) {
            for (EntityPlayerMP player : this.field_145850_b.func_72872_a(EntityPlayerMP.class, new AxisAlignedBB(this.field_174879_c.func_177982_a(-11, -11, -11), this.field_174879_c.func_177982_a(11, 11, 11)))) {
                SPacketUpdateTileEntity p = this.func_189518_D_();
                if (p == null) continue;
                player.field_71135_a.func_147359_a((Packet)p);
            }
        }
    }

    public boolean isUsable(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this || this.func_145837_r() ? false : player.func_70092_e((double)this.getX() + 0.5, (double)this.getY() + 0.5, (double)this.getZ() + 0.5) <= 64.0;
    }

    public List<ItemStack> getDroppingItems() {
        return NonNullList.func_191196_a();
    }

    public boolean openGUI(EntityPlayerMP player) {
        return false;
    }

    public final void sendOpenGUI() {
        if (this.field_145850_b.field_72995_K) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74772_a("pos", this.field_174879_c.func_177986_g());
            PacketHandler.sendToServer(new TileGuiMessage(nbt));
        }
    }

    public void handleMessage(EntityPlayer player, NBTTagCompound nbt) {
    }

    public final void sendMessage(NBTTagCompound nbt) {
        nbt.func_74772_a("pOs", this.field_174879_c.func_177986_g());
        PacketHandler.sendToServer(new TileMessage(nbt));
    }

    public void neighborChanged(IBlockState state, Block block, BlockPos fromPos) {
    }

    public final int getX() {
        return this.field_174879_c.func_177958_n();
    }

    public final int getY() {
        return this.field_174879_c.func_177956_o();
    }

    public final int getZ() {
        return this.field_174879_c.func_177952_p();
    }

    public IBlockState getBlockState() {
        return this.field_145850_b.func_180495_p(this.field_174879_c);
    }

    public boolean onServer() {
        return !this.field_145850_b.field_72995_K;
    }

    public boolean onClient() {
        return !this.onServer();
    }
}

