/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.tile;

import java.util.List;
import javax.annotation.Nullable;
import mrriegel.limelib.util.LimeCapabilities;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;

public interface IHUDProvider {
    public static final String SHADOWFONT = "?~_\u6f2b~%z";

    @Nullable
    public List<String> getData(boolean var1, EnumFacing var2);

    default public int getBackgroundColor(boolean sneak, EnumFacing facing) {
        return 0x44FFFFFF;
    }

    default public Side readingSide() {
        return Side.CLIENT;
    }

    default public boolean center(boolean sneak, EnumFacing facing) {
        return true;
    }

    default public double scale(boolean sneak, EnumFacing facing) {
        return 0.8;
    }

    default public boolean lineBreak(boolean sneak, EnumFacing facing) {
        return true;
    }

    public static boolean isHUDProvider(TileEntity t) {
        if (t != null) {
            return t.hasCapability(LimeCapabilities.hudproviderCapa, null) || t instanceof IHUDProvider;
        }
        return false;
    }

    public static IHUDProvider getHUDProvider(TileEntity t) {
        IHUDProvider dk = null;
        if (t != null) {
            dk = (IHUDProvider)t.getCapability(LimeCapabilities.hudproviderCapa, null);
        }
        if (dk == null) {
            dk = (IHUDProvider)t;
        }
        return dk;
    }
}

