/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.tile;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mrriegel.limelib.LimeLib;
import mrriegel.limelib.util.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;

@Optional.InterfaceList(value={@Optional.Interface(iface="mcp.mobius.waila.api.IWailaDataProvider", modid="waila"), @Optional.Interface(iface="mcjty.theoneprobe.api.IProbeInfoProvider", modid="theoneprobe")})
public interface IInfoProvider<T extends TileEntity>
extends IWailaDataProvider,
IProbeInfoProvider {
    public static final List<Pair<IInfoProvider<?>, Class<? extends TileEntity>>> providers = Lists.newArrayList();

    public Class<T> getTileClass();

    default public List<String> getHeadLines(T tile, IBlockState state, EntityPlayer player, ItemStack stack, boolean sneak) {
        return Collections.emptyList();
    }

    default public List<String> getBodyLines(T tile, IBlockState state, EntityPlayer player, ItemStack stack, boolean sneak) {
        return Collections.emptyList();
    }

    default public List<String> getTailLines(T tile, IBlockState state, EntityPlayer player, ItemStack stack, boolean sneak) {
        return Collections.emptyList();
    }

    default public Side readingSide() {
        return Side.SERVER;
    }

    default public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return ItemStack.field_190927_a;
    }

    default public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        List<String> niu = this.getHeadLines(this.readingSide().isClient() ? accessor.getTileEntity() : IInfoProvider.getSyncedTile(accessor.getTileEntity(), accessor), accessor.getBlockState(), accessor.getPlayer(), itemStack, Keyboard.isKeyDown((int)42) || accessor.getPlayer().func_70093_af());
        if (niu != null && !niu.isEmpty()) {
            currenttip.addAll(niu);
        }
        return currenttip;
    }

    default public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        List<String> niu = this.getBodyLines(this.readingSide().isClient() ? accessor.getTileEntity() : IInfoProvider.getSyncedTile(accessor.getTileEntity(), accessor), accessor.getBlockState(), accessor.getPlayer(), itemStack, Keyboard.isKeyDown((int)42) || accessor.getPlayer().func_70093_af());
        if (niu != null && !niu.isEmpty()) {
            currenttip.addAll(niu);
        }
        return currenttip;
    }

    default public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        List<String> niu = this.getTailLines(this.readingSide().isClient() ? accessor.getTileEntity() : IInfoProvider.getSyncedTile(accessor.getTileEntity(), accessor), accessor.getBlockState(), accessor.getPlayer(), itemStack, Keyboard.isKeyDown((int)42) || accessor.getPlayer().func_70093_af());
        if (niu != null && !niu.isEmpty()) {
            currenttip.addAll(niu);
        }
        return currenttip;
    }

    default public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        return te.func_189517_E_();
    }

    default public String getID() {
        return Utils.getCurrentModID();
    }

    default public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        BlockPos pos;
        if (probeInfo != null && world != null && blockState != null && data != null && (pos = data.getPos()) != null) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity == null || tileEntity.getClass() != this.getTileClass()) {
                return;
            }
            TileEntity t = tileEntity;
            this.getHeadLines(t, blockState, player, data.getPickBlock(), mode == ProbeMode.EXTENDED).forEach(s -> probeInfo.text(s));
            this.getBodyLines(t, blockState, player, data.getPickBlock(), mode == ProbeMode.EXTENDED).forEach(s -> probeInfo.text(s));
            this.getTailLines(t, blockState, player, data.getPickBlock(), mode == ProbeMode.EXTENDED).forEach(s -> probeInfo.text(s));
        }
    }

    public static void registerProvider(IInfoProvider<?> provider, Class<? extends TileEntity> clazz) {
        if (!providers.stream().map(p -> (Class)p.getRight()).anyMatch(c -> c == clazz)) {
            providers.add(Pair.of(provider, clazz));
        } else {
            LimeLib.log.warn(clazz + " is already registered.");
        }
    }

    public static List<Pair<IInfoProvider<?>, Class<? extends TileEntity>>> getProviders() {
        return Collections.unmodifiableList(providers);
    }

    public static TileEntity getSyncedTile(TileEntity t, IWailaDataAccessor accessor) {
        try {
            TileEntity tile = (TileEntity)t.getClass().newInstance();
            tile.handleUpdateTag(accessor.getNBTData());
            tile.func_145834_a(t.func_145831_w());
            tile.func_174878_a(t.func_174877_v());
            return tile;
        }
        catch (IllegalAccessException | InstantiationException e) {
            return t;
        }
    }
}

