/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mrriegel.limelib.datapart.CapabilityDataPart;
import mrriegel.limelib.datapart.DataPart;
import mrriegel.limelib.datapart.DataPartRegistry;
import mrriegel.limelib.gui.CommonContainer;
import mrriegel.limelib.helper.RecipeHelper;
import mrriegel.limelib.helper.TeleportationHelper;
import mrriegel.limelib.network.EnergySyncMessage;
import mrriegel.limelib.network.HUDProviderMessage;
import mrriegel.limelib.network.PacketHandler;
import mrriegel.limelib.network.PlayerClickMessage;
import mrriegel.limelib.tile.CommonTile;
import mrriegel.limelib.tile.IOwneable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="limelib")
public class EventHandler {
    private static Map<Side, Map<String, Long>> lastClicks = null;

    @SubscribeEvent
    public static void left(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getEntityPlayer() != null) {
            IOwneable o;
            IBlockState state = event.getWorld().func_180495_p(event.getPos());
            if (!state.func_177230_c().hasTileEntity(state)) {
                return;
            }
            TileEntity tile = event.getWorld().func_175625_s(event.getPos());
            if (tile instanceof IOwneable && !(o = (IOwneable)tile).canAccess(event.getEntityPlayer())) {
                event.setCanceled(true);
                event.setResult(Event.Result.DENY);
                event.setUseBlock(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void right(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntityPlayer() != null) {
            IOwneable o;
            IBlockState state = event.getWorld().func_180495_p(event.getPos());
            if (!state.func_177230_c().hasTileEntity(state)) {
                return;
            }
            TileEntity tile = event.getWorld().func_175625_s(event.getPos());
            if (tile instanceof IOwneable && !(o = (IOwneable)tile).canAccess(event.getEntityPlayer())) {
                event.setResult(Event.Result.DENY);
                event.setUseBlock(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void tick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == Side.SERVER) {
            DataPartRegistry reg;
            try {
                if (event.world.func_82737_E() % 4L == 0L) {
                    for (int i = 0; i < event.world.field_147482_g.size(); ++i) {
                        CommonTile tile;
                        TileEntity t = (TileEntity)event.world.field_147482_g.get(i);
                        CommonTile commonTile = tile = t instanceof CommonTile ? (CommonTile)t : null;
                        if (tile == null || !tile.needsSync()) continue;
                        tile.sync();
                        tile.unmarkForSync();
                    }
                }
            }
            catch (ConcurrentModificationException i) {
                // empty catch block
            }
            if ((reg = DataPartRegistry.get(event.world)) != null) {
                for (DataPart part : reg.getParts().stream().filter(p -> p != null && event.world.func_175667_e(p.getPos())).collect(Collectors.toList())) {
                    part.updateServer(event.world);
                    ++part.ticksExisted;
                    if (event.world.func_82737_E() % 200L != 0L) continue;
                    reg.sync(part.getPos(), false);
                }
            }
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == Side.SERVER) {
            if (event.player.field_70170_p.func_82737_E() % (long)(event.player.func_70093_af() ? 8 : 20) == 0L) {
                PacketHandler.sendTo(new EnergySyncMessage((EntityPlayerMP)event.player), (EntityPlayerMP)event.player);
            }
            if (event.player.field_70170_p.func_82737_E() % 5L == 0L) {
                PacketHandler.sendTo(new HUDProviderMessage((EntityPlayerMP)event.player), (EntityPlayerMP)event.player);
            }
        }
        if (event.phase == TickEvent.Phase.END && event.player.field_71070_bA instanceof CommonContainer) {
            ((CommonContainer)event.player.field_71070_bA).update(event.player);
        }
    }

    @SubscribeEvent
    public static void test(LivingEvent.LivingJumpEvent event) {
        if (!RecipeHelper.dev || !(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        if (!player.field_70170_p.field_72995_K) {
            System.out.println("sds");
            BlockPos pb = new BlockPos((Entity)player);
            TileEntity t = player.field_70170_p.func_175625_s(pb.func_177977_b());
            new Thread(() -> {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                player.field_70170_p.func_73046_m().func_152344_a(() -> {
                    ItemStack e = ItemStack.field_190927_a;
                    while (e.func_190926_b()) {
                        ArrayList list = Lists.newArrayList((Iterable)ForgeRegistries.ITEMS);
                        e = new ItemStack((Item)list.get(player.field_70170_p.field_73012_v.nextInt(list.size())));
                    }
                    Block.func_180635_a((World)player.field_70170_p, (BlockPos)pb, (ItemStack)e);
                });
            }).start();
            List sheeps = player.field_70170_p.func_72872_a(EntitySheep.class, new AxisAlignedBB(new BlockPos((Entity)player).func_177982_a(-6, -6, -6), new BlockPos((Entity)player).func_177982_a(6, 6, 6)));
            if (".".isEmpty()) {
                if (!sheeps.isEmpty()) {
                    // empty if block
                }
                if (player.field_71093_bK == 0) {
                    TeleportationHelper.teleport((Entity)player, new BlockPos(110, 130, -20), 12);
                } else {
                    TeleportationHelper.teleport((Entity)player, new BlockPos(12, 5, -6), 0);
                }
            }
        }
    }

    @SubscribeEvent
    public static void test(TickEvent.PlayerTickEvent event) {
        if (!RecipeHelper.dev) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            // empty if block
        }
    }

    @SubscribeEvent
    public static void attachWorld(AttachCapabilitiesEvent<World> event) {
        event.addCapability(DataPartRegistry.LOCATION, (ICapabilityProvider)new CapabilityDataPart.CapaProvider((World)event.getObject()));
    }

    @SubscribeEvent
    public static void login(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            ((IThreadListener)event.player.field_70170_p).func_152344_a(() -> {
                DataPartRegistry reg = DataPartRegistry.get(event.player.field_70170_p);
                if (reg != null) {
                    reg.getParts().forEach(p -> reg.sync(p.getPos(), true));
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void interact(PlayerInteractEvent event) {
        boolean server;
        boolean left = event instanceof PlayerInteractEvent.LeftClickBlock || event instanceof PlayerInteractEvent.LeftClickEmpty;
        boolean right = event instanceof PlayerInteractEvent.RightClickBlock || event instanceof PlayerInteractEvent.RightClickEmpty || event instanceof PlayerInteractEvent.RightClickItem;
        boolean bl = server = event instanceof PlayerInteractEvent.RightClickBlock || event instanceof PlayerInteractEvent.LeftClickBlock || event instanceof PlayerInteractEvent.RightClickItem;
        if ((left || right) && !event.isCanceled() && !(event.getEntityPlayer() instanceof FakePlayer)) {
            DataPart part = DataPart.rayTrace(event.getEntityPlayer());
            Side side = event.getSide();
            if (part != null && part.clientValid() && !event.getEntityPlayer().func_70093_af()) {
                if (lastClicks == null) {
                    lastClicks = Maps.newTreeMap();
                    lastClicks.put(Side.SERVER, Maps.newTreeMap());
                    lastClicks.put(Side.CLIENT, Maps.newTreeMap());
                }
                boolean touch = false;
                if (!lastClicks.get(side).containsKey(event.getEntityPlayer().func_70005_c_()) || System.currentTimeMillis() - lastClicks.get(side).get(event.getEntityPlayer().func_70005_c_()) > (long)(left ? 150 : 40)) {
                    if (left) {
                        touch = part.onLeftClicked(event.getEntityPlayer(), event.getHand());
                    } else {
                        touch = part.onRightClicked(event.getEntityPlayer(), event.getHand());
                        event.getEntityPlayer().func_184609_a(event.getHand());
                    }
                    if (!server && event.getWorld().field_72995_K) {
                        PacketHandler.sendToServer(new PlayerClickMessage(part.getPos(), event.getHand(), left));
                    }
                    lastClicks.get(side).put(event.getEntityPlayer().func_70005_c_(), System.currentTimeMillis());
                }
                if (!touch) {
                    return;
                }
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                event.setResult(Event.Result.DENY);
                if (event instanceof PlayerInteractEvent.LeftClickBlock) {
                    ((PlayerInteractEvent.LeftClickBlock)event).setUseBlock(Event.Result.DENY);
                    ((PlayerInteractEvent.LeftClickBlock)event).setUseItem(Event.Result.DENY);
                } else if (event instanceof PlayerInteractEvent.RightClickBlock) {
                    ((PlayerInteractEvent.RightClickBlock)event).setUseBlock(Event.Result.DENY);
                    ((PlayerInteractEvent.RightClickBlock)event).setUseItem(Event.Result.DENY);
                }
            }
        }
    }
}

