/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import mrriegel.limelib.helper.NBTHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class TypeAdapters {

    public static class NBTLizer
    extends JsonLizer<NBTTagCompound> {
        @Override
        public NBTTagCompound serialize(NBTTagCompound t, JsonSerializationContext context) {
            return NBTHelper.set(new NBTTagCompound(), "nnbbtt", t);
        }

        @Override
        public NBTTagCompound deserialize(NBTTagCompound nbt, JsonDeserializationContext context) {
            return NBTHelper.get(nbt, "nnbbtt", NBTTagCompound.class);
        }
    }

    public static class ItemStackLizer
    extends JsonLizer<ItemStack> {
        @Override
        public NBTTagCompound serialize(ItemStack t, JsonSerializationContext context) {
            return t.func_77955_b(new NBTTagCompound());
        }

        @Override
        public ItemStack deserialize(NBTTagCompound nbt, JsonDeserializationContext context) {
            return new ItemStack(nbt);
        }
    }

    public static class ItemLizer
    extends JsonLizer<Item> {
        @Override
        public NBTTagCompound serialize(Item t, JsonSerializationContext context) {
            NBTTagCompound n = new NBTTagCompound();
            n.func_74778_a("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)t).toString());
            return n;
        }

        @Override
        public Item deserialize(NBTTagCompound nbt, JsonDeserializationContext context) {
            return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(nbt.func_74779_i("item")));
        }
    }

    private static abstract class JsonLizer<T>
    implements JsonDeserializer<T>,
    JsonSerializer<T> {
        private JsonLizer() {
        }

        public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("NBTNBT", this.serialize(src, context).toString());
            return json;
        }

        public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                return this.deserialize(JsonToNBT.func_180713_a((String)json.getAsJsonObject().get("NBTNBT").getAsString()), context);
            }
            catch (NBTException e) {
                e.printStackTrace();
                return null;
            }
        }

        public abstract NBTTagCompound serialize(T var1, JsonSerializationContext var2);

        public abstract T deserialize(NBTTagCompound var1, JsonDeserializationContext var2);
    }
}

