/*
 * Decompiled with CFR 0.152.
 */
package com.clownvin.livingenchantment.entity.item;

import com.clownvin.livingenchantment.LivingEnchantment;
import com.clownvin.livingenchantment.config.LivingConfig;
import com.clownvin.livingenchantment.enchantment.EnchantmentLiving;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityLivingXPOrb
extends Entity {
    public int xpColor;
    public int xpOrbAge;
    public int delayBeforeCanPickup;
    public double xpValue;
    private int xpOrbHealth = 5;
    private EntityPlayer closestPlayer;
    private int xpTargetColor;

    public EntityLivingXPOrb(World worldIn, double x, double y, double z, double expValue) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
        this.func_70107_b(x, y, z);
        this.field_70177_z = (float)(Math.random() * 360.0);
        this.field_70159_w = (0.5 - Math.random()) * 0.66;
        this.field_70181_x = Math.random() * 0.33;
        this.field_70179_y = (0.5 - Math.random()) * 0.66;
        this.xpValue = expValue;
        this.xpColor = (int)(Math.random() * 255.0);
        float xpSplit = EntityLivingXPOrb.getXPSplit((float)expValue);
        if (this.xpValue > (double)xpSplit) {
            this.field_70170_p.func_72838_d((Entity)new EntityLivingXPOrb(this.field_70170_p, x, y, z, xpSplit));
            this.xpValue -= (double)xpSplit;
        }
    }

    public EntityLivingXPOrb(World worldIn) {
        super(worldIn);
    }

    public static float getXPSplit(float expValue) {
        if (expValue >= 2477.0f) {
            return 2477.0f;
        }
        if (expValue >= 1237.0f) {
            return 1237.0f;
        }
        if (expValue >= 617.0f) {
            return 617.0f;
        }
        if (expValue >= 307.0f) {
            return 307.0f;
        }
        if (expValue >= 149.0f) {
            return 149.0f;
        }
        if (expValue >= 73.0f) {
            return 73.0f;
        }
        if (expValue >= 37.0f) {
            return 37.0f;
        }
        if (expValue >= 17.0f) {
            return 17.0f;
        }
        if (expValue >= 7.0f) {
            return 7.0f;
        }
        return expValue >= 3.0f ? 3.0f : 1.0f;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_70100_b_(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K || this.delayBeforeCanPickup != 0 || player.field_71090_bL != 0) {
            return;
        }
        if ((player.func_184614_ca().func_77973_b() instanceof ItemBow || player.func_184592_cb().func_77973_b() instanceof ItemBow) && player.func_184605_cv() > 0) {
            return;
        }
        ItemStack stack = EnchantmentHelper.func_92099_a((Enchantment)EnchantmentLiving.LIVING_ENCHANTMENT, (EntityLivingBase)player);
        if (stack.func_190926_b()) {
            return;
        }
        NBTTagCompound tag = LivingEnchantment.getEnchantmentNBTTag(stack);
        player.field_71090_bL = 1;
        player.func_71001_a((Entity)this, 1);
        if (LivingConfig.general.xpShare) {
            LivingEnchantment.addExp(player, this.xpValue);
        } else {
            LivingEnchantment.addExp(player, stack, tag, this.xpValue);
        }
        this.func_70106_y();
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187802_ec, player.func_184176_by(), (float)LivingConfig.general.xpVolume, 0.85f + (float)(Math.random() * (double)0.3f));
    }

    protected void func_70088_a() {
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        float f = 0.5f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        int i = super.func_70070_b();
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public void func_70071_h_() {
        double d3;
        double d2;
        double d1;
        double d4;
        double d5;
        super.func_70071_h_();
        if (this.delayBeforeCanPickup > 0) {
            --this.delayBeforeCanPickup;
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)0.03f;
        }
        if (this.field_70170_p.func_180495_p(new BlockPos((Entity)this)).func_185904_a() == Material.field_151587_i) {
            this.field_70181_x = 0.2f;
            this.field_70159_w = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
            this.field_70179_y = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
            this.func_184185_a(SoundEvents.field_187658_bx, 0.4f, 2.0f + this.field_70146_Z.nextFloat() * 0.4f);
        }
        this.func_145771_j(this.field_70165_t, (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.field_70161_v);
        double d0 = 8.0;
        if (this.xpTargetColor < this.xpColor - 20 + this.func_145782_y() % 100) {
            if (this.closestPlayer == null || this.closestPlayer.func_70068_e((Entity)this) > 64.0) {
                this.closestPlayer = this.field_70170_p.func_72890_a((Entity)this, 8.0);
            }
            this.xpTargetColor = this.xpColor;
        }
        if (this.closestPlayer != null && (this.closestPlayer.func_175149_v() || EnchantmentHelper.func_92099_a((Enchantment)EnchantmentLiving.LIVING_ENCHANTMENT, (EntityLivingBase)this.closestPlayer).func_190926_b())) {
            this.closestPlayer = null;
        }
        if (this.closestPlayer != null && (d5 = 1.0 - (d4 = Math.sqrt((d1 = (this.closestPlayer.field_70165_t - this.field_70165_t) / 8.0) * d1 + (d2 = (this.closestPlayer.field_70163_u + (double)this.closestPlayer.func_70047_e() / 2.0 - this.field_70163_u) / 8.0) * d2 + (d3 = (this.closestPlayer.field_70161_v - this.field_70161_v) / 8.0) * d3))) > 0.0) {
            d5 *= d5;
            this.field_70159_w += d1 / d4 * d5 * 0.1;
            this.field_70181_x += d2 / d4 * d5 * 0.1;
            this.field_70179_y += d3 / d4 * d5 * 0.1;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        float f = 0.98f;
        if (this.field_70122_E) {
            BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
            IBlockState underState = this.field_70170_p.func_180495_p(underPos);
            f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this) * 0.98f;
        }
        this.field_70159_w *= (double)f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)f;
        if (this.field_70122_E) {
            this.field_70181_x *= (double)-0.9f;
        }
        ++this.xpColor;
        ++this.xpOrbAge;
        if (this.xpOrbAge >= 6000) {
            this.func_70106_y();
        }
    }

    public boolean func_70072_I() {
        return this.field_70170_p.func_72918_a(this.func_174813_aQ(), Material.field_151586_h, (Entity)this);
    }

    protected void func_70081_e(int amount) {
        this.func_70097_a(DamageSource.field_76372_a, amount);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return false;
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        this.func_70018_K();
        this.xpOrbHealth = (int)((float)this.xpOrbHealth - amount);
        if (this.xpOrbHealth <= 0) {
            this.func_70106_y();
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74777_a("Health", (short)this.xpOrbHealth);
        compound.func_74777_a("Age", (short)this.xpOrbAge);
        compound.func_74777_a("Value", (short)this.xpValue);
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.xpOrbHealth = compound.func_74765_d("Health");
        this.xpOrbAge = compound.func_74765_d("Age");
        this.xpValue = compound.func_74765_d("Value");
    }

    @SideOnly(value=Side.CLIENT)
    public int getTextureByXP() {
        if (this.xpValue >= 2477.0) {
            return 10;
        }
        if (this.xpValue >= 1237.0) {
            return 9;
        }
        if (this.xpValue >= 617.0) {
            return 8;
        }
        if (this.xpValue >= 307.0) {
            return 7;
        }
        if (this.xpValue >= 149.0) {
            return 6;
        }
        if (this.xpValue >= 73.0) {
            return 5;
        }
        if (this.xpValue >= 37.0) {
            return 4;
        }
        if (this.xpValue >= 17.0) {
            return 3;
        }
        if (this.xpValue >= 7.0) {
            return 2;
        }
        return this.xpValue >= 3.0 ? 1 : 0;
    }

    public boolean func_70075_an() {
        return false;
    }
}

