/*
 * Decompiled with CFR 0.152.
 */
package com.clownvin.livingenchantment.talents;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber
public abstract class Talent
extends IForgeRegistryEntry.Impl<Talent> {
    private static IForgeRegistry<Talent> registry;
    public final String name;

    @SubscribeEvent
    public static void createRegistry(RegistryEvent.NewRegistry event) {
        RegistryBuilder builder = new RegistryBuilder();
        registry = builder.setName(new ResourceLocation("livingenchantment", "TalentRegistry")).setType(Talent.class).create();
    }

    @SubscribeEvent
    public static void registerTalents(RegistryEvent.Register<Talent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Talent[0]);
    }

    @Nullable
    public static Talent getTalent(ResourceLocation location) {
        return (Talent)registry.getValue(location);
    }

    public static ResourceLocation getKey(Talent talent) {
        return registry.getKey((IForgeRegistryEntry)talent);
    }

    public static synchronized IForgeRegistry<Talent> getRegistry() {
        return registry;
    }

    public static Talent getTalent(String talent) {
        return (Talent)registry.getValue(new ResourceLocation(talent.toLowerCase()));
    }

    public Talent(String name) {
        this.setRegistryName("livingenchantment", name.toLowerCase());
        this.name = name;
    }

    public abstract boolean affects(ItemStack var1);

    protected abstract void perform(Event var1, ItemStack var2, EntityLivingBase var3);

    public String toString() {
        return this.getRegistryName().toString();
    }
}

