/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lostaether.entities;

import com.gildedgames.the_aether.Aether;
import com.gildedgames.the_aether.api.AetherAPI;
import com.gildedgames.the_aether.api.player.util.IAetherBoss;
import com.gildedgames.the_aether.entities.hostile.EntityWhirlwind;
import com.gildedgames.the_aether.items.ItemsAether;
import com.gildedgames.the_aether.registry.sounds.SoundsAether;
import com.legacy.lostaether.LostLootTables;
import com.legacy.lostaether.blocks.BlocksLostAether;
import com.legacy.lostaether.client.sounds.LostSounds;
import com.legacy.lostaether.entities.EntityFallingRock;
import com.legacy.lostaether.entities.util.LostNameGen;
import com.legacy.lostaether.items.tools.ItemAetherShield;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAerwhaleKing
extends EntityFlying
implements IAetherBoss {
    public static final DataParameter<String> WHALE_NAME = EntityDataManager.func_187226_a(EntityAerwhaleKing.class, (DataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<Boolean> WHALE_CHARGING = EntityDataManager.func_187226_a(EntityAerwhaleKing.class, (DataSerializer)DataSerializers.field_187198_h);
    private int dungeonX;
    private int dungeonY;
    private int dungeonZ;
    private int targetX;
    private int targetY;
    private int targetZ;
    public int chatTime;
    public int attackDelay;
    public int stunTime;
    public int randomAttackChance;
    public float velocity;
    public boolean isTargetted;
    public boolean courseFlipped;

    public EntityAerwhaleKing(World world) {
        super(world);
        this.field_70765_h = new AIMoveControl(this);
        this.func_70105_a(4.0f, 4.0f);
        this.field_70178_ae = true;
        this.field_70728_aV = 30;
        this.field_70158_ak = true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(500.0);
        this.func_70606_j(500.0f);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIDoNothing());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70165_t = Math.floor(this.field_70165_t + 0.5);
        this.field_70163_u = Math.floor(this.field_70163_u + 0.5);
        this.field_70161_v = Math.floor(this.field_70161_v + 0.5);
        this.field_70180_af.func_187214_a(WHALE_CHARGING, (Object)false);
        this.field_70180_af.func_187214_a(WHALE_NAME, (Object)String.valueOf(LostNameGen.whaleGen()));
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        if (this.getStunned()) {
            super.func_70091_d(type, 0.0, 0.0, 0.0);
        } else {
            super.func_70091_d(type, x, y, z);
        }
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74768_a("dungeonX", this.dungeonX);
        nbttagcompound.func_74768_a("dungeonY", this.dungeonY);
        nbttagcompound.func_74768_a("dungeonZ", this.dungeonZ);
        nbttagcompound.func_74778_a("bossName", this.getBossName());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.dungeonX = nbttagcompound.func_74762_e("dungeonX");
        this.dungeonY = nbttagcompound.func_74762_e("dungeonY");
        this.dungeonZ = nbttagcompound.func_74762_e("dungeonZ");
        this.setBossName(nbttagcompound.func_74779_i("bossName"));
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return entityIn.func_174813_aQ();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_175446_cd()) {
            return;
        }
        AxisAlignedBB radiusCheck = this.field_70170_p.field_72995_K ? this.func_174813_aQ().func_72314_b(20.0, 12.0, 20.0) : new AxisAlignedBB(new BlockPos((double)this.dungeonX, this.field_70163_u, (double)this.dungeonZ)).func_72314_b(15.0, 12.0, 15.0);
        List playerList = this.field_70170_p.func_72872_a(EntityPlayer.class, radiusCheck);
        for (EntityPlayer nearbyPlayers : this.getPlayerList()) {
            AetherAPI.getInstance().get(nearbyPlayers).setFocusedBoss((IAetherBoss)this);
        }
        if (this.func_70638_az() != null) {
            EntityPlayer randomPlayer;
            if (!this.field_70170_p.field_72995_K) {
                this.chargeTarget();
            }
            if (!this.field_70170_p.field_72995_K && playerList.isEmpty() && (this.func_70638_az() != null && this.func_70638_az().func_70011_f((double)this.dungeonX, (double)this.dungeonY, (double)this.dungeonZ) >= 20.0 || this.func_70638_az().func_110143_aJ() <= 0.0f || this.func_70638_az().field_70128_L)) {
                this.reset();
                this.unlockDoor();
                this.field_70170_p.func_175656_a(new BlockPos(this.dungeonX, this.dungeonY, this.dungeonZ - 8), BlocksLostAether.songstone.func_176223_P());
            }
            if (!this.getStunned()) {
                ++this.attackDelay;
            }
            if (!playerList.isEmpty() && (this.func_70638_az().field_70128_L || this.func_70638_az().func_110143_aJ() <= 0.0f) && (randomPlayer = (EntityPlayer)playerList.get(this.field_70146_Z.nextInt(playerList.size()))) != null) {
                this.func_70624_b((EntityLivingBase)randomPlayer);
            }
        } else if (!this.func_70605_aq().func_75640_a()) {
            this.reset();
        }
        if (this.getStunned()) {
            if (this.stunTime == 60) {
                this.func_70656_aK();
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0f, false);
                if (!this.field_70170_p.field_72995_K) {
                    for (int w = 0; w < 4; ++w) {
                        BlockPos blockpos = new BlockPos(this.dungeonX + -6 + this.field_70146_Z.nextInt(12), this.dungeonY, this.dungeonZ + -6 + this.field_70146_Z.nextInt(12));
                        EntityWhirlwind whirly = new EntityWhirlwind(this.field_70170_p);
                        whirly.func_174828_a(blockpos, 0.0f, 0.0f);
                        whirly.actionTimer = -2147483647;
                        whirly.capturedDrops.clear();
                        whirly.func_180482_a(this.field_70170_p.func_175649_E(blockpos), (IEntityLivingData)null);
                        this.field_70170_p.func_72838_d((Entity)whirly);
                    }
                    for (EntityPlayer players : this.getPlayerList()) {
                        for (int w = 0; w < 6; ++w) {
                            BlockPos blockpos = new BlockPos(players.field_70165_t + -7.0 + (double)this.field_70146_Z.nextInt(14), players.field_70163_u + 10.0 + (double)this.field_70146_Z.nextInt(5), players.field_70161_v + -7.0 + (double)this.field_70146_Z.nextInt(14));
                            EntityFallingRock projectile = new EntityFallingRock(this.field_70170_p, (EntityLivingBase)this);
                            projectile.func_174828_a(blockpos, 0.0f, 0.0f);
                            this.field_70170_p.func_72838_d((Entity)projectile);
                        }
                        BlockPos blockpos = new BlockPos(players.field_70165_t, players.field_70163_u + 10.0 + (double)this.field_70146_Z.nextInt(5), players.field_70161_v);
                        EntityFallingRock projectile = new EntityFallingRock(this.field_70170_p, (EntityLivingBase)this);
                        projectile.func_174828_a(blockpos, 0.0f, 0.0f);
                        this.field_70170_p.func_72838_d((Entity)projectile);
                    }
                }
            }
            for (int i = 0; i < 2; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
            }
            this.attackDelay = 0;
            --this.stunTime;
        }
        this.field_70145_X = this.field_70163_u > (double)(this.dungeonY + 2);
        List whirlysWithinBox = this.field_70170_p.func_72872_a(EntityWhirlwind.class, this.func_174813_aQ().func_72314_b(2.5, 2.5, 2.5));
        for (int l = 0; l < whirlysWithinBox.size(); ++l) {
            EntityWhirlwind whirlys = (EntityWhirlwind)whirlysWithinBox.get(l);
            whirlys.func_70106_y();
        }
        if (this.field_70128_L) {
            this.unlockDoor();
        }
        if (!this.field_70170_p.field_72995_K) {
            this.doCourse();
        }
    }

    public void chargeTarget() {
        EntityLivingBase entitylivingbase = this.func_70638_az();
        BlockPos destPos = new BlockPos(this.targetX, this.targetY, this.targetZ);
        boolean hitTarget = this.func_174813_aQ().func_72326_a(entitylivingbase.func_174813_aQ());
        if (!this.field_70170_p.field_72995_K && this.attackDelay <= 3) {
            this.randomAttackChance = this.field_70146_Z.nextInt(150);
        } else if (this.attackDelay == 45 + this.randomAttackChance) {
            this.isTargetted = true;
            this.setTargetLockPos(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v);
        } else if (this.attackDelay >= 50 + this.randomAttackChance && !this.isCharging() && !this.getStunned()) {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70765_h.func_75642_a((double)destPos.func_177958_n(), (double)destPos.func_177956_o(), (double)destPos.func_177952_p(), 10.0);
            }
            this.setCharging(true);
        }
        if (hitTarget && !this.getStunned() && this.func_70652_k((Entity)entitylivingbase)) {
            this.setCharging(false);
            this.isTargetted = false;
            this.setStunned(false);
            this.setTargetLockPos(0.0, 0.0, 0.0);
            return;
        }
        if (!this.getStunned() && this.func_174818_b(destPos) <= 5.0) {
            this.stop();
            this.setStunned(true);
            this.setCharging(false);
            this.isTargetted = false;
            this.setTargetLockPos(0.0, 0.0, 0.0);
            this.field_70170_p.func_72960_a((Entity)this, (byte)4);
            return;
        }
        if (this.stunTime == 1) {
            this.func_70605_aq().func_75642_a((double)(this.dungeonX - 16), (double)(this.dungeonY + 12), (double)this.dungeonZ, 2.0);
        } else if (this.attackDelay > 250) {
            this.attackDelay = 0;
            this.isTargetted = false;
            this.setCharging(false);
            this.func_70605_aq().func_75642_a((double)(this.dungeonX - 16), (double)(this.dungeonY + 12), (double)this.dungeonZ, 2.0);
        } else {
            return;
        }
    }

    public void func_70108_f(Entity entity) {
        if (this.func_70638_az() != null && this.isCharging() && entity != this.func_70638_az()) {
            this.func_70652_k(entity);
        }
    }

    public void stop() {
        this.field_70159_w *= 0.5;
        this.field_70181_x *= 0.5;
        this.field_70179_y *= 0.5;
    }

    private void sendMessage(EntityPlayer player, ITextComponent s) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side.isClient()) {
            Aether.proxy.sendMessage(player, s);
        }
    }

    public boolean func_70097_a(DamageSource ds, float var2) {
        if ((ds instanceof EntityDamageSourceIndirect || ds.func_76352_a()) && ds.func_76346_g() instanceof EntityPlayer) {
            this.sendMessage((EntityPlayer)ds.func_76346_g(), (ITextComponent)new TextComponentTranslation("gui.lost_aether.projectile_miss", new Object[0]));
            this.func_70656_aK();
            return false;
        }
        if (ds.func_76364_f() == null || !(ds.func_76364_f() instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)ds.func_76364_f();
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (stack.func_77973_b() == ItemsAether.developer_stick && player.func_184812_l_()) {
            this.reset();
            return false;
        }
        if (!this.getStunned()) {
            return false;
        }
        AetherAPI.getInstance().get(player).setFocusedBoss((IAetherBoss)this);
        this.func_70624_b((EntityLivingBase)player);
        return super.func_70097_a(ds, Math.max(0.0f, Math.min(var2, 20.0f)));
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (this.attackDelay > 10 && entityIn instanceof EntityLivingBase && !entityIn.func_190530_aW()) {
            if (entityIn instanceof EntityPlayer) {
                ItemStack playerItem;
                EntityPlayer playerentity = (EntityPlayer)entityIn;
                ItemStack itemStack = playerItem = playerentity.func_184587_cr() ? playerentity.func_184607_cu() : ItemStack.field_190927_a;
                if (!playerItem.func_190926_b() && (playerItem.func_77973_b() instanceof ItemShield || playerItem.func_77973_b() instanceof ItemAetherShield)) {
                    playerentity.func_190777_m(true);
                    playerentity.func_184811_cZ().func_185145_a(playerItem.func_77973_b(), 600);
                    this.field_70170_p.func_72960_a((Entity)playerentity, (byte)30);
                    this.stop();
                    this.setStunned(true);
                    this.setCharging(false);
                    this.isTargetted = false;
                    this.setTargetLockPos(0.0, 0.0, 0.0);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                    return false;
                }
                entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this).func_76351_m(), 15.0f);
                EntityLivingBase collidedEntity = (EntityLivingBase)entityIn;
                collidedEntity.func_70024_g(collidedEntity.field_70181_x * 2.0, 0.35, collidedEntity.field_70179_y * 2.0);
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsAether.zephyr_shoot, SoundCategory.HOSTILE, 2.5f, 1.0f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                return true;
            }
            entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this).func_76351_m(), 15.0f);
            EntityLivingBase collidedEntity = (EntityLivingBase)entityIn;
            collidedEntity.func_70024_g(collidedEntity.field_70181_x * 2.0, 0.35, collidedEntity.field_70179_y * 2.0);
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsAether.zephyr_shoot, SoundCategory.HOSTILE, 2.5f, 1.0f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            return true;
        }
        return flag;
    }

    protected void func_85033_bc() {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a((double)0.2f, 0.0, (double)0.2f));
        if (list != null && !list.isEmpty() && this.isCharging()) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                this.func_70108_f(entity);
            }
        }
        super.func_85033_bc();
    }

    private void doCourse() {
        double flySpeed = this.func_70638_az() != null ? 1.0 : (double)0.7f;
        double distanceToFirstTarget = this.func_174818_b(new BlockPos(this.dungeonX - 14, this.dungeonY + 12, this.dungeonZ));
        double distanceToSecondTarget = this.func_174818_b(new BlockPos(this.dungeonX, this.dungeonY + 12, this.dungeonZ - 14));
        double distanceToThirdTarget = this.func_174818_b(new BlockPos(this.dungeonX + 14, this.dungeonY + 12, this.dungeonZ));
        double distanceToFourthTarget = this.func_174818_b(new BlockPos(this.dungeonX, this.dungeonY + 12, this.dungeonZ + 14));
        if (!this.getStunned() && !this.isCharging()) {
            if (!this.courseFlipped) {
                if (distanceToFirstTarget <= 10.0) {
                    this.func_70605_aq().func_75642_a((double)this.dungeonX, (double)(this.dungeonY + 12), (double)(this.dungeonZ - 16), flySpeed);
                } else if (distanceToSecondTarget <= 10.0) {
                    this.func_70605_aq().func_75642_a((double)(this.dungeonX + 16), (double)(this.dungeonY + 12), (double)this.dungeonZ, flySpeed);
                } else if (distanceToThirdTarget <= 10.0) {
                    this.func_70605_aq().func_75642_a((double)this.dungeonX, (double)(this.dungeonY + 12), (double)(this.dungeonZ + 16), flySpeed);
                } else if (distanceToFourthTarget <= 10.0) {
                    this.func_70605_aq().func_75642_a((double)(this.dungeonX - 16), (double)(this.dungeonY + 12), (double)this.dungeonZ, flySpeed);
                }
            } else if (distanceToFirstTarget <= 10.0) {
                this.func_70605_aq().func_75642_a((double)this.dungeonX, (double)(this.dungeonY + 12), (double)(this.dungeonZ + 16), flySpeed);
            } else if (distanceToSecondTarget <= 10.0) {
                this.func_70605_aq().func_75642_a((double)(this.dungeonX - 16), (double)(this.dungeonY + 12), (double)this.dungeonZ, flySpeed);
            } else if (distanceToThirdTarget <= 10.0) {
                this.func_70605_aq().func_75642_a((double)this.dungeonX, (double)(this.dungeonY + 12), (double)(this.dungeonZ - 16), flySpeed);
            } else if (distanceToFourthTarget <= 10.0) {
                this.func_70605_aq().func_75642_a((double)(this.dungeonX + 16), (double)(this.dungeonY + 12), (double)this.dungeonZ, flySpeed);
            }
        }
    }

    public boolean func_70692_ba() {
        return false;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70653_a(Entity par1Entity, float par2, double par3, double par5) {
    }

    public void func_70024_g(double d, double d1, double d2) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
    }

    public void reset() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.stop();
        this.func_70624_b(null);
        this.func_70606_j(this.func_110138_aP());
        this.isTargetted = false;
        this.setCharging(false);
        this.setStunned(false);
        this.func_70634_a(this.dungeonX - 16, this.dungeonY + 12, this.dungeonZ);
    }

    public void setDungeon(double posX, double posY, double posZ) {
        this.dungeonX = (int)posX;
        this.dungeonY = (int)posY;
        this.dungeonZ = (int)posZ;
    }

    public void setTargetLockPos(double posX, double posY, double posZ) {
        this.targetX = (int)posX;
        this.targetY = (int)posY;
        this.targetZ = (int)posZ;
    }

    public void setBossName(String name) {
        this.field_70180_af.func_187227_b(WHALE_NAME, (Object)name);
    }

    public String getBossName() {
        return (String)this.field_70180_af.func_187225_a(WHALE_NAME);
    }

    public boolean isCharging() {
        return (Boolean)this.field_70180_af.func_187225_a(WHALE_CHARGING);
    }

    public void setCharging(boolean charging) {
        this.field_70180_af.func_187227_b(WHALE_CHARGING, (Object)charging);
    }

    public boolean getStunned() {
        return this.stunTime > 0;
    }

    public void setStunned(boolean stunned) {
        if (!stunned) {
            this.stunTime = 0;
            this.attackDelay = 0;
            this.func_70605_aq().func_75642_a((double)(this.dungeonX - 16), (double)(this.dungeonY + 12), (double)this.dungeonZ, 2.0);
        } else {
            EntityPlayer randomPlayer;
            if (!this.getPlayerList().isEmpty() && (randomPlayer = this.getPlayerList().get(this.field_70146_Z.nextInt(this.getPlayerList().size()))) != null) {
                this.func_70624_b((EntityLivingBase)randomPlayer);
            }
            this.stunTime = 60;
            this.courseFlipped = this.field_70146_Z.nextBoolean();
        }
    }

    public List<EntityPlayer> getPlayerList() {
        AxisAlignedBB radiusCheck = this.field_70170_p.field_72995_K ? this.func_174813_aQ().func_72314_b(20.0, 12.0, 20.0) : new AxisAlignedBB(new BlockPos((double)this.dungeonX, this.field_70163_u, (double)this.dungeonZ)).func_72314_b(15.0, 12.0, 15.0);
        List playerList = this.field_70170_p.func_72872_a(EntityPlayer.class, radiusCheck);
        return playerList;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.setStunned(true);
        } else {
            super.func_70103_a(id);
        }
    }

    public String getBossTitle() {
        return this.getBossName() + ", " + new TextComponentTranslation("title.lost_aether.king_aerwhale.name", new Object[0]).func_150254_d();
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    public float getBossHealth() {
        return this.func_110143_aJ();
    }

    public float getMaxBossHealth() {
        return this.func_110138_aP();
    }

    public SoundEvent func_184639_G() {
        return LostSounds.ENTITY_AERWHALE_KING_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsAether.aerwhale_death;
    }

    protected SoundEvent func_184615_bR() {
        return SoundsAether.aerwhale_death;
    }

    protected float func_70599_aP() {
        return 3.0f;
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.8f;
    }

    public float func_70047_e() {
        return 1.53f;
    }

    protected ResourceLocation func_184647_J() {
        return LostLootTables.king_aerwhale;
    }

    public static void setDoor(EntityAerwhaleKing aerwhale) {
        for (int x = aerwhale.dungeonX - 1; x < aerwhale.dungeonX + 2; ++x) {
            for (int y = aerwhale.dungeonY - 1; y < aerwhale.dungeonY; ++y) {
                for (int z = aerwhale.dungeonZ + 1; z < aerwhale.dungeonZ + 6; ++z) {
                    BlockPos newPos = new BlockPos(x, y, z);
                    aerwhale.field_70170_p.func_175656_a(newPos, BlocksLostAether.locked_gale_stone.func_176223_P());
                }
            }
        }
    }

    private void unlockDoor() {
        BlockPos newPos;
        int z;
        int y;
        int x;
        for (x = this.dungeonX - 1; x < this.dungeonX + 2; ++x) {
            for (y = this.dungeonY - 1; y < this.dungeonY; ++y) {
                for (z = this.dungeonZ + 1; z < this.dungeonZ + 5; ++z) {
                    newPos = new BlockPos(x, y, z);
                    this.field_70170_p.func_175698_g(newPos);
                }
            }
        }
        for (x = this.dungeonX - 1; x < this.dungeonX + 2; ++x) {
            for (y = this.dungeonY - 1; y < this.dungeonY; ++y) {
                for (z = this.dungeonZ + 5; z < this.dungeonZ + 6; ++z) {
                    newPos = new BlockPos(x, y, z);
                    this.field_70170_p.func_175656_a(newPos, BlocksLostAether.gale_stairs.func_176223_P().func_185907_a(Rotation.CLOCKWISE_180));
                }
            }
        }
        if (this.field_70128_L || this.func_110143_aJ() <= 0.0f) {
            for (x = this.dungeonX - 15; x < this.dungeonX + 30; ++x) {
                for (y = this.dungeonY - 32; y < this.dungeonY + 32; ++y) {
                    for (z = this.dungeonZ - 15; z < this.dungeonZ + 30; ++z) {
                        newPos = new BlockPos(x, y, z);
                        IBlockState unlock_block = this.field_70170_p.func_180495_p(newPos);
                        if (unlock_block == BlocksLostAether.locked_gale_stone.func_176223_P()) {
                            this.field_70170_p.func_175656_a(newPos, BlocksLostAether.gale_stone.func_176223_P());
                            continue;
                        }
                        if (unlock_block != BlocksLostAether.locked_light_gale_stone.func_176223_P()) continue;
                        this.field_70170_p.func_175656_a(newPos, BlocksLostAether.light_gale_stone.func_176223_P());
                    }
                }
            }
        }
    }

    class AIDoNothing
    extends EntityAIBase {
        public AIDoNothing() {
            this.func_75248_a(7);
        }

        public boolean func_75250_a() {
            return EntityAerwhaleKing.this.getStunned();
        }
    }

    class AIMoveControl
    extends EntityMoveHelper {
        public AIMoveControl(EntityAerwhaleKing whaleBoss) {
            super((EntityLiving)whaleBoss);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - EntityAerwhaleKing.this.field_70165_t;
                double d1 = this.field_75647_c - EntityAerwhaleKing.this.field_70163_u;
                double d2 = this.field_75644_d - EntityAerwhaleKing.this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < EntityAerwhaleKing.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    EntityAerwhaleKing.this.field_70159_w *= 0.5;
                    EntityAerwhaleKing.this.field_70181_x *= 0.5;
                    EntityAerwhaleKing.this.field_70179_y *= 0.5;
                } else {
                    EntityAerwhaleKing.this.field_70159_w += d0 / d3 * 0.05 * this.field_75645_e;
                    EntityAerwhaleKing.this.field_70181_x += d1 / d3 * 0.05 * this.field_75645_e;
                    EntityAerwhaleKing.this.field_70179_y += d2 / d3 * 0.05 * this.field_75645_e;
                    if (!EntityAerwhaleKing.this.isCharging()) {
                        EntityAerwhaleKing.this.field_70761_aq = EntityAerwhaleKing.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityAerwhaleKing.this.field_70159_w, (double)EntityAerwhaleKing.this.field_70179_y)) * 57.295776f;
                    }
                }
            }
            if (!EntityAerwhaleKing.this.getStunned() && EntityAerwhaleKing.this.isCharging()) {
                EntityAerwhaleKing.this.func_70671_ap().func_75650_a((double)EntityAerwhaleKing.this.targetX, (double)EntityAerwhaleKing.this.targetY, (double)EntityAerwhaleKing.this.targetZ, (float)(EntityAerwhaleKing.this.func_184649_cE() * 4), (float)(EntityAerwhaleKing.this.func_70646_bf() * 4));
            }
        }
    }
}

