/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lostaether.events;

import com.gildedgames.the_aether.Aether;
import com.gildedgames.the_aether.api.AetherAPI;
import com.gildedgames.the_aether.api.player.IPlayerAether;
import com.gildedgames.the_aether.blocks.dungeon.BlockTreasureChest;
import com.gildedgames.the_aether.entities.projectile.darts.EntityDartBase;
import com.gildedgames.the_aether.tile_entities.TileEntityTreasureChest;
import com.legacy.lostaether.items.ItemsLostAether;
import com.legacy.lostaether.items.tools.ItemAetherShield;
import com.legacy.lostaether.world.dungeon.PlatinumDungeonGenerator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PlayerLostAetherEvents {
    private boolean stepUpdate;

    @SubscribeEvent
    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            IPlayerAether playerAether = AetherAPI.getInstance().get((EntityPlayer)event.getEntityLiving());
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (playerAether != null) {
                if (((ItemStack)player.field_71071_by.field_70460_b.get(0)).func_77973_b() == ItemsLostAether.agility_boots) {
                    this.stepUpdate = true;
                    playerAether.getEntity().field_70138_W = 1.0f;
                } else if (this.stepUpdate) {
                    playerAether.getEntity().field_70138_W = 0.5f;
                    this.stepUpdate = false;
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            IPlayerAether playerAether = AetherAPI.getInstance().get((EntityPlayer)event.getEntityLiving());
            EntityLivingBase living = event.getEntityLiving();
            DamageSource source = event.getSource();
            if (playerAether != null) {
                boolean isShielding;
                boolean bl = isShielding = living.func_184607_cu().func_77973_b() instanceof ItemAetherShield && this.canBlockDamageSource((EntityPlayer)event.getEntityLiving(), source);
                if (playerAether.getAccessoryInventory().wearingAccessory(new ItemStack(ItemsLostAether.sentry_shield))) {
                    if (source.func_94541_c()) {
                        playerAether.getAccessoryInventory().damageWornStack(1, new ItemStack(ItemsLostAether.sentry_shield));
                        event.setCanceled(true);
                    } else if (living.field_70170_p.field_73012_v.nextBoolean() && !isShielding) {
                        playerAether.getAccessoryInventory().damageWornStack(1, new ItemStack(ItemsLostAether.sentry_shield));
                        living.field_70170_p.func_72876_a((Entity)living, living.field_70165_t, living.field_70163_u, living.field_70161_v, 1.0f, false);
                    }
                }
                if (playerAether.getAccessoryInventory().wearingAccessory(new ItemStack(ItemsLostAether.phoenix_cape)) && source.func_76364_f() instanceof EntityLivingBase && !isShielding) {
                    source.func_76364_f().func_70015_d(3);
                    playerAether.getAccessoryInventory().damageWornStack(1, new ItemStack(ItemsLostAether.phoenix_cape));
                }
                if (playerAether.getAccessoryInventory().wearingAccessory(new ItemStack(ItemsLostAether.invisibility_gem)) && !living.func_70644_a(MobEffects.field_76441_p) && !isShielding && living.field_70170_p.field_73012_v.nextFloat() < 0.05f && !living.field_70170_p.field_72995_K) {
                    living.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 160, 0, true, true));
                    Aether.proxy.spawnSmoke(living.field_70170_p, living.func_180425_c());
                }
            }
            if (living.func_184607_cu().func_77973_b() instanceof ItemAetherShield && event.getAmount() > 0.0f && this.canBlockDamageSource((EntityPlayer)event.getEntityLiving(), source)) {
                source.func_76364_f().func_184185_a(SoundEvents.field_187928_hb, 0.4f, 0.8f + living.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                this.damageShield((EntityPlayer)event.getEntityLiving(), event.getAmount());
                if (living.func_184607_cu().func_77973_b() == ItemsLostAether.gravitite_shield && source.func_76364_f() instanceof EntityLivingBase) {
                    ((EntityLivingBase)source.func_76364_f()).func_70653_a((Entity)living, 1.5f, living.field_70165_t - source.func_76364_f().field_70165_t, living.field_70161_v - source.func_76364_f().field_70161_v);
                    source.func_76364_f().func_70107_b(source.func_76364_f().field_70165_t, source.func_76364_f().field_70163_u + 1.0, source.func_76364_f().field_70161_v);
                    source.func_76364_f().field_70160_al = true;
                }
                if (living.func_184607_cu().func_77973_b() == ItemsLostAether.jeb_shield) {
                    Entity projectile = source.func_76364_f();
                    if (source.func_76364_f() instanceof IProjectile) {
                        Vec3d vec3d = living.func_70676_i(1.0f);
                        double x = -(living.field_70165_t - (living.field_70165_t + vec3d.field_72450_a * 16.0));
                        double y = vec3d.field_72448_b * 8.0;
                        double z = -(living.field_70161_v - (living.field_70161_v + vec3d.field_72449_c * 16.0));
                        ((IProjectile)source.func_76364_f()).func_70186_c(x, y, z, -15.0f, 0.0f);
                        if (projectile instanceof EntityArrow) {
                            ((EntityArrow)projectile).field_70250_c = living;
                        } else if (projectile instanceof EntityDartBase) {
                            ((EntityDartBase)projectile).field_70250_c = living;
                        }
                    }
                }
            }
        } else if (event.getSource().func_76364_f() instanceof EntityPlayer) {
            DamageSource source = event.getSource();
            IPlayerAether playerAether = AetherAPI.getInstance().get((EntityPlayer)source.func_76364_f());
            EntityPlayer player = (EntityPlayer)source.func_76364_f();
            if (playerAether != null && playerAether.getAccessoryInventory().wearingAccessory(new ItemStack(ItemsLostAether.power_gloves)) && player.func_184614_ca().func_190926_b() && event.getEntityLiving().field_70737_aN <= 0) {
                player.func_184185_a(SoundEvents.field_187721_dT, 1.0f, 1.0f);
                player.func_184185_a(SoundEvents.field_187631_bo, 0.4f, 1.0f);
                event.getEntityLiving().func_70653_a(source.func_76364_f(), 1.5f, source.func_76364_f().field_70165_t - event.getEntityLiving().field_70165_t, source.func_76364_f().field_70161_v - event.getEntityLiving().field_70161_v);
                playerAether.getAccessoryInventory().damageWornStack(1, new ItemStack(ItemsLostAether.power_gloves));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        EntityPlayer player = event.getEntityPlayer();
        if (state.func_177230_c() instanceof BlockTreasureChest && player.func_184614_ca().func_77973_b() == ItemsLostAether.platinum_key) {
            TileEntityTreasureChest treasurechest = (TileEntityTreasureChest)world.func_175625_s(pos);
            ItemStack guiID = player.func_184614_ca();
            if (treasurechest.func_174893_q_()) {
                treasurechest.unlock(3);
                for (int p = 0; p < 5 + world.field_73012_v.nextInt(1); ++p) {
                    treasurechest.func_70299_a(world.field_73012_v.nextInt(treasurechest.func_70302_i_()), PlatinumDungeonGenerator.getPlatinumLoot(world.field_73012_v));
                }
                guiID.func_190918_g(1);
            }
        }
    }

    protected void damageShield(EntityPlayer player, float damage) {
        if (damage >= 3.0f && player.func_184607_cu().func_77973_b() instanceof ItemAetherShield) {
            ItemStack copyBeforeUse = player.func_184607_cu().func_77946_l();
            int i = 1 + MathHelper.func_76141_d((float)damage);
            player.func_184607_cu().func_77972_a(i, (EntityLivingBase)player);
            if (player.func_184607_cu().func_190926_b()) {
                EnumHand enumhand = player.func_184600_cs();
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)copyBeforeUse, (EnumHand)enumhand);
                if (enumhand == EnumHand.MAIN_HAND) {
                    player.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                } else {
                    player.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                }
                player.func_184602_cy();
                player.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + player.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }

    private boolean canBlockDamageSource(EntityPlayer player, DamageSource damageSourceIn) {
        Vec3d vec3d;
        if (!damageSourceIn.func_76363_c() && player.func_184585_cz() && (vec3d = damageSourceIn.func_188404_v()) != null) {
            Vec3d vec3d1 = player.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v)).func_72432_b();
            vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
            if (vec3d2.func_72430_b(vec3d1) < 0.0) {
                return true;
            }
        }
        return false;
    }

    public void knockBack(Entity knocked, Entity attacker, float strength, double xRatio, double zRatio) {
        float f = MathHelper.func_76133_a((double)(xRatio * xRatio + zRatio * zRatio));
        knocked.field_70159_w /= 2.0;
        knocked.field_70179_y /= 2.0;
        knocked.field_70159_w -= xRatio / (double)f * (double)strength;
        knocked.field_70179_y -= zRatio / (double)f * (double)strength;
        if (knocked.field_70122_E && ((EntityLivingBase)attacker).func_184607_cu().func_77973_b() != ItemsLostAether.gravitite_shield) {
            knocked.field_70181_x /= 2.0;
            knocked.field_70181_x += (double)strength;
            if (knocked.field_70181_x > (double)0.4f) {
                knocked.field_70181_x = 0.4f;
            }
        } else {
            knocked.field_70181_x = 1.0;
        }
    }
}

