/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lostaether.world.dungeon;

import com.gildedgames.the_aether.api.moa.AetherMoaType;
import com.gildedgames.the_aether.blocks.BlocksAether;
import com.gildedgames.the_aether.items.ItemMoaEgg;
import com.gildedgames.the_aether.items.ItemsAether;
import com.legacy.lostaether.blocks.BlocksLostAether;
import com.legacy.lostaether.entities.EntityAerwhaleKing;
import com.legacy.lostaether.items.ItemsLostAether;
import com.legacy.lostaether.registry.LostMoaTypes;
import com.legacy.lostaether.world.dungeon.PlatinumDungeonPieces;
import com.legacy.lostaether.world.dungeon.util.StructurePlacer;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;

public class PlatinumDungeonGenerator
extends StructurePlacer {
    public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
        PlatinumDungeonPieces dungeon = new PlatinumDungeonPieces(worldIn, rand);
        if ((pos = pos.func_177982_a(dungeon.ground_4.func_186259_a().func_177958_n() / -2 * 2, 0, dungeon.ground_4.func_186259_a().func_177952_p() / -2 * 2)).func_177956_o() >= 110 && pos.func_177956_o() <= 120 && worldIn.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a) {
            this.placeStructure(worldIn, dungeon.ground_1, pos, Rotation.NONE);
            this.placeStructure(worldIn, dungeon.ground_2, pos.func_177982_a(0, 0, -32), Rotation.NONE);
            this.placeStructure(worldIn, dungeon.ground_3, pos.func_177982_a(-32, 0, 0), Rotation.NONE);
            this.placeStructure(worldIn, dungeon.ground_4, pos.func_177982_a(-32, 0, -32), Rotation.NONE);
            if (Loader.isModLoaded((String)"aether_legacy_addon")) {
                this.placeStructure(worldIn, dungeon.skyroot_tower_1, pos.func_177982_a(0, 19, 0), Rotation.NONE);
                this.placeStructure(worldIn, dungeon.skyroot_tower_2, pos.func_177982_a(0, 19, -32), Rotation.NONE);
                this.placeStructure(worldIn, dungeon.skyroot_tower_3, pos.func_177982_a(-32, 19, 0), Rotation.NONE);
                this.placeStructure(worldIn, dungeon.skyroot_tower_4, pos.func_177982_a(-32, 19, -32), Rotation.NONE);
            } else {
                this.placeStructure(worldIn, dungeon.tower_1, pos.func_177982_a(0, 19, 0), Rotation.NONE);
                this.placeStructure(worldIn, dungeon.tower_2, pos.func_177982_a(0, 19, -32), Rotation.NONE);
                this.placeStructure(worldIn, dungeon.tower_3, pos.func_177982_a(-32, 19, 0), Rotation.NONE);
                this.placeStructure(worldIn, dungeon.tower_4, pos.func_177982_a(-32, 19, -32), Rotation.NONE);
            }
            return true;
        }
        return false;
    }

    @Override
    public void handleDataMarker(String function, BlockPos pos, World worldIn, Random rand) {
        if (function.contains("boss")) {
            EntityAerwhaleKing entity = new EntityAerwhaleKing(worldIn);
            entity.func_70107_b((double)pos.func_177958_n() - 16.0, (double)pos.func_177956_o() + 12.0, pos.func_177952_p());
            entity.setDungeon(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            entity.func_70034_d(180.0f);
            worldIn.func_72838_d((Entity)entity);
            worldIn.func_175698_g(pos);
        } else if (function.contains("platinum_chest")) {
            worldIn.func_175698_g(pos);
        } else if (function.contains("loot_chest")) {
            BlockPos blockpos = pos.func_177977_b();
            TileEntity tileentity = worldIn.func_175625_s(blockpos);
            if (tileentity instanceof TileEntityChest) {
                if (rand.nextInt(2) == 0) {
                    for (int u = 0; u < 3 + rand.nextInt(3); ++u) {
                        ((TileEntityChest)tileentity).func_70299_a(rand.nextInt(((TileEntityChest)tileentity).func_70302_i_()), this.getNormalLoot(rand));
                    }
                } else if (blockpos.func_177956_o() > 145) {
                    if (worldIn.func_180495_p(blockpos.func_177977_b()) == BlocksLostAether.locked_light_gale_stone.func_176223_P()) {
                        worldIn.func_175656_a(blockpos, BlocksAether.chest_mimic.func_176223_P().func_185907_a(Rotation.CLOCKWISE_90));
                    } else {
                        worldIn.func_175656_a(blockpos, BlocksAether.chest_mimic.func_176223_P().func_185907_a(Rotation.COUNTERCLOCKWISE_90));
                    }
                } else {
                    worldIn.func_175656_a(blockpos, BlocksAether.chest_mimic.func_176223_P());
                }
            }
            worldIn.func_175698_g(pos);
        }
    }

    private ItemStack getNormalLoot(Random random) {
        int item = random.nextInt(10);
        switch (item) {
            case 0: {
                return new ItemStack(ItemsAether.zanite_pickaxe);
            }
            case 1: {
                return new ItemStack(ItemsAether.skyroot_bucket, 1, 3);
            }
            case 2: {
                return new ItemStack(ItemsAether.dart_shooter, 1, 2);
            }
            case 3: {
                return ItemMoaEgg.getStackFromType((AetherMoaType)LostMoaTypes.brown);
            }
            case 4: {
                return new ItemStack(ItemsAether.white_cape);
            }
            case 5: {
                if (random.nextInt(2) != 0) break;
                return new ItemStack(ItemsLostAether.zanite_shield);
            }
            case 6: {
                if (random.nextInt(20) == 0) {
                    return new ItemStack(ItemsAether.ice_pendant);
                }
            }
            case 7: {
                if (random.nextInt(20) == 0) {
                    return new ItemStack(ItemsAether.ice_ring);
                }
            }
            case 8: {
                if (random.nextInt(15) != 0) break;
                return new ItemStack(ItemsAether.zanite_ring);
            }
        }
        return new ItemStack(BlocksAether.aercloud, random.nextInt(4) + 1);
    }

    public static ItemStack getPlatinumLoot(Random random) {
        int item = random.nextInt(11);
        switch (item) {
            case 0: {
                if (random.nextBoolean()) {
                    return new ItemStack(ItemsAether.welcoming_skies);
                }
                return new ItemStack(ItemsAether.legacy);
            }
            case 1: {
                if (random.nextBoolean()) {
                    return new ItemStack(ItemsLostAether.agility_boots);
                }
            }
            case 2: {
                return new ItemStack(ItemsLostAether.power_gloves);
            }
            case 3: {
                if (random.nextInt(4) == 0) {
                    return new ItemStack(ItemsLostAether.jeb_shield);
                }
            }
            case 4: {
                return new ItemStack(BlocksAether.enchanted_gravitite, random.nextInt(2) + 1);
            }
            case 5: {
                return new ItemStack(ItemsLostAether.sentry_shield);
            }
            case 6: {
                if (random.nextBoolean()) {
                    return new ItemStack(ItemsLostAether.invisibility_gem);
                }
            }
            case 7: {
                return new ItemStack(ItemsAether.life_shard);
            }
            case 8: {
                if (random.nextInt(6) == 0) {
                    return new ItemStack(ItemsAether.repulsion_shield);
                }
            }
            case 9: {
                if (random.nextInt(4) == 0) {
                    return new ItemStack(ItemsLostAether.phoenix_axe);
                }
                if (random.nextInt(6) == 0) {
                    return new ItemStack(ItemsLostAether.phoenix_pickaxe);
                }
                if (random.nextBoolean()) {
                    return new ItemStack(ItemsLostAether.phoenix_shovel);
                }
                if (random.nextInt(5) != 0) break;
                return new ItemStack(ItemsLostAether.phoenix_sword);
            }
        }
        return new ItemStack(ItemsAether.cloud_staff);
    }
}

