/*
 * Decompiled with CFR 0.152.
 */
package zairus.megaloot.block;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import zairus.megaloot.block.MLBlockDisenchanter;
import zairus.megaloot.block.MLBlockEvolutionChamber;
import zairus.megaloot.block.MLBlockSkinTable;

@GameRegistry.ObjectHolder(value="megaloot")
public class MLBlocks {
    @GameRegistry.ObjectHolder(value="skin_table")
    public static final Block SKIN_TABLE;
    @GameRegistry.ObjectHolder(value="disenchanter")
    public static final Block DISENCHANTER;
    @GameRegistry.ObjectHolder(value="evolution_chamber")
    public static final Block EVOLUTION_CHAMBER;
    protected static final List<Block> BLOCKS;

    public static void initialize() {
    }

    public static Block initBlock(Block block, String id) {
        block.setRegistryName(new ResourceLocation("megaloot", id));
        block.func_149663_c(id);
        BLOCKS.add(block);
        return block;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModels() {
        for (Block block : BLOCKS) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation("megaloot:" + block.func_149739_a().substring(5), "inventory"));
        }
    }

    static {
        BLOCKS = new ArrayList<Block>();
        SKIN_TABLE = MLBlocks.initBlock((Block)new MLBlockSkinTable(), "skin_table");
        DISENCHANTER = MLBlocks.initBlock((Block)new MLBlockDisenchanter(), "disenchanter");
        EVOLUTION_CHAMBER = MLBlocks.initBlock((Block)new MLBlockEvolutionChamber(), "evolution_chamber");
    }

    @Mod.EventBusSubscriber(modid="megaloot")
    public static class BlockRegistry {
        public static final Set<ItemBlock> ITEM_BLOCKS = new HashSet<ItemBlock>();

        @SubscribeEvent
        public static void newRegistry(RegistryEvent.NewRegistry event) {
        }

        @SubscribeEvent
        public static void register(RegistryEvent.Register<Block> event) {
            IForgeRegistry registry = event.getRegistry();
            registry.registerAll((IForgeRegistryEntry[])BLOCKS.toArray(new Block[0]));
        }

        @SubscribeEvent
        public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
            IForgeRegistry registry = event.getRegistry();
            for (Block block : BLOCKS) {
                ResourceLocation registryName = (ResourceLocation)Preconditions.checkNotNull((Object)block.getRegistryName(), (String)"Block %s has null registry name", (Object)block);
                ItemBlock item = new ItemBlock(block);
                registry.register(item.setRegistryName(registryName));
                ITEM_BLOCKS.add(item);
            }
        }
    }
}

