/*
 * Decompiled with CFR 0.152.
 */
package zairus.megaloot.item;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import zairus.megaloot.MegaLoot;
import zairus.megaloot.loot.ILootEffectAction;
import zairus.megaloot.loot.LootItemHelper;
import zairus.megaloot.loot.LootRarity;
import zairus.megaloot.loot.LootWeaponEffect;

public class MLItem
extends Item {
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    public static final String WEAPONCASE_COMMON_ID = "weaponcase_common";
    public static final String WEAPONCASE_RARE_ID = "weaponcase_rare";
    public static final String WEAPONCASE_EPIC_ID = "weaponcase_epic";
    public static final String WEAPONSWORD_ID = "weaponsword";
    public static final String WEAPONBOW_ID = "weaponbow";
    public static final String BAUBLERING_ID = "baublering";
    public static final String ARMOR_BOOTS_ID = "armor_boots";
    public static final String ARMOR_LEGGINGS_D = "armor_leggings";
    public static final String ARMOR_CHESTPLATE_ID = "armor_chestplate";
    public static final String ARMOR_HELMET_ID = "armor_helmet";
    public static final String TOOL_AXE_ID = "tool_axe";
    public static final String TOOL_PICKAXE_ID = "tool_pickaxe";
    public static final String TOOL_SHOVEL_ID = "tool_shovel";
    public static final String SHARD_COMMON_ID = "shard_common";
    public static final String SHARD_RARE_ID = "shard_rare";
    public static final String SHARD_EPIC_ID = "shard_epic";
    public static final String UPGRADECHARM_COMMON_ID = "upgradecharm_common";
    public static final String UPGRADECHARM_RARE_ID = "upgradecharm_rare";
    public static final String UPGRADECHARM_EPIC_ID = "upgradecharm_epic";
    public static final String RIFT_STONE_ID = "rift_stone";
    public static final String INFUSED_EMERALD_COMMON_ID = "infused_emerald_common";
    public static final String INFUSED_EMERALD_RARE_ID = "infused_emerald_rare";
    public static final String LOOT_TAG = "MegaLoot";
    public static final String LOOT_TAG_NAME = "loot_name";
    public static final String LOOT_TAG_LOOTSET = "loot_set";
    public static final String LOOT_TAG_RARITY = "rarity";
    public static final String LOOT_TAG_MODEL = "model";
    public static final String LOOT_TAG_DAMAGE = "damage";
    public static final String LOOT_TAG_SPEED = "speed";
    public static final String LOOT_TAG_ARMOR = "armor";
    public static final String LOOT_TAG_TOUGHNESS = "toughness";
    public static final String LOOT_TAG_EFFICIENCY = "efficiency";
    public static final String LOOT_TAG_DURABILITY = "durability";
    public static final String LOOT_TAG_KILLS = "playerkills";
    public static final String LOOT_TAG_EFFECTLIST = "effectList";
    public static final String LOOT_TAG_DRAWSPEED = "drawspeed";
    public static final String LOOT_TAG_MULTISHOT = "miltishot";
    public static final String LOOT_TAG_POWER = "power";
    public static final String LOOT_TAG_UUID = "uuid";
    public static final String LOOT_TAG_SKIN_LIST = "loot_skins";
    public static final String LOOT_TAG_EFFECT_ACTIVE = "effect_active";
    public static final String LOOT_TAG_EFFECT_LEVEL = "effect_level";
    public static final String LOOT_TAG_UPGRADES = "upgrades";

    protected MLItem() {
        this.func_77637_a(MegaLoot.creativeTabMain);
    }

    public String func_77653_i(ItemStack stack) {
        String displayName = super.func_77653_i(stack);
        LootRarity rarity = LootRarity.fromId(LootItemHelper.getLootStringValue(stack, LOOT_TAG_RARITY));
        if (rarity != null) {
            displayName = rarity.getColor() + displayName;
        }
        return displayName;
    }

    public static String getMegaLootDisplayName(ItemStack stack, String current) {
        String displayName = current;
        LootRarity rarity = LootRarity.fromId(LootItemHelper.getLootStringValue(stack, LOOT_TAG_RARITY));
        String megaLootName = LootItemHelper.getLootStringValue(stack, LOOT_TAG_NAME);
        String string = displayName = megaLootName.length() > 0 ? megaLootName : displayName;
        if (rarity != null) {
            displayName = rarity.getColor() + displayName;
        }
        return displayName;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap<String, AttributeModifier> modifiers = MLItem.modifiersForStack(slot, stack, (Multimap<String, AttributeModifier>)super.getAttributeModifiers(slot, stack), "Weapon modifier");
        return modifiers;
    }

    public static void applyEffects(ItemStack stack, EntityPlayer player) {
        MLItem.applyEffects(stack, player, 0, true);
    }

    public static ActionResult<ItemStack> use(ActionResult<ItemStack> defaultAction, World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184614_ca();
        List<LootWeaponEffect> effects = LootWeaponEffect.getEffectList(stack);
        if (effects != null) {
            for (LootWeaponEffect effect : effects) {
                ILootEffectAction action;
                if (effect == null || (action = effect.getAction()) == null) continue;
                defaultAction = action.handleUse(defaultAction, world, player, hand);
            }
        }
        return defaultAction;
    }

    public static void applyEffects(ItemStack stack, EntityPlayer player, int slot, boolean isSelected) {
        List<LootWeaponEffect> effects = LootWeaponEffect.getEffectList(stack);
        if (effects != null) {
            for (LootWeaponEffect effect : effects) {
                ILootEffectAction action;
                if (effect == null) continue;
                PotionEffect pe = effect.getPotionEffect(240, LootWeaponEffect.getAmplifierFromStack(stack, effect.getId()));
                if (pe != null) {
                    player.func_70690_d(pe);
                }
                if ((action = effect.getAction()) == null) continue;
                action.handleUpdate(stack, player.field_70170_p, (Entity)player, slot, isSelected);
            }
        }
    }

    public static float getEfficiency(ItemStack stack, IBlockState state) {
        float efficiency = LootItemHelper.getLootFloatValue(stack, LOOT_TAG_EFFICIENCY);
        for (String type : stack.func_77973_b().getToolClasses(stack)) {
            Material material = state.func_185904_a();
            if (!state.func_177230_c().isToolEffective(type, state) && (type != "pickaxe" || material != Material.field_151573_f && material != Material.field_151574_g && material != Material.field_151576_e) && (type != "axe" || material != Material.field_151575_d && material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151584_j) && !LootItemHelper.hasEffect(stack, LootWeaponEffect.MULTI)) continue;
            return efficiency;
        }
        return 1.0f;
    }

    public static Multimap<String, AttributeModifier> modifiersForStack(EntityEquipmentSlot slot, ItemStack stack, Multimap<String, AttributeModifier> initial, String modifierKey) {
        return MLItem.modifiersForStack(slot, EntityEquipmentSlot.MAINHAND, stack, initial, modifierKey);
    }

    public static Multimap<String, AttributeModifier> modifiersForStack(EntityEquipmentSlot slot, EntityEquipmentSlot effectiveSlot, ItemStack stack, Multimap<String, AttributeModifier> initial, String modifierKey) {
        Multimap<String, AttributeModifier> modifiers = initial;
        if (slot == effectiveSlot) {
            int attackDamage = LootItemHelper.getLootIntValue(stack, LOOT_TAG_DAMAGE);
            float attackSpeed = LootItemHelper.getLootFloatValue(stack, LOOT_TAG_SPEED);
            float armorPoints = LootItemHelper.getLootFloatValue(stack, LOOT_TAG_ARMOR);
            float armorToughness = LootItemHelper.getLootFloatValue(stack, LOOT_TAG_TOUGHNESS);
            if (attackDamage > 0) {
                MLItem.applyAttributeModifier(modifiers, SharedMonsterAttributes.field_111264_e, field_111210_e, modifierKey, attackDamage);
            }
            if (attackSpeed > 0.0f) {
                MLItem.applyAttributeModifier(modifiers, SharedMonsterAttributes.field_188790_f, field_185050_h, modifierKey, attackSpeed);
            }
            if (armorPoints > 0.0f) {
                MLItem.applyAttributeModifier(modifiers, SharedMonsterAttributes.field_188791_g, ARMOR_MODIFIERS[slot.func_188454_b()], modifierKey, armorPoints);
            }
            if (armorToughness > 0.0f) {
                MLItem.applyAttributeModifier(modifiers, SharedMonsterAttributes.field_189429_h, ARMOR_MODIFIERS[slot.func_188454_b()], modifierKey, armorToughness);
            }
            List<LootWeaponEffect> effects = LootWeaponEffect.getEffectList(stack);
            String uuid_string = LootItemHelper.getLootStringValue(stack, LOOT_TAG_UUID);
            if (uuid_string.length() > 0) {
                for (LootWeaponEffect effect : effects) {
                    if (effect.getAttribute() == null) continue;
                    modifiers.put((Object)effect.getAttribute().func_111108_a(), (Object)new AttributeModifier(UUID.fromString(uuid_string), "Equipment modifier", (double)LootWeaponEffect.getAmplifierFromStack(stack, effect.getId()), 0));
                }
            }
        }
        return modifiers;
    }

    private static void applyAttributeModifier(Multimap<String, AttributeModifier> modifiers, IAttribute attribute, UUID uuid, String modifierKey, double value) {
        ArrayList curModifiers = new ArrayList();
        double attributeValue = 0.0;
        curModifiers.clear();
        curModifiers.addAll(modifiers.get((Object)attribute.func_111108_a()));
        for (AttributeModifier m : curModifiers) {
            attributeValue += m.func_111164_d();
        }
        modifiers.removeAll((Object)attribute.func_111108_a());
        modifiers.put((Object)attribute.func_111108_a(), (Object)new AttributeModifier(uuid, modifierKey, value + attributeValue, 0));
    }

    public static void handleEffectsAfterHit(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        List<LootWeaponEffect> effects;
        if (target instanceof EntityPlayer && (double)target.func_110143_aJ() <= 0.0) {
            int kills = LootItemHelper.getLootIntValue(stack, LOOT_TAG_KILLS);
            LootItemHelper.setLootIntValue(stack, LOOT_TAG_KILLS, ++kills);
        }
        if ((effects = LootWeaponEffect.getEffectList(stack)).size() > 0) {
            for (LootWeaponEffect effect : effects) {
                effect.onHit(LootWeaponEffect.getDurationFromStack(stack, effect.getId()), LootWeaponEffect.getAmplifierFromStack(stack, effect.getId()), target, attacker);
            }
        }
    }

    public static boolean breakBlocks(ItemStack stack, int level, World world, BlockPos aPos, EnumFacing side, EntityPlayer player) {
        IBlockState theState;
        int xradN = 0;
        int xradP = 0;
        int yradN = 0;
        int yradP = 0;
        int zradN = 0;
        int zradP = 0;
        switch (level) {
            case 1: {
                xradN = 0;
                xradP = 1;
                yradN = 1;
                yradP = 0;
                zradN = 0;
                zradP = 0;
                break;
            }
            case 2: {
                xradN = 1;
                xradP = 1;
                yradN = 1;
                yradP = 1;
                zradN = 0;
                zradP = 0;
                break;
            }
            case 3: {
                xradN = 1;
                xradP = 2;
                yradN = 1;
                yradP = 2;
                zradN = 0;
                zradP = 0;
                break;
            }
            case 4: {
                xradN = 2;
                xradP = 2;
                yradN = 2;
                yradP = 2;
                zradN = 0;
                zradP = 0;
                break;
            }
            default: {
                xradN = 0;
                xradP = 0;
                yradN = 0;
                yradP = 0;
                zradN = 0;
                zradP = 0;
            }
        }
        if (side.func_176740_k() == EnumFacing.Axis.Y) {
            zradN = xradN;
            zradP = xradP;
            yradN = 0;
            yradP = 0;
        }
        if (side.func_176740_k() == EnumFacing.Axis.X) {
            xradN = 0;
            xradP = 0;
            zradN = yradN;
            zradP = yradP;
        }
        IBlockState state = world.func_180495_p(aPos);
        float mainHardness = state.func_185887_b(world, aPos);
        if (!MLItem.tryHarvestBlock(world, aPos, false, stack, player)) {
            return false;
        }
        if (level == 4 && side.func_176740_k() != EnumFacing.Axis.Y && (theState = world.func_180495_p(aPos = aPos.func_177984_a())).func_185887_b(world, aPos) <= mainHardness + 5.0f) {
            MLItem.tryHarvestBlock(world, aPos, true, stack, player);
        }
        if (level > 0 && mainHardness >= 0.2f) {
            for (int xPos = aPos.func_177958_n() - xradN; xPos <= aPos.func_177958_n() + xradP; ++xPos) {
                for (int yPos = aPos.func_177956_o() - yradN; yPos <= aPos.func_177956_o() + yradP; ++yPos) {
                    for (int zPos = aPos.func_177952_p() - zradN; zPos <= aPos.func_177952_p() + zradP; ++zPos) {
                        BlockPos thePos;
                        IBlockState theState2;
                        if (aPos.func_177958_n() == xPos && aPos.func_177956_o() == yPos && aPos.func_177952_p() == zPos || !((theState2 = world.func_180495_p(thePos = new BlockPos(xPos, yPos, zPos))).func_185887_b(world, thePos) <= mainHardness + 5.0f)) continue;
                        MLItem.tryHarvestBlock(world, thePos, true, stack, player);
                    }
                }
            }
        }
        return true;
    }

    public static boolean tryHarvestBlock(World world, BlockPos pos, boolean isExtra, ItemStack stack, EntityPlayer player) {
        boolean canHarvest;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        float hardness = state.func_185887_b(world, pos);
        boolean bl = canHarvest = !(!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos) && !stack.func_77973_b().canHarvestBlock(state, stack) || isExtra && !(stack.func_77973_b().func_150893_a(stack, world.func_180495_p(pos)) > 1.0f));
        if (hardness >= 0.0f && (!isExtra || canHarvest && !block.hasTileEntity(world.func_180495_p(pos)))) {
            return MLItem.breakExtraBlock(stack, world, player, pos);
        }
        return false;
    }

    public static boolean breakExtraBlock(ItemStack stack, World world, EntityPlayer player, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (player.field_71075_bZ.field_75098_d) {
            if (block.removedByPlayer(state, world, pos, player, false)) {
                block.func_176206_d(world, pos, state);
            }
            if (!world.field_72995_K) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
            }
            return true;
        }
        stack.func_179548_a(world, state, pos, player);
        if (!world.field_72995_K) {
            int xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((EntityPlayerMP)player).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)player), (BlockPos)pos);
            if (xp == -1) {
                return false;
            }
            TileEntity tileEntity = world.func_175625_s(pos);
            if (block.removedByPlayer(state, world, pos, player, true)) {
                block.func_176206_d(world, pos, state);
                block.func_180657_a(world, player, pos, state, tileEntity, stack);
                block.func_180637_b(world, pos, xp);
            }
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
            return true;
        }
        world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
        if (block.removedByPlayer(state, world, pos, player, true)) {
            block.func_176206_d(world, pos, state);
        }
        stack.func_179548_a(world, state, pos, player);
        MegaLoot.proxy.sendBlockBreakPacket(pos);
        return true;
    }

    public static RayTraceResult getBlockOnReach(World world, EntityPlayer player) {
        double distance = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        float pitch = player.field_70125_A;
        float yaw = player.field_70177_z;
        double x = player.field_70165_t;
        double y = player.field_70163_u + (double)player.func_70047_e();
        double z = player.field_70161_v;
        Vec3d vec3 = new Vec3d(x, y, z);
        float f2 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        Vec3d vec31 = vec3.func_72441_c((double)f6 * distance, (double)f5 * distance, (double)f7 * distance);
        boolean stopOnLiquids = false;
        boolean ignoreNoBoundingBox = true;
        boolean returnLastUncollidable = false;
        return world.func_147447_a(vec3, vec31, stopOnLiquids, ignoreNoBoundingBox, returnLastUncollidable);
    }
}

