/*
 * Decompiled with CFR 0.152.
 */
package zairus.megaloot.item;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zairus.megaloot.MLConfig;
import zairus.megaloot.MegaLoot;
import zairus.megaloot.item.IMegaLoot;
import zairus.megaloot.item.MLItem;
import zairus.megaloot.item.MLItems;
import zairus.megaloot.loot.LootItemHelper;
import zairus.megaloot.loot.LootSet;
import zairus.megaloot.loot.LootWeaponEffect;

public class MLItemArmor
extends ItemArmor
implements IMegaLoot {
    protected MLItemArmor(EntityEquipmentSlot equipmentSlot) {
        super(ItemArmor.ArmorMaterial.DIAMOND, 3, equipmentSlot);
        this.func_77637_a(MegaLoot.creativeTabMain);
        this.setNoRepair();
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)field_96605_cw);
        this.func_185043_a(new ResourceLocation("model"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                float model = 1.0f;
                String lootSetId = LootItemHelper.getLootStringValue(stack, "loot_set");
                LootSet lootSet = LootSet.getById(lootSetId);
                if (lootSet != null) {
                    model = lootSet.itemModel;
                }
                return model;
            }
        });
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public String func_77667_c(ItemStack stack) {
        String unlocalizedName = super.func_77667_c(stack);
        String lootSetId = LootItemHelper.getLootStringValue(stack, "loot_set");
        return unlocalizedName + (lootSetId.equals("") ? "" : "." + lootSetId);
    }

    public String func_77653_i(ItemStack stack) {
        return MLItem.getMegaLootDisplayName(stack, super.func_77653_i(stack));
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        String lootSetId = LootItemHelper.getLootStringValue(itemStack, "loot_set");
        return LootSet.getArmorModel(LootSet.getById(lootSetId), MLItems.getItemType(itemStack.func_77973_b()));
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        String lootSetId = LootItemHelper.getLootStringValue(stack, "loot_set");
        String textureString = "megaloot:textures/models/armor/1.png";
        if (lootSetId != null && lootSetId.length() > 0) {
            textureString = "megaloot:textures/models/armor/" + lootSetId + ".png";
        }
        return textureString;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap<String, AttributeModifier> modifiers = MLItem.modifiersForStack(slot, this.field_77881_a, stack, (Multimap<String, AttributeModifier>)super.getAttributeModifiers(slot, stack), "Armor modifier");
        return modifiers;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        BonusHelper helper = new BonusHelper();
        helper.add(this.getSetIdFromSlot(player, EntityEquipmentSlot.FEET));
        helper.add(this.getSetIdFromSlot(player, EntityEquipmentSlot.LEGS));
        helper.add(this.getSetIdFromSlot(player, EntityEquipmentSlot.CHEST));
        helper.add(this.getSetIdFromSlot(player, EntityEquipmentSlot.HEAD));
        List<String> setIds = helper.getGreatherThan(MLConfig.armorPiecesForBonus);
        for (String setId : setIds) {
            player.func_70690_d(LootSet.getById((String)setId).bonusEffect.getPotionEffect(2, 0));
        }
    }

    private String getSetIdFromSlot(EntityPlayer player, EntityEquipmentSlot equipmentSlot) {
        String setId = "";
        ItemStack stack = player.func_184582_a(equipmentSlot);
        if (stack != null) {
            setId = LootItemHelper.getLootStringValue(stack, "loot_set");
        }
        return setId;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        if (GuiScreen.func_146272_n()) {
            String set_id = LootItemHelper.getLootStringValue(stack, "loot_set").toUpperCase();
            tooltip.add(TextFormatting.BOLD + "" + TextFormatting.WHITE + "" + set_id + TextFormatting.RESET + "" + TextFormatting.GRAY + " Set");
            LootSet set = LootSet.getById(set_id.toLowerCase());
            LootWeaponEffect effect = set.bonusEffect;
            tooltip.add("If wearing " + MLConfig.armorPiecesForBonus + " pieces:");
            tooltip.add(I18n.func_74837_a((String)("weaponeffect." + effect.getId() + ".description"), (Object[])new Object[]{effect.getDurationString(stack, effect.getId()), effect.getAmplifierString(stack, effect.getId()), effect.getAmplifierString(stack, effect.getId(), 1)}));
            LootItemHelper.addInformation(stack, tooltip, false);
        } else {
            for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
                Multimap multimap = stack.func_111283_C(entityequipmentslot);
                if (multimap.isEmpty() || entityequipmentslot == EntityEquipmentSlot.MAINHAND) continue;
                tooltip.add(I18n.func_74838_a((String)("item.modifiers." + entityequipmentslot.func_188450_d())));
                for (Map.Entry entry : multimap.entries()) {
                    if (!((String)entry.getKey()).equals("generic.armorToughness") && !((String)entry.getKey()).equals("generic.armor")) continue;
                    AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                    double d0 = attributemodifier.func_111164_d();
                    EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                    if (player != null) {
                        // empty if block
                    }
                    double d1 = attributemodifier.func_111169_c() != 1 && attributemodifier.func_111169_c() != 2 ? d0 : d0 * 100.0;
                    if (d0 > 0.0) {
                        tooltip.add(TextFormatting.BLUE + " " + I18n.func_74837_a((String)("attribute.modifier.plus." + attributemodifier.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1), I18n.func_74838_a((String)("attribute.name." + (String)entry.getKey()))}));
                        continue;
                    }
                    if (!(d0 < 0.0)) continue;
                    tooltip.add(TextFormatting.RED + " " + I18n.func_74837_a((String)("attribute.modifier.take." + attributemodifier.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), I18n.func_74838_a((String)("attribute.name." + (String)entry.getKey()))}));
                }
            }
            tooltip.add(TextFormatting.AQUA + "" + TextFormatting.ITALIC + "Shift" + TextFormatting.DARK_GRAY + " for more...");
        }
    }

    public int getMaxDamage(ItemStack stack) {
        return LootItemHelper.getMaxDamage(stack);
    }

    private class BonusHelper {
        private final Map<String, Integer> sets = new HashMap<String, Integer>();

        private BonusHelper() {
        }

        public void add(String setId) {
            if (setId == "") {
                return;
            }
            if (!this.sets.containsKey(setId)) {
                this.sets.put(setId, 1);
            } else {
                int curValue = this.sets.get(setId);
                this.sets.put(setId, ++curValue);
            }
        }

        public List<String> getGreatherThan(int value) {
            ArrayList<String> ids = new ArrayList<String>();
            for (String id : this.sets.keySet()) {
                if (this.sets.get(id) < value) continue;
                ids.add(id);
            }
            return ids;
        }
    }
}

